package gov.va.med.esr.ui.workflow.action;

// Java classes
import gov.va.med.esr.common.model.cases.WorkflowCase;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.EntityKeyFactory;
import gov.va.med.fw.util.StringUtils;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class WorkItemAction extends WorkflowAction {

    public static final String PARAM_SELECTED_CASE_ID = "selectedCaseId";
    
    public WorkItemAction() {
        super();
    }

    /**
     * Display the selected work flow case information
     */
    /**
     * @param mapping
     * @param form
     * @param request
     * @param response
     * @return
     * @throws Exception
     */
    public ActionForward display(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {

        // Get the selected message id 
        String caseId = request.getParameter(PARAM_SELECTED_CASE_ID);
        if (StringUtils.isEmpty(caseId)){
            //get it from the request
            caseId = (String) request.getAttribute(PARAM_SELECTED_CASE_ID);
        }
        setPristineEntity(request, null);
        setUpdatedEntity(request, null);

        WorkItemForm workItemForm = (WorkItemForm) form;

        //Find and load the case information
        EntityKey entityKey = 
            EntityKeyFactory.createEntityKey(new BigDecimal(caseId), WorkflowCase.class);

        WorkflowCase workflowCase = getWorkflowService().find(entityKey);

        if (workflowCase != null) {
            setPristineEntity(request, workflowCase);
            conversionService.convert(workflowCase,workItemForm);
        } else {
            throw new Exception("Workflow Case not found");
        }

        return mapping.findForward("success");
    }

    public ActionForward update(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {

        WorkItemForm workItemForm = (WorkItemForm) form;

        // get the saved workflow case from the session
        WorkflowCase pristineWorkflowCase = (WorkflowCase) getPristineEntity(request);
        WorkflowCase updatedWorkflowCase = (WorkflowCase) pristineWorkflowCase.clone();
        conversionService.convert(workItemForm,updatedWorkflowCase);

        getWorkflowService().updateWorkItem(updatedWorkflowCase);

        clearCachedResults(request);
        updateHeader(request);
        setPristineEntity(request,null);
        return mapping.findForward(getCurrentTab(request));
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) throws Exception {
    		setPristineEntity(request,null);
            return mapping.findForward("returnTo"+getCurrentTab(request));
    }
    
    protected ActionForward handleEntityNotChangedException(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) throws Exception
    {
            form.reset(mapping,request);
            WorkflowCase pristineWorkflowCase = (WorkflowCase) getPristineEntity(request);
            request.setAttribute(PARAM_SELECTED_CASE_ID, 
                    String.valueOf(pristineWorkflowCase.getEntityKey().getKeyValue()));
            return display(mapping,form,request,response);
     }
    
    protected ActionForward handleOptimisticLockException(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) throws Exception
    {
            form.reset(mapping,request);
            WorkflowCase pristineWorkflowCase = (WorkflowCase) getPristineEntity(request);
            request.setAttribute(PARAM_SELECTED_CASE_ID, 
                    String.valueOf(pristineWorkflowCase.getEntityKey().getKeyValue()));
            return display(mapping,form,request,response);
     }
    /**
     * Initialize and get the Struts lookup dispatch method map hashmap.
     * 
     * @see org.apache.struts.actions.LookupDispatchAction#getKeyMethodMap()
     * @return the method map
     */
    protected Map getKeyMethodMap() {
        Map map = new HashMap();
        map.put("button.update", "update");
        map.put("button.cancel", "cancel");
        map.put("button.display", "display");
        return map;
    }
}