/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.voa.action;

import java.util.ArrayList;
import java.util.List;

import org.apache.struts.action.ActionForm;

import gov.va.med.fw.service.pagination.SearchQueryInfo;
import gov.va.med.fw.ui.valuelist.SelectableSearchValueListAdapter;
import gov.va.med.fw.ui.valuelist.ValueListException;
import gov.va.med.fw.util.StringUtils;

import gov.va.med.esr.common.model.person.id.VPIDEntityKeyImpl;

import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.VOASearchCriteria;

import gov.va.med.esr.ui.common.util.DateUtils;

public class VOASearchValueListAdapter extends SelectableSearchValueListAdapter {

    private static final long serialVersionUID = 5159351847729993680L;
    
    private LookupService lookupService = null;

    public LookupService getLookupService() {
        return lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    /**
     * Performs a custom form to searchQueryInfo conversion to handle lookup data. It is assumed
     * that a valid state and form code exists on the passed in form.
     *
     * @param form The form that contains search parameters
     * @param searchQueryInfo The search query info object to populate with the search parameters.
     *
     * @throws ValueListException if there are any problems copying properties.
     */
    protected void populateFormAttributes(ActionForm form, SearchQueryInfo searchQueryInfo)
        throws ValueListException
    {
        // Typecase the parameters
        VOASearchForm searchForm = (VOASearchForm)form;
        VOASearchCriteria searchCriteria = (VOASearchCriteria)searchQueryInfo;

       // Convert the standard parameters

        searchCriteria.setApplicationId(searchForm.getApplicationId());
        searchCriteria.setLastName(searchForm.getLastName());
        searchCriteria.setFirstName(searchForm.getFirstName());
        searchCriteria.setFullQualifiedId(searchForm.getFullQualifiedId());
        searchCriteria.setSsn(searchForm.getSsn());
        searchCriteria.setDob(DateUtils.getDate(searchForm.getDob()));
        //searchCriteria.setGender(searchForm.getGender());
        searchCriteria.setReqRecdDateFrom(DateUtils.getDate(searchForm.getReqRecdDateFrom()));
        searchCriteria.setReqRecdDateTo(DateUtils.getDate(searchForm.getReqRecdDateTo()));
        searchCriteria.setFormType(searchForm.getFormType());
        searchCriteria.setFormTypeValue(searchForm.getFormTypeValue());
        searchCriteria.setFormPendingReason(searchForm.getFormPendingReason());
    }    
}
