/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.voa.action;

import java.math.BigDecimal;
import java.util.Date;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionMapping;

import gov.va.med.fw.ui.struts.AbstractForm;
import gov.va.med.fw.util.StringUtils;

import gov.va.med.esr.common.model.lookup.Gender;
import gov.va.med.esr.common.model.lookup.VOAFormType;
import gov.va.med.esr.ui.voa.action.VOAPendingListForm;


public class VOASearchForm extends AbstractForm {

	private static final long serialVersionUID = -5174556445149833102L;
    private String emptyHiddenField;
	private String searchType;
    private String searchField;
    private String searchValue;	
	private String applicationId = null;	
	private String lastName = null;
	private String firstName = null;	
	private String dateOfBirth = null;
	private String ssn = null;
	private Date responseTimeStamp = null;
	private String errorText = null;
	private String fullQualifiedId = null;
	private String reqRecdDateFrom = null;
	private String reqRecdDateTo = null;
	private BigDecimal formType = null;
	private String formTypeValue = null;
	private String gender = null;
	private boolean pendingSubmissions;
    private boolean selectAll;
	
    
    public VOASearchForm() {
        super();
        initialize();
    }

    public VOASearchForm(VOAPendingListForm form) {
        super();
        initialize();
        //copy the filter fields
        if (form != null) {
        	setApplicationId(form.getApplicationId()); 
            setLastName(form.getLastName());
            setFirstName(form.getFirstName());
            setFullQualifiedId(form.getFullQualifiedId());  
            setSsn(form.getSsn());
            setDob(form.getDob());
            setGender(form.getGender());
            setReqRecdDateFrom(form.getReqRecdDateFrom());
            setReqRecdDateTo(form.getReqRecdDateTo());
            setFormTypeValue(form.getFormTypeValue());
            setFormType(form.getFormType());
            setFormPendingReason(form.getFormPendingReason());
        }
    } 
    
    
    public String getEmptyHiddenField() {
        return this.emptyHiddenField;
    }

    public void setEmptyHiddenField(String emptyHiddenField) {
        this.emptyHiddenField = emptyHiddenField;
    }

    public String getSearchType() {
        return searchType;
    }

    public void setSearchType(String searchType) {
        this.searchType = searchType;
    }

    public String getSearchValue() {
        return searchValue;
    }

    public void setSearchValue(String searchValue) {
        this.searchValue = searchValue;
    }
	public String getApplicationId() {
		return this.applicationId;
	}

	public void setApplicationId(String applicationId) {
		this.applicationId = applicationId;
	}	
	
	public String getFullQualifiedId() {
		return fullQualifiedId;
	}

	public void setFullQualifiedId(String fullQualifiedId) {
		this.fullQualifiedId = fullQualifiedId;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}	

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}	
	
	
	public String getSsn() {
		return ssn;
	}
	public void setSsn(String ssn) {
		this.ssn = ssn;
	}
		
	public String getDob() {
		return dateOfBirth;
	}

	public void setDob(String dateOfBirth) {
		this.dateOfBirth = dateOfBirth;
	}

	public String getGender() {
		return gender;
	}

	public void setGender(String gender) {
		this.gender = gender;
	}
	
	public String getReqRecdDateFrom() {
		return reqRecdDateFrom;
	}

	public void setReqRecdDateFrom(String reqRecdDateFrom) {
		this.reqRecdDateFrom = reqRecdDateFrom;
	}

	public String getReqRecdDateTo() {
		return reqRecdDateTo;
	}

	public void setReqRecdDateTo(String reqRecdDateTo) {
		this.reqRecdDateTo = reqRecdDateTo;
	}
	
	public BigDecimal getFormType() {
		return formType;
	}

	public void setFormType(BigDecimal formType) {
		this.formType = formType;
	}

	
	public String getFormTypeValue() {
		return formTypeValue;
	}

	public void setFormTypeValue(String formTypeValue) {
		this.formTypeValue = formTypeValue;
	}	

	public String getFormPendingReason() {
		return errorText;
	}

	public void setFormPendingReason(String errorText) {
		this.errorText = errorText;
	}

	public boolean isPendingSubmissions() {
		return pendingSubmissions;
	}
	
	public void setPendingSubmissions(boolean pendingSubmissions) {
		this.pendingSubmissions = pendingSubmissions;
	}
	
    /**
     * Returns true if search criterai is empty
     * @return
     */
    public boolean isEmpty() {
        if (StringUtils.isNotEmpty(searchField)||
        	
            StringUtils.isNotEmpty(applicationId) ||
            StringUtils.isNotEmpty(ssn) ||
            StringUtils.isNotEmpty(lastName) ||
            StringUtils.isNotEmpty(firstName) ||            
            StringUtils.isNotEmpty(fullQualifiedId) ||
            StringUtils.isNotEmpty(ssn) ||
            StringUtils.isNotEmpty(dateOfBirth) ||
            StringUtils.isNotEmpty(gender) ||
            StringUtils.isNotEmpty(reqRecdDateFrom) ||
            StringUtils.isNotEmpty(reqRecdDateTo) ||
            StringUtils.isNotEmpty(formTypeValue) ||
            StringUtils.isNotEmpty(errorText)) {
            return false;
        }
        else {
            return true;
            
            
        }
    }
    
    public void reset(ActionMapping arg0, HttpServletRequest arg1) {
        super.reset(arg0, arg1);
        initialize();
    }

	public String getSearchField() {
		return this.searchField;
	}

	public void setSearchField(String searchField) {
		this.searchField = searchField;
	}

	public boolean isSelectAll() {
		return this.selectAll;
	}

	public void setSelectAll(boolean selectAll) {
		this.selectAll = selectAll;
	}
	private void initialize(){
        emptyHiddenField = null;
        searchType = null;
        searchField = null;
        searchValue = null;
        applicationId = null;
        ssn = null;
        lastName = null;
        firstName = null;        
        dateOfBirth = null;
        reqRecdDateFrom = null;
        reqRecdDateTo = null;
        errorText = null;
        fullQualifiedId = null;
        formType = null;
        gender = null;
        selectAll = false;
        pendingSubmissions = false;
    }
    public void clear() {
        this.applicationId = null;
        this.ssn = null;
        this.lastName = null;
        this.firstName = null;       
        this.dateOfBirth = null;
        this.reqRecdDateFrom = null;
        this.reqRecdDateTo = null;
        this.errorText = null;
        this.fullQualifiedId = null;
        this.formType = null;
        this.gender = null;
    }
}
