package gov.va.med.esr.ui.voa.action;
import gov.va.med.esr.ui.conversion.UIConversionServiceImpl;
import gov.va.med.fw.conversion.ConversionServiceException;
import gov.va.med.esr.common.model.person.VOAApplication;
import gov.va.med.esr.ui.voa.action.VOAPendingListForm;
import gov.va.med.esr.service.VOASearchResultBean;


/**
 * Converts from VOAApplication to VOAPendingListForm.
 *
 * @author Amy Jones
 */
public class VOAResubmissionConversionService extends UIConversionServiceImpl {
    
	public VOAResubmissionConversionService() {
        super();
    }
    /**
     * Converts between a VOAApplication object and the VOAPendingListForm. It only converts VOA Application to Form and not
     * vice versa.
     *
     * @param source the source object
     * @param target the target object
     *
     * @throws gov.va.med.fw.conversion.ConversionServiceException if any errors were encountered during the
     * conversion.
     */
	
    @Override
	protected void convertBean(Object source, Object target) throws ConversionServiceException
    {
        if ((source instanceof VOAApplication) && (target instanceof VOAPendingListForm))
        {
            convert(source, target);
        }
        else
        {
            throw new ConversionServiceException(
                    "Type mismatch: Can't convert from " + source.getClass().getName() + " to "
                        + target.getClass().getName());
           
        }
    }

 
   private void convert(VOASearchResultBean voaBean, VOAPendingListForm form)
		throws ConversionServiceException { 
        try
        {
            // Populate data from the VOAApplication object

        	form.setApplicationId(voaBean.getApplicationId().toString()); 
            form.setLastName(voaBean.getLastName());
            form.setFirstName(voaBean.getFirstName());
            form.setFullQualifiedId(voaBean.getFullQualifiedId());  
            form.setSsn(voaBean.getSsn());
            form.setDob(voaBean.getDateOfBirth().toString());
            form.setGender(voaBean.getGender().toString());
            form.setReqRecdDate(voaBean.getReceiveTimeStamp().toString());
            //form.setFormType(voaBean.getFormType().toString());
            form.setFormPendingReason(voaBean.getErrorText().toString());
        

         }
        catch (Exception ex)
        {
            throw new ConversionServiceException("Conversion Failed", ex);
        }
    }

   
}
