package gov.va.med.esr.ui.voa.action;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mlw.vlh.ValueList;
import net.mlw.vlh.ValueListInfo;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import gov.va.med.esr.service.VOASearchResultBean;
import gov.va.med.esr.ui.common.action.AbstractAction;
import gov.va.med.fw.service.EntityNotChangedException;
import gov.va.med.fw.service.ServiceOptimisticLockException;
import gov.va.med.fw.ui.struts.ValueListActionUtils;
import gov.va.med.fw.ui.valuelist.SelectableResult;
import gov.va.med.esr.ui.voa.action.VOAPendingListForm;

/**
 * @author DNS   jonesa
0
 */
public class VOAResubmissionAction extends AbstractAction
{
    /**
     * The maximum number of characters to fit on 1 line of a raw message.
     */
    public static final int MAX_CHARS_PER_LINE = 100;

    /**
     * The minimum number of rows that will be displayed for a raw message.
     */
    public static final String PARAM_SELECTED_PENDING_SUBMISSION = "selectedPendingSubmission";
    public static final int MIN_RAW_MESSAGE_ROWS = 22;
    public static final String VALUE_LIST = "vlhlist";

    public static final String DISPLAY = "display";
    public static final String DISPLAY_SEARCH = "displaySearch";
    public static String FWD_SEARCH_RESULTS = "searchResults";
    public static final String DISPLAY_VOA_RESUBMISSION = "displayVOAResubmission";
    public static final String VOA_SEARCH_TABLE_ID = "voaResubmissionSearchTableId";
    public static final String VOA_SEARCH_ADAPTER = "voaSearchAdapter";
    public static String FWD_PENDING_SUBMISSIONS = "pendingSubmissions";

    //private MessageFormatterService    messageFormatterService;


    /**
     * Displays transmission search screen.
     *
     * @param mapping Struts action mapping for this action
     * @param actionForm Struts form bean for this action
     * @param request The Http Request
     * @param response The Http Response
     *
     * @return A struts action forward for where we will go next.
     * @throws Exception If there are any errors during processing.
     */

    protected void getPendingSubmissions(HttpServletRequest request,VOAPendingListForm form) throws Exception {
        VOASearchForm searchForm = new VOASearchForm(form);
        getVOAApplications(request, searchForm);
    }


    protected void getVOAApplications(HttpServletRequest request, VOASearchForm searchForm){

        // Get the value list information
        ValueList valueList = ValueListActionUtils.getValueList(searchForm,
            request, VOA_SEARCH_TABLE_ID, VOA_SEARCH_ADAPTER);

        // Check if any results were found
        ValueListInfo info = valueList.getValueListInfo();

        if (info.getTotalNumberOfEntries() > 0)
        {
            // Backup the ValueListInfo into session and store the resultant ValueList on the request
            ValueListActionUtils
                .setValueList(request, valueList, VALUE_LIST);

        }
    }

    protected List getSelectedPendingSubmissions(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response) {
        // Get the value list information
       ValueList valueList = ValueListActionUtils.getSelectableResultValuleList(form,
            request, VOA_SEARCH_TABLE_ID, VOA_SEARCH_ADAPTER, null);

        // Backup the ValueListInfo into session and store the resultant ValueList on the request
        //ValueListActionUtils
        //    .setValueList(request, valueList, VALUELIST);

        //Get selectedResults from Session instead of from ValueList, which is a SubList
        List selectedResults = ValueListActionUtils.getSelectedResultsFromPreviousPage(
                    request, VOA_SEARCH_TABLE_ID, new Boolean(true));

        ArrayList selectedPendingSubmissions = new ArrayList();

        // Check if the user selected any items
        if ((selectedResults != null) && (selectedResults.size() > 0)) {
            for (Iterator iterator = selectedResults.iterator(); iterator.hasNext();)
            {
                SelectableResult selectableResult = (SelectableResult)iterator.next();
                VOASearchResultBean voaSearchResultBean =
                    (VOASearchResultBean)selectableResult.getResult();
                selectedPendingSubmissions.add(voaSearchResultBean.getApplicationId());
            }
        }

        // Process the selected entries
        return selectedPendingSubmissions;
    }

    @Override
	protected void processOptimisticLockException(HttpServletRequest request,
            ServiceOptimisticLockException ex) throws Exception
    {
        // Add the generic error message
        addActionMessage(request,OPTIMISTC_LOCK_ERROR_KEY);
    }

    protected void clearCachedResults(HttpServletRequest request) {
    	ValueListActionUtils.clearCachedResults(request.getSession(), VOA_SEARCH_TABLE_ID);
    }

    @Override
	protected void processEntityNotChangedException(HttpServletRequest request, EntityNotChangedException ex) throws Exception
    {
        // Add information message
        addInformationMessage(request, DATA_NOT_CHANGED_MESSAGE_KEY);
    }

    @Override
	public void afterPropertiesSet()
    {
    }
}
