/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.voa.action;

// Java classes
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionMapping;
import gov.va.med.fw.ui.struts.AbstractForm;
import java.math.BigDecimal;

/**
 * Form to store the user actions and selections for VOA Resubmission
 * 
 * @author DNS   JONESA
 * 
 */
public class VOAPendingListForm extends AbstractForm {

	private static final long serialVersionUID = 4280428772657653153L;
    //Filter section
	private String applicationId = null;
	private BigDecimal personId = null;
	private String lastName = null;
	private String firstName = null;	
	private String ssn = null;
	private String dob = null;
	private String gender = null;
	private String reqRecdDate = null;
	private String reqRecdDateFrom = null;
	private String reqRecdDateTo = null;
	private BigDecimal formType = null;
	private String formTypeValue = null;
	private String fullQualifiedId = null;
	private String formPendingReason = null;	

	//Action header 
    private String resubmitAction = null;
    private String returnLink = null;

    public VOAPendingListForm() {
        super();
        clear();
    }
    
	/**
	 * @return Returns the applicationId.
	 */
	public String getApplicationId() {
		return this.applicationId;
	}

	public void setApplicationId(String applicationId) {
		this.applicationId = applicationId;
	}	
	
	public BigDecimal getPersonId() {
		return personId;
	}

	public void setPersonId(BigDecimal personId) {
		this.personId = personId;
	}

	public String getLastName() {
		return lastName;
	}

	public String getFirstName() {
		return firstName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}	
	
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}			
	
	public String getSsn() {
		return ssn;
	}
	public void setSsn(String ssn) {
		this.ssn = ssn;
	}
		
	public String getDob() {
		return dob;
	}

	public void setDob(String dob) {
		this.dob = dob;
	}

	public String getGender() {
		return gender;
	}

	public void setGender(String gender) {
		this.gender = gender;
	}

	public String getReqRecdDate() {
		return reqRecdDate;
	}

	public void setReqRecdDate(String reqRecdDate) {
		this.reqRecdDate = reqRecdDate;
	}

	public String getReqRecdDateFrom() {
		return reqRecdDateFrom;
	}

	public void setReqRecdDateFrom(String reqRecdDateFrom) {
		this.reqRecdDateFrom = reqRecdDateFrom;
		
	}

	public String getReqRecdDateTo() {
		return reqRecdDateTo;
	}

	public void setReqRecdDateTo(String reqRecdDateTo) {
		this.reqRecdDateTo = reqRecdDateTo;
		
	}

	public String getFullQualifiedId() {
		return fullQualifiedId;
	}

	public void setFullQualifiedId(String fullQualifiedId) {
		this.fullQualifiedId = fullQualifiedId;
	}
	
	public BigDecimal getFormType() {
		return formType;
	}

	public void setFormType(BigDecimal formType) {
		this.formType = formType;
	}
	
	public String getFormTypeValue() {
		return formTypeValue;
	}

	public void setFormTypeValue(String formTypeValue) {
		this.formTypeValue = formTypeValue;
	}	
	
	public String getFormPendingReason() {
		return formPendingReason;
	}

	public void setFormPendingReason(String formPendingReason) {
		this.formPendingReason= formPendingReason;
	}

    public String getResubmitAction() {
        return resubmitAction;
    }

    public void setResubmitAction(String resubmitAction) {
        this.resubmitAction = resubmitAction;
    }

    public String getReturnLink() {
        return returnLink;
    }

    public void setReturnLink(String returnLink) {
        this.returnLink = returnLink;
    }

    @Override
	public void reset(ActionMapping arg0, HttpServletRequest arg1) {
        super.reset(arg0, arg1);
        clear();
    }

    public String getDisplay() {
        return "displayFilteredSubmissions";
    }    
    
	public void resetFilter() {

		applicationId = null;
		personId = null;
		ssn = null;
		dob = null;
		gender = null;
		reqRecdDate = null;
		reqRecdDateTo = null;
		reqRecdDateFrom = null;
		formType = null;
		formPendingReason = null;	
    		
	}

    public void clear() {
        resubmitAction = null;
        returnLink = null; 
    }

}
