/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.voa.action;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import gov.va.med.esr.common.model.person.VOAApplication;
import gov.va.med.esr.common.util.CommonDateUtils;
import gov.va.med.esr.ui.ApplicationConstants;
import gov.va.med.esr.ui.voa.action.VOAPendingListForm;

public class VOAPendingListAction extends VOAResubmissionAction {
               
   public static final String PENDING_SUBMISSION = "voaPendingList";
   public static final String FWD_DISPLAY = "displayPendingSubmissions";
   
   public static final String TXT_1010EZ = "1010EZ";
   public static final String TXT_1010EZR = "1010EZR";
   public static final String TXT_1010HS = ("1010HS");
   public static final String TXT_1010SH = ("1010SH");
   public static final String TXT_1010CG = ("1010CG");
   public static final String TXT_21526EZ = "21526EZ";  //CCR13857
   
   public static final String PENDING_IDENTITY_TRAITS = ("Pending Identity Traits Update");
   public static final String PERSON_NOT_FOUND = ("Person not found");
   public static final String PROXY_PF_FAILED = ("Proxy PF Add Failed");
   public static final String PERSON_INFO_NOT_ACCEPTED = ("Person Info Not Accepted");
   
   private VOAApplication voaApplication = null;
   
   public VOAPendingListAction() {
      super();
   }

   /**
    * Display listing of Pending Submissions
    */
   
   public ActionForward displayPendingSubmissions(ActionMapping mapping, ActionForm form, 
           HttpServletRequest request, HttpServletResponse response) throws Exception {
   	//clear search results
   	clearCachedResults(request);
   	((VOAPendingListForm)form).resetFilter();

    getPendingSubmissions(request,(VOAPendingListForm) form);
   	return mapping.findForward(FWD_PENDING_SUBMISSIONS);
  }  
   
   public ActionForward resubmitVOAApplications(ActionMapping mapping, ActionForm form,
           HttpServletRequest request, HttpServletResponse response ) throws Exception {
       
       //Get the selected pending Submissions resubmit them (only action supported now)        
       List selectedPendingSubmissions = getSelectedPendingSubmissions(mapping,form,request,response);
       
      if (selectedPendingSubmissions.size() > 0){
         //only resubmit action is supported for now
    	 getVoaApplicationService().resubmit(selectedPendingSubmissions);
        
     	  //clear search results to refresh 
     	  clearCachedResults(request); 
      }
      // forward to appropriate tab  
      return mapping.findForward(FWD_DISPLAY);
   }        
      
    public ActionForward applyFilter(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response ) throws Exception {
                  
      //clear search results to refresh
      clearCachedResults(request);      	                 
      //Validate form 
      if (!validateFilter(request,(VOAPendingListForm)form)){
    	  //move the error messages to session and then to request
      } 
      else {
  	    getPendingSubmissions(request,(VOAPendingListForm) form);
      }
      // forward to appropriate tab  
      //return mapping.findForward(((VOAPendingListForm)form).getDisplay()); 
      return mapping.findForward(FWD_PENDING_SUBMISSIONS);  
    }    
    
    public ActionForward resetFilter(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response ) throws Exception {
                  
      //clear search results to refresh
      clearCachedResults(request);      	                 

      //Reset the filter values
      VOAPendingListForm voaPendingListForm = (VOAPendingListForm)form;
      voaPendingListForm.resetFilter();
      return mapping.findForward(FWD_DISPLAY);  
    }
       
    private boolean validateFilter(HttpServletRequest request, VOAPendingListForm form)
    {
    	boolean valid = true;
    	//validate Submission Id
    	if (org.apache.commons.lang.StringUtils.isNotEmpty(form.getApplicationId())){
    		String applicationId = form.getApplicationId();
        	if (!applicationId.matches("[^-][0-9]+")) {
        		addActionMessage(request,ApplicationConstants.MessageKeys.ERRORS_NUMERIC,applicationId);
        		valid = false;
        		form.setApplicationId(null);
        	}
    	}
       	
    	//create dates
    	if (org.apache.commons.lang.StringUtils.isNotEmpty(form.getReqRecdDateFrom())){
    		String reqRecdDateFrom = form.getReqRecdDateFrom();    	
	       	Date date = null;
			try{
	    		date = CommonDateUtils.getDate(reqRecdDateFrom);
	    	}catch (Exception e) {}
	    	if (date == null) {
	    		addActionMessage(request,ApplicationConstants.MessageKeys.ERRORS_DATE,reqRecdDateFrom);
	    		valid = false;
	    		form.setReqRecdDateFrom(null);
	    	}
    	}
    	if (org.apache.commons.lang.StringUtils.isNotEmpty(form.getReqRecdDateTo())){
    		String reqRecdDateTo = form.getReqRecdDateTo();    	
	       	Date date = null;
			try{
	    		date = CommonDateUtils.getDate(reqRecdDateTo);
	    	}catch (Exception e) {}
	    	if (date == null) {
	    		addActionMessage(request,ApplicationConstants.MessageKeys.ERRORS_DATE,reqRecdDateTo);
	    		valid = false;
	    		form.setReqRecdDateTo(null);
	    	}
	    }
    	
    	//Form Type
    	//CCR13857- included 21526EZ for EVSS form
    	if (org.apache.commons.lang.StringUtils.isNotEmpty(form.getFormTypeValue())){
    		String formTypeValue = form.getFormTypeValue();
        	if ((formTypeValue.equals(TXT_1010EZ)) || (formTypeValue.equals(TXT_1010EZR))||
        	   (formTypeValue.equals(TXT_1010HS)) || (formTypeValue.equals(TXT_1010SH)) ||
        	   (formTypeValue.equals(TXT_1010CG)) || (formTypeValue.equals(TXT_21526EZ)))	{
        		valid = true;
        	}
        	else {
        		addActionMessage(request,ApplicationConstants.MessageKeys.ERRORS_FORM_TYPE,formTypeValue);
        		valid = false;
        		form.setFormType(null);
        	}
    	}
    	
    	if (org.apache.commons.lang.StringUtils.isNotEmpty(form.getFormPendingReason())){
    		String formPendingReason = form.getFormPendingReason();
        	if ((formPendingReason.equalsIgnoreCase(PENDING_IDENTITY_TRAITS)) || (formPendingReason.equalsIgnoreCase(PERSON_NOT_FOUND)) ||
        			(formPendingReason.equalsIgnoreCase(PROXY_PF_FAILED)) || (formPendingReason.equalsIgnoreCase(PERSON_INFO_NOT_ACCEPTED))) {
        		valid = true;}
        	else {
        		addActionMessage(request,ApplicationConstants.MessageKeys.ERRORS_PENDING_REASON,formPendingReason);
        		valid = false;
        		form.setFormPendingReason(null);
        	}
    	
    	} 
    	return valid;
    }	    	


	public VOAApplication getVoaApplication() {
		return voaApplication;
	}

	public void setVoaApplication(VOAApplication voaApplication) {
	    //validateOwner(this.voaApplication, voaApplication);
		this.voaApplication = voaApplication;
	}	
	
    @Override
	protected Map getKeyMethodMap()
    {
		Map keyMethodMap = new HashMap();
        keyMethodMap.put("link.name.pendingSubmissions", "displayPendingSubmissions");      
        keyMethodMap.put("button.applyFilter","applyFilter");
        keyMethodMap.put("button.resetFilter","resetFilter");
        keyMethodMap.put("button.resubmit","resubmitVOAApplications");
        return keyMethodMap;
    }
}