/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.vc.action;



import gov.va.med.esr.ui.common.action.PersonAbstractAction;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
// Libraries Classes
// Framework Classes
// ESR Classes

/**
 * This struts action is used to support the demographics overview page.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class VCDeterminationAction extends PersonAbstractAction
{
    // Struts forwards
    public static final String FORWARD_DETERMINATION = "demographicOverview";
    public static final String FORWARD_DETERMINATION_HISTORY = "demographicAddressOverview";
    
    /**
     * Default constructor.
     */
    public VCDeterminationAction()
    {
        super();
    }

    /**
     * Displays the Demographics Overview page.
     *
     * @param mapping Struts action mapping for this action
     * @param form Struts form bean for this action
     * @param request The Http Request
     * @param response The Http Response
     *
     * @return A struts action forward for where we will go next.
     * @throws Exception If there are any errors during processing.
     */
    public ActionForward display(ActionMapping mapping, ActionForm form,
        HttpServletRequest request, HttpServletResponse response) throws Exception
    {
        
    	
        return mapping.findForward("success");
    }

  

    /**
     * Initialize and get the Struts lookup dispatch method map hashmap.
     *
     * @return the method map
     * @see org.apache.struts.actions.LookupDispatchAction#getKeyMethodMap()
     */
    protected Map getKeyMethodMap()
    {
        Map map = new HashMap();
        map.put("button.display", "display");
        map.put("text.subMenu.overview", "display");
        return map;
    }

    /**
     * @see org.springframework.beans.factory.InitializingBean#afterPropertiesSet()
     */
    public void afterPropertiesSet()
    {
        
    }
}