/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.servlet.ServletContext;

import org.apache.struts.util.LabelValueBean;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.ui.common.util.DateUtils;

/**
 * This class is called during the servlet initialization to initialize application wide data.
 *
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class ApplicationInitializer
{
    public static final String YES_VALUE = ConvertUtils.YES_VALUE;
    public static final String NO_VALUE = ConvertUtils.NO_VALUE;
    public static final String UNKNOWN_VALUE = ConvertUtils.UNKNOWN_VALUE;
    public static final String NULL_VALUE = ConvertUtils.NULL_VALUE;

    public static final String NAME_SUFFIX_JR = "Jr.";
    public static final String NAME_SUFFIX_SR = "Sr.";
    public static final String NAME_SUFFIX_II = "II";
    public static final String NAME_SUFFIX_III = "III";
    public static final String NAME_SUFFIX_IV = "IV";

    public static final String CONTEXT_KEY_YES_NO_LIST = "yesNoList";
    public static final String CONTEXT_KEY_YES_NO_NODATA_LIST = "yesNoNoDataList";
    public static final String CONTEXT_KEY_YES_NO_UNKNOWN_LIST = "yesNoUnknownList";
    public static final String CONTEXT_KEY_NAME_SUFFIX_LIST = "nameSuffixList";
    public static final String CONTEXT_KEY_INCOME_YEARS_LIST = "incomeYearsList";

    /**
     * @deprecated
     * @param value
     * @return
     */
    public static String convertYesNo(Object value)
    {
    	return ConvertUtils.convertYesNo(value);
    }
    /**
     * @deprecated
     * @param value
     * @return
     */
    public static String convertYesNoNoData(Object value)
    {
    	return ConvertUtils.convertYesNoNoData(value);
    }

    public static void initialize(ServletContext context)
    {
        if (context.getAttribute(CONTEXT_KEY_YES_NO_LIST) == null)
        {
            context.setAttribute(CONTEXT_KEY_YES_NO_LIST, getYesNoList());
            context.setAttribute(CONTEXT_KEY_YES_NO_NODATA_LIST, getYesNoNoDataList());
            context.setAttribute(CONTEXT_KEY_YES_NO_UNKNOWN_LIST, getYesNoUnknownList());
        }

        if (context.getAttribute(CONTEXT_KEY_NAME_SUFFIX_LIST) == null)
        {
            context.setAttribute(CONTEXT_KEY_NAME_SUFFIX_LIST, getNameSuffixList());
        }

        if (context.getAttribute(CONTEXT_KEY_INCOME_YEARS_LIST) == null)
        {
            context.setAttribute(CONTEXT_KEY_INCOME_YEARS_LIST, getIncomeYearsList());
        }
    }

    private static Collection getYesNoList()
    {
        List list = new ArrayList();
        list.add(new LabelValueBean("label.yes", YES_VALUE));
        list.add(new LabelValueBean("label.no", NO_VALUE));
        return list;
    }

    private static Collection getYesNoNoDataList()
    {
        List list = new ArrayList(getYesNoList());
        list.add(new LabelValueBean("label.noData", NULL_VALUE));
        return list;
    }

    private static Collection getYesNoUnknownList()
    {
        List list = new ArrayList(getYesNoList());
        list.add(new LabelValueBean("label.unknown", UNKNOWN_VALUE));
        return list;
    }

    private static Collection getNameSuffixList()
    {
        List list = new ArrayList();
        list.add(new LabelValueBean(NAME_SUFFIX_JR, NAME_SUFFIX_JR));
        list.add(new LabelValueBean(NAME_SUFFIX_SR, NAME_SUFFIX_SR));
        list.add(new LabelValueBean(NAME_SUFFIX_II, NAME_SUFFIX_II));
        list.add(new LabelValueBean(NAME_SUFFIX_III, NAME_SUFFIX_III));
        list.add(new LabelValueBean(NAME_SUFFIX_IV, NAME_SUFFIX_IV));
        return list;
    }

    private static Collection getIncomeYearsList()
    {
        List list = new ArrayList();
        for (int i=Person.EARLIEST_INCOME_YEAR.intValue(); i <= (DateUtils.getCurrentYear() + 1); i++)
        {
            list.add(new LabelValueBean(String.valueOf(new Integer(i)), String.valueOf(new Integer(i))));
        }
        return list;
    }
}
