package gov.va.med.esr.ui.taglib.support;

import net.mlw.vlh.web.tag.DefaultColumnTag;
import net.mlw.vlh.web.tag.support.Attributes;

/**
 * This component exists to server as more 508 compliant tag handler for the 
 * stock/default ValueList column tag. Specifically, this allows data cells to reference
 * "headers" from the header cells.
 * 
 * @author DNS   bohmeg
 *
 */
public class AccessibleColumnTag extends DefaultColumnTag {
	private String headers;

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	// in order to ensure the <td> cells always have "headers", must reinsert with each call
	public Attributes getCellAttributes() {
		if (headers != null) {
			super.setCellAttribute("headers", headers);
		}

		return super.getCellAttributes();
	}

	public String getHeaders() {
		return headers;
	}

	public void setHeaders(String headers) {
		this.headers = headers;
	}

}
