/*******************************************************************************
 * Copyright  2006 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.ui.taglib;

// Java classes
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;

// Library classes
import org.apache.struts.taglib.TagUtils;
import org.springframework.web.context.WebApplicationContext;

// Framework classes
import gov.va.med.esr.ui.common.service.LookupCacheService;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.security.SecurityContext;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.ui.DelegatingActionUtils;
import gov.va.med.fw.util.StringUtils;

/**
 * Tag handler for the ESR Code options tag.
 * 
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class SetLookupTag extends BodyTagSupport {

	private static final long serialVersionUID = 2787899133475609011L;

	public final static String PAGE_SCOPE = "page";

	public final static String REQUEST_SCOPE = "request";

	public final static String SESSION_SCOPE = "session";

	public final static String APPLICATION_SCOPE = "application";

	private String className;

	private String var;

	private String scope;

	private String removeCollection = null;

	private String removeCollectionScope = null;

	public String getClassName() {
		return className;
	}

	public void setClassName(String className) {
		this.className = className;
	}

	public String getVar() {
		return var;
	}

	public void setVar(String var) {
		this.var = var;
	}

	public String getScope() {
		return this.scope;
	}

	public void setScope(String scope) {
		this.scope = scope;
	}

	public String getRemoveCollection() {
		return removeCollection;
	}

	public void setRemoveCollection(String removeCollection) {
		this.removeCollection = removeCollection;
	}

	public String getRemoveCollectionScope() {
		return removeCollectionScope;
	}

	public void setRemoveCollectionScope(String removeCollectionScope) {
		this.removeCollectionScope = removeCollectionScope;
	}

	public int doStartTag() throws JspException {
        UserPrincipal user = SecurityContextHelper.getSecurityContext().getUserPrincipal();
		this.setLookup(getLookup(className));
		return (EVAL_PAGE);
	}

	public void release() {
		super.release();
		this.className = null;
		this.var = null;
		this.scope = null;
		this.removeCollection = null;
		this.removeCollectionScope = null;
	}

	/**
	 * Gets the lookup either from the cache or from the database.
	 * 
	 * @exception JspException
	 *               if an error occurs
	 */
	protected Collection getLookup(String className) throws JspException {
		Collection list = null;
		try {
			WebApplicationContext ac = DelegatingActionUtils.findRequiredWebApplicationContext( pageContext.getServletContext() );
			LookupCacheService lookupCacheService = 
				(LookupCacheService) ac.getBean(LookupCacheService.LOOKUP_CACHE_SERVICE);
			list = this.filterCollection(lookupCacheService.getFromCache(className));
		}
		catch (Exception ex) {
			throw new JspException("Error while getting lookup data.", ex);
		}
		return list;
	}

	/**
	 * Sets the lookup in the scope.
	 * 
	 * @param lookup
	 * @throws JspException
	 */
	protected void setLookup(Collection lookup) throws JspException {
		String localVar = StringUtils.isNotEmpty(var) ? var : this.className;
		if (StringUtils.isEmpty(scope) || StringUtils.equals(scope, PAGE_SCOPE)) {
			pageContext.setAttribute(localVar, lookup);
		}
		else {
			HttpServletRequest request = (HttpServletRequest) pageContext.getRequest();
			if (StringUtils.equals(scope, REQUEST_SCOPE)) {
				request.setAttribute(localVar, lookup);
			}
			else if (StringUtils.equals(scope, SESSION_SCOPE)) {
				request.getSession().setAttribute(localVar, lookup);
			}
			else if (StringUtils.equals(scope, APPLICATION_SCOPE)) {
				request.getSession().getServletContext().setAttribute(localVar,lookup);
			}
		}
	}

	protected Collection filterCollection(Collection list) throws JspException {
		if (list == null || list.isEmpty()) {
			return list;
		}

		// Get removable elements as a map
		Map removables = getRemovables();
		if (removables == null || removables.isEmpty()) {
			return list;
		}

		// Filter out the removable elements
		Collection result = new ArrayList();
		for (Iterator listIter = list.iterator(); listIter.hasNext();) {
			Lookup lookup = (Lookup) listIter.next();
			if (removables.get(lookup.getCode()) == null) {
				result.add(lookup);
			}
		}

		return result;
	}

	protected Map getRemovables() throws JspException {
		if (StringUtils.isEmpty(this.getRemoveCollection())) {
			return null;
		}

		Map removeble = new HashMap();
		TagUtils util = TagUtils.getInstance();
		Object col = util.lookup(pageContext, this.getRemoveCollection(), this
				.getRemoveCollectionScope());
		if (col != null) {
			if (col.getClass().isArray()) {
				Object[] array = (Object[]) col;
				for (int i = 0; i < array.length; i++) {
					removeble.put((array[i] instanceof Lookup) ? ((Lookup) array[i]).getCode() : array[i], "");
				}
			}
			else if (col instanceof Collection) {
				for (Iterator iter = ((Collection) col).iterator(); iter.hasNext();) {
					Object obj = iter.next();
					removeble.put((obj instanceof Lookup) ? ((Lookup) obj).getCode() : obj, "");
				}
			}
		}
		return removeble;
	}
}