/*
 * Created on Jan 7, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package gov.va.med.esr.ui.taglib;

import javax.servlet.jsp.*;

import gov.va.med.esr.ui.common.util.JspUtils;

public class DisplayValue extends BaseDisplayTag
{
	private static final long serialVersionUID = 7830437163290582306L;
    
    protected String scope = null;  //The scope to be searched to retrieve the specified source bean
	protected String name = null;  //Name of the source bean that contains the data that needs to be rendered.
	protected String property = null;  //Name of the property to be accessed on the specified source bean.
	protected String nullText = null;  //The text to display if the source bean to be displayed is null
	protected String format = null;  //Format for displaying the date
	protected boolean filter = false;  //Filter the rendered output for characters that are sensitive in HTML?
	
	
    /**
     * Process the start tag.
     *
     * @exception JspException if a JSP exception has occurred
     */	
    public int doStartTag() throws JspException
    {    	
    	//Look up the requested property value
    	Object value = super.lookup(pageContext, name, property, scope);
		
        if (nullText == null)
        	nullText = JspUtils.NULL_DEFAULT_TEXT;
        
        String output = null;
        //Convert value to the String, with the appropriate formatting
        try
		{
          output = JspUtils.displayValue(value, nullText, format);
		}
        catch (Exception ex)
		{
          throw new JspException(ex.getMessage());
		}
        //Print the string value to the output writer      
        super.write(pageContext, output, filter);
        return (SKIP_BODY);
    }
    
    
    
    public String getNullText() 
    {
        return (this.nullText);
    }
    public void setNullText(String nullText)
    {
      this.nullText = nullText;	
    }
    
        

    public String getName() 
    {
        return (this.name);
    }
    public void setName(String name) 
    {
        this.name = name;
    }

    

    public String getProperty() 
    {
        return (this.property);
    }
    public void setProperty(String property) 
    {
        this.property = property;
    }

    
    
    public String getScope() 
    {
        return (this.scope);
    }
    public void setScope(String scope) 
    {
        this.scope = scope;
    }
    
    

    public boolean getFilter() 
    {
        return (this.filter);
    }

    public void setFilter(boolean filter) 
    {
        this.filter = filter;
    }    
	/**
	 * @return Returns the format.
	 */
	public String getFormat() {
		return format;
	}
	/**
	 * @param format The format to set.
	 */
	public void setFormat(String format) {
		this.format = format;
	}
}