/*
 * Created on Jan 7, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package gov.va.med.esr.ui.taglib;

import javax.servlet.jsp.*;
import java.util.Set;

import gov.va.med.esr.ui.common.util.JspUtils;
import gov.va.med.esr.common.model.lookup.PhoneType;

public class DisplayPhone extends BaseDisplayTag 
{	
	private static final long serialVersionUID = 5464508944509644058L;
    
    public static final String PHONE_TYPE_HOME = "home";
	public static final String PHONE_TYPE_BUSINESS = "business";
	public static final String PHONE_TYPE_FAX = "fax";
	public static final String PHONE_TYPE_MOBILE = "mobile";
	public static final String PHONE_TYPE_PAGER = "pager";
	
	
	private String scope = null;  //The scope to be searched to retrieve the specified source bean
	private String name = null;  //Name of the source bean that contains the address that needs to be rendered.
	private String phoneCollection = null;  //Name of the property that holds the Address collection.
	private String phoneType = null; //Name of the particular phone type that needs to be displayed from the Address collection.
	private String nullText = null;  //The text to display if the source bean to be displayed is null
	private boolean filter = false;  //Filter the rendered output for characters that are sensitive in HTML?
	
	
    /**
     * Process the start tag.
     *
     * @exception JspException if a JSP exception has occurred
     */	
    public int doStartTag() throws JspException
    {    	
    	//Look up the requested property value
        Object value = super.lookup(pageContext, name, phoneCollection, scope);

        if (value == null)
            return (SKIP_BODY); // Nothing to output
        Set phoneColl = (Set)value;
        String phoneTypeCode = getPhoneTypeCode(phoneType);
        String output = null;
        //Convert value to the String, with the appropriate formatting
        try
		{
          output = JspUtils.displayPhone(phoneColl, phoneTypeCode);
		}
        catch (Exception ex)
		{
          throw new JspException(ex.getMessage());
		}
        //Print the string value to the output writer      
        super.write(pageContext, output, filter);
        return (SKIP_BODY);
    }
    
    
    
    /**
     * Returns the Phone Type Code for a given phone type
     * @param phoneType: Text describing the phone type
     * @return
     */
    private String getPhoneTypeCode(String phoneType)
    {
      if (phoneType == null)
    	return null;
      if (phoneType.equalsIgnoreCase(PHONE_TYPE_HOME))
		return PhoneType.CODE_HOME.getName();
      if (phoneType.equalsIgnoreCase(PHONE_TYPE_BUSINESS))
		return PhoneType.CODE_BUSINESS.getName();
      if (phoneType.equalsIgnoreCase(PHONE_TYPE_FAX))
		return PhoneType.CODE_FAX.getName();
      if (phoneType.equalsIgnoreCase(PHONE_TYPE_MOBILE))
		return PhoneType.CODE_MOBILE.getName();
      if (phoneType.equalsIgnoreCase(PHONE_TYPE_PAGER))
  		return PhoneType.CODE_PAGER.getName();
      return null;
    }
    
    public String getNullText() 
    {
        return (this.nullText);
    }
    public void setNullText(String nullText)
    {
      this.nullText = nullText;	
    }
    
        

    public String getName() 
    {
        return (this.name);
    }
    public void setName(String name) 
    {
        this.name = name;
    }

    

    public String getPhoneCollection() 
    {
        return (this.phoneCollection);
    }
    public void setPhoneCollection(String addressCollection) 
    {
        this.phoneCollection = addressCollection;
    }

    
    public String getPhoneType() 
    {
        return (this.phoneType);
    }
    public void setPhoneType(String phoneType) 
    {
        this.phoneType = phoneType;
    }    
    
    
    public String getScope() 
    {
        return (this.scope);
    }
    public void setScope(String scope) 
    {
        this.scope = scope;
    }
    
    

    public boolean getFilter() 
    {
        return (this.filter);
    }

    public void setFilter(boolean filter) 
    {
        this.filter = filter;
    }    
}