/*
 * Created on Jan 7, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package gov.va.med.esr.ui.taglib;

import javax.servlet.jsp.*;
import java.util.Set;

import gov.va.med.esr.ui.common.util.JspUtils;
import gov.va.med.esr.common.model.lookup.NameType;

public class DisplayName extends BaseDisplayTag
{
	
	private static final long serialVersionUID = 6924024434757400119L;
    
    public static final String NAME_TYPE_ADOPTED = "adopted";
	public static final String NAME_TYPE_ALIAS = "alias";
	public static final String NAME_TYPE_DISPLAY = "display";
	public static final String NAME_TYPE_INDIGENOUS = "indigenous";
	public static final String NAME_TYPE_LEGAL = "legal";
	public static final String NAME_TYPE_LICENSING = "licensing";
	public static final String NAME_TYPE_MAIDEN = "maiden";
	public static final String NAME_TYPE_NAME_AT_BIRTH = "nameatbirth";
	public static final String NAME_TYPE_NICKNAME = "nickname";
	public static final String NAME_TYPE_PARTNER = "partner";
	public static final String NAME_TYPE_PSEUDO = "pseudo";
	public static final String NAME_TYPE_REGISTERED = "registered";
	public static final String NAME_TYPE_UNSPECIFIED = "unspecified";	
	
	private String scope = null;  //The scope to be searched to retrieve the specified source bean
	private String name = null;  //Name of the source bean that contains the name that needs to be rendered.
	private String nameCollection = null;  //Name of the property that holds the Name collection.
	private String nameType = null; //Name of the particular name type that needs to be displayed from the Name collection.
	private String nullText = null;  //The text to display if the source bean to be displayed is null
	private boolean filter = false;  //Filter the rendered output for characters that are sensitive in HTML?
	
	
    /**
     * Process the start tag.
     *
     * @exception JspException if a JSP exception has occurred
     */	
    public int doStartTag() throws JspException
    {    	
    	//Look up the requested property value
        Object value = super.lookup(pageContext, name, nameCollection, scope);
        if (value == null)
            return (SKIP_BODY); // Nothing to output
        
        Set nameColl = (Set)value;
        String nameTypeCode = getNameTypeCode(nameType);        
        String output = null;
        //Convert value to the String, with the appropriate formatting
        try
		{
          output = JspUtils.displayName(nameColl, nameTypeCode);
		}
        catch (Exception ex)
		{
          throw new JspException(ex.getMessage());
		}
        //Print the string value to the output writer      
        super.write(pageContext, output, filter);
        return (SKIP_BODY);
    }
    
    
    
    /**
     * Returns the Name Type code for a give name type
     * @param nameType: Text describing the name type
     * @return
     */
    private String getNameTypeCode(String nameType)
    {
      if (nameType == null)
    	return null;	
      if (nameType.equalsIgnoreCase(NAME_TYPE_ADOPTED))
		return NameType.ADOPTED_NAME.getName();
      if (nameType.equalsIgnoreCase(NAME_TYPE_ALIAS))
		return NameType.ALIAS_NAME.getName();
      if (nameType.equalsIgnoreCase(NAME_TYPE_DISPLAY))
  		return NameType.DISPLAY_NAME.getName();
      if (nameType.equalsIgnoreCase(NAME_TYPE_INDIGENOUS))
		return NameType.TRIBAL_NAME.getName();
      if (nameType.equalsIgnoreCase(NAME_TYPE_LEGAL))
  		return NameType.LEGAL_NAME.getName();
      if (nameType.equalsIgnoreCase(NAME_TYPE_LICENSING))
    	return NameType.LICENSING_NAME.getName();
      if (nameType.equalsIgnoreCase(NAME_TYPE_MAIDEN))
  		return NameType.MAIDEN_NAME.getName();
      if (nameType.equalsIgnoreCase(NAME_TYPE_NAME_AT_BIRTH))
  		return NameType.BIRTH_NAME.getName();
      if (nameType.equalsIgnoreCase(NAME_TYPE_NICKNAME))
    	return NameType.NICKNAME.getName();
      if (nameType.equalsIgnoreCase(NAME_TYPE_PARTNER))
  		return NameType.PARTNER_SPOUSE_NAME.getName();
      if (nameType.equalsIgnoreCase(NAME_TYPE_PSEUDO))
		return NameType.CODED_PSEUDO_NAME.getName();
      if (nameType.equalsIgnoreCase(NAME_TYPE_REGISTERED))
  		return NameType.REGISTERED_NAME.getName();
      if (nameType.equalsIgnoreCase(NAME_TYPE_UNSPECIFIED))
		return NameType.UNSPECIFIED.getName();
      return null;
    }
    
    
    
    public String getNullText() 
    {
        return (this.nullText);
    }
    public void setNullText(String nullText)
    {
      this.nullText = nullText;	
    }
    
        

    public String getName() 
    {
        return (this.name);
    }
    public void setName(String name) 
    {
        this.name = name;
    }

    

    public String getNameCollection() 
    {
        return (this.nameCollection);
    }
    public void setNameCollection(String nameCollection) 
    {
        this.nameCollection = nameCollection;
    }

    
    public String getNameType() 
    {
        return (this.nameType);
    }
    public void setNameType(String nameType) 
    {
        this.nameType = nameType;
    }    
    
    
    public String getScope() 
    {
        return (this.scope);
    }
    public void setScope(String scope) 
    {
        this.scope = scope;
    }
    
    

    public boolean getFilter() 
    {
        return (this.filter);
    }

    public void setFilter(boolean filter) 
    {
        this.filter = filter;
    }    
}