/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.taglib;

// Java classes
import javax.servlet.jsp.JspException;

// Library classes

// Framework Classes

// ESR classes
import gov.va.med.esr.ui.common.util.JspUtils;
import gov.va.med.esr.common.infra.ImpreciseDate;

import java.util.Date;

/**
 * Supports the displaydate tag.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class DisplayDate extends BaseDisplayTag
{
    private static final long serialVersionUID = 1350677359374910262L;

    // The scope to be searched to retrieve the specified source bean
    private String scope = null;

    // Name of the source bean that contains the data that needs to be rendered.
    private String name = null;

    // Name of the property to be accessed to retrieve the date value on the specified source bean.
    private String dateProperty = null;

    // Optional format for displaying the date
    protected String format = null;

    // Determines whether the time portion will be displayed
    private boolean displayTime = false;

    // Text to use when the value is null
    private String nullText = null;

    /**
     * Process the start tag.
     *
     * @throws javax.servlet.jsp.JspException if a JSP exception has occurred.
     */
    public int doStartTag() throws JspException
    {
        // Look up the requested property value
        Object value = super.lookup(pageContext, name, dateProperty, scope);

        if (value == null)
        {
            // Nothing to output
            return (SKIP_BODY);
        }

        String output = null;
        try
        {
            if (value instanceof Date)
            {
                Date dateValue = (Date)value;
                output = JspUtils.displayDate(dateValue, format, displayTime);
            }
            else
            {
                if (value instanceof ImpreciseDate)
                {
                    ImpreciseDate dateValue = (ImpreciseDate)value;
                    output = JspUtils.displayDate(dateValue, format, displayTime);
                }
            }
        }
        catch (Exception ex)
        {
            throw new JspException(ex.getMessage());
        }

        // If we don't have anything yet, give the null text a chance
        if (output == null)
        {
            output = JspUtils.displayValue(value, nullText, format);
        }

        // Write the string value to the output writer
        super.write(pageContext, output, false);

        return (SKIP_BODY);
    }


    public String getName()
    {
        return (this.name);
    }

    public void setName(String name)
    {
        this.name = name;
    }

    public String getDateProperty()
    {
        return dateProperty;
    }

    public void setDateProperty(String dateProperty)
    {
        this.dateProperty = dateProperty;
    }

    public boolean isDisplayTime()
    {
        return displayTime;
    }

    public void setDisplayTime(boolean displayTime)
    {
        this.displayTime = displayTime;
    }

    public String getScope()
    {
        return (this.scope);
    }

    public void setScope(String scope)
    {
        this.scope = scope;
    }

    public String getFormat()
    {
        return format;
    }

    public void setFormat(String format)
    {
        this.format = format;
    }

    public String getNullText()
    {
        return nullText;
    }

    public void setNullText(String nullText)
    {
        this.nullText = nullText;
    }
}