/*
 * Created on Jan 7, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package gov.va.med.esr.ui.taglib;

import javax.servlet.jsp.*;
import java.util.Locale;
import java.math.BigDecimal;
import java.text.NumberFormat;

import gov.va.med.esr.ui.common.util.JspUtils;


public class DisplayCurrency extends BaseDisplayTag
{	
	private static final long serialVersionUID = 6682543388252780591L;
    
    private String scope = null;  //The scope to be searched to retrieve the specified source bean
	private String name = null;  //Name of the source bean that contains the data that needs to be rendered.
	private String currencyProperty = null;  //Name of the property to be accessed on the specified source bean.
	private String nullText = null;  //The text to display if the source bean to be displayed is null
	private String currencyCountry = null;  //ISO 3166 3-letter country code of the currency to be displayed
	
	
    /**
     * Process the start tag.
     *
     * @exception JspException if a JSP exception has occurred
     */	
    public int doStartTag() throws JspException
    {    	
    	//Look up the requested property value
    	Object value = super.lookup(pageContext, name, currencyProperty, scope);
		        
        Locale locale = getLocale(currencyCountry);
        //Convert value to the String, with the appropriate formatting             
        String output = null;
        try
		{
		  if (value == null) {
            if (nullText == null) {
		      output = JspUtils.displayValue(value, JspUtils.NULL_DEFAULT_TEXT);
            }else {
                try{
                    //convert the null text to bigdecimal
                    BigDecimal defValue = new BigDecimal(nullText);
                    output = NumberFormat.getCurrencyInstance(locale).format(defValue);
                }catch (NumberFormatException nfe){
                    output = nullText;
                }
            }
          }
		  else 
		    output = NumberFormat.getCurrencyInstance(locale).format(value);
		}
        catch(Exception ex)
		{
        	throw new JspException(ex.getMessage());
		}        
        //Print the string value to the output writer      
        super.write(pageContext, output, false);
        return (SKIP_BODY);
    }

    
    
    /**
     * Returns the locale for a given country.
     * @param countryCode: ISO 3166 3-letter country code
     * @return: Locale for the given country. Null if a matching Locale could not be found.
     */
    private Locale getLocale(String countryCode)
    {
    	if (countryCode == null)
    	  return Locale.US;
    	if (countryCode.equalsIgnoreCase(Locale.CANADA.getISO3Country()))
    	  return Locale.CANADA;
    	if (countryCode.equalsIgnoreCase(Locale.CANADA_FRENCH.getISO3Country()))
      	  return Locale.CANADA_FRENCH;
    	if (countryCode.equalsIgnoreCase(Locale.CHINA.getISO3Country()))
      	  return Locale.CHINA;
    	if (countryCode.equalsIgnoreCase(Locale.FRANCE.getISO3Country()))
      	  return Locale.FRANCE;
    	if (countryCode.equalsIgnoreCase(Locale.GERMANY.getISO3Country()))
      	  return Locale.GERMANY;
    	if (countryCode.equalsIgnoreCase(Locale.ITALY.getISO3Country()))
          return Locale.ITALY;
    	if (countryCode.equalsIgnoreCase(Locale.JAPAN.getISO3Country()))
          return Locale.JAPAN;
    	if (countryCode.equalsIgnoreCase(Locale.KOREA.getISO3Country()))
          return Locale.KOREA;
    	if (countryCode.equalsIgnoreCase(Locale.TAIWAN.getISO3Country()))
          return Locale.TAIWAN;
    	if (countryCode.equalsIgnoreCase(Locale.UK.getISO3Country()))
          return Locale.UK;
    	if (countryCode.equalsIgnoreCase(Locale.US.getISO3Country()))
          return Locale.US;
    	return null;
    }
    
    
    
    public String getNullText() 
    {
        return (this.nullText);
    }
    public void setNullText(String nullText)
    {
      this.nullText = nullText;	
    }
    
        

    public String getName() 
    {
        return (this.name);
    }
    public void setName(String name) 
    {
        this.name = name;
    }

    

    public String getCurrencyProperty() 
    {
        return (this.currencyProperty);
    }
    public void setCurrencyProperty(String currencyProperty) 
    {
        this.currencyProperty = currencyProperty;
    }

    
    
    public String getScope() 
    {
        return (this.scope);
    }
    public void setScope(String scope) 
    {
        this.scope = scope;
    }
    
    

    public String getCurrencyCountry() 
    {
        return (this.currencyCountry);
    }
    public void setCurrencyCountry(String currencyCountry) 
    {
        this.currencyCountry = currencyCountry;
    }    
}