/*
 * Created on Jan 7, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package gov.va.med.esr.ui.taglib;

import javax.servlet.jsp.*;
import java.util.Set;

import gov.va.med.esr.ui.common.util.JspUtils;
import gov.va.med.esr.common.model.lookup.AddressType;

public class DisplayAddress extends BaseDisplayTag
{
	private static final long serialVersionUID = -3654584961843800926L;
    
    public static final String ADDR_TYPE_CORRESPONDENCE = "correspondence";
	public static final String ADDR_TYPE_TEMPORARY = "temporary";
	public static final String ADDR_TYPE_CONFIDENTIAL = "confidential";
	public static final String ADDR_TYPE_BUSINESS = "business";
	
	
	
	private String scope = null;  //The scope to be searched to retrieve the specified source bean
	private String name = null;  //Name of the source bean that contains the address that needs to be rendered.
	private String addressCollection = null;  //Name of the property that holds the Address collection.
	private String addressType = null; //Name of the particular address type that needs to be displayed from the Address collection.
	private String nullText = null;  //The text to display if the source bean to be displayed is null
	private boolean filter = false;  //Filter the rendered output for characters that are sensitive in HTML?
	
	
    /**
     * Process the start tag.
     *
     * @exception JspException if a JSP exception has occurred
     */	
    public int doStartTag() throws JspException
    {    	
    	//Look up the requested property value
        Object value = super.lookup(pageContext, name, addressCollection, scope);

        if (value == null)
            return (SKIP_BODY); // Nothing to output
        Set addrColl = (Set)value;
        String addressTypeCode = getAddressTypeCode(addressType);        
        String output = null;
        //Convert value to the String, with the appropriate formatting
        try
		{
          output = JspUtils.displayAddress(addrColl, addressTypeCode);
		}
        catch (Exception ex)
		{
          throw new JspException(ex.getMessage());
		}
        //Print the string value to the output writer      
        super.write(pageContext, output, filter);
        return (SKIP_BODY);
    }
    
    
    
    /**
     * Returns the Address Type Code for a given address type
     * @param addressType: Text describing the address type
     * @return
     */
    private String getAddressTypeCode(String addressType)
    {
      if (addressType == null)
    	return null;
      if (addressType.equalsIgnoreCase(ADDR_TYPE_CORRESPONDENCE))
		return AddressType.CODE_PERMANENT_ADDRESS.getName();
  	  if (addressType.equalsIgnoreCase(ADDR_TYPE_TEMPORARY))
		return AddressType.CODE_TEMPORARY_CORRESPONDENCE_ADDRESS.getName();
  	  if (addressType.equalsIgnoreCase(ADDR_TYPE_CONFIDENTIAL))
		return AddressType.CODE_CONFIDENTIAL_ADDRESS.getName();
  	  if (addressType.equalsIgnoreCase(ADDR_TYPE_BUSINESS))
		return AddressType.CODE_BUSINESS_ADDRESS.getName();
      return null;
    }
    
    
    
    public String getNullText() 
    {
        return (this.nullText);
    }
    public void setNullText(String nullText)
    {
      this.nullText = nullText;	
    }
    
        

    public String getName() 
    {
        return (this.name);
    }
    public void setName(String name) 
    {
        this.name = name;
    }

    

    public String getAddressCollection() 
    {
        return (this.addressCollection);
    }
    public void setAddressCollection(String addressCollection) 
    {
        this.addressCollection = addressCollection;
    }

    
    public String getAddressType() 
    {
        return (this.addressType);
    }
    public void setAddressType(String addressType) 
    {
        this.addressType = addressType;
    }    
    
    
    public String getScope() 
    {
        return (this.scope);
    }
    public void setScope(String scope) 
    {
        this.scope = scope;
    }
    
    

    public boolean getFilter() 
    {
        return (this.filter);
    }

    public void setFilter(boolean filter) 
    {
        this.filter = filter;
    }    
}