/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.taglib;

import gov.va.med.fw.util.StringUtils;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;

import org.apache.struts.Globals;
import org.apache.struts.taglib.TagUtils;

/**
 * Tag handler for breadCrumb tag.
 * 
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class BreadCrumbTag extends BodyTagSupport 
{
	private static final long serialVersionUID = -821993897657164976L;

    //CSV of bread crumbs
	private String crumbs;
	
	//Message resource bundle
	private String bundle;
	

	public String getCrumbs() 
	{
		return crumbs;
	}
	
	public void setCrumbs(String crumbs) 
	{
		this.crumbs = crumbs;
	}

	public String getBundle() 
	{
		return bundle;
	}
	
	public void setBundle(String bundle) 
	{
		this.bundle = bundle;
	}
	
	/**
	 * Creates the bread crumbs.
	 */
	public int doStartTag() throws JspException 
	{
		TagUtils tagUtils = TagUtils.getInstance();
		if(StringUtils.isNotEmpty(crumbs))
	    {
			String crumb[] = crumbs.split(",");
			StringBuffer buffer = new StringBuffer();
			for(int i=0; i<crumb.length; i++)
			{
				String key = crumb[i];
				String value = tagUtils.message(pageContext,this.bundle,Globals.LOCALE_KEY,key);
				buffer.append(value);
				if(crumb.length != (i+1))
				{
					buffer.append(" > ");
				}
			}
			if(buffer.length() > 0)
			{
				tagUtils.write(pageContext,buffer.toString());
			}
	    }
        return (EVAL_BODY_BUFFERED);
    }

    /**
     * Release all allocated resources.
     */
    public void release() 
    {
       super.release();
       crumbs = null;
       bundle = null;
    }

}
