/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.taglib;

// Java
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;

// Struts
import org.apache.struts.taglib.TagUtils;

/**
 * Custom tag to display an address 
 * 
 * @author Vu Le
 * @version 1.0
 */
public class AddressTag extends BodyTagSupport {

   /**
	 * 
	 */
	private static final long serialVersionUID = 6756690686087506071L;

/**
    * The name of the bean containing the attribute.
    */
   private String name = null;

   /**
    * The name of the property which will return date string
    */
   private String property = null;

   public AddressTag() {
      super();
   }

   public String getName() {
      return this.name;
   }

   public void setName(String name) {
      this.name = name;
   }

   public String getProperty() {
      return this.property;
   }

   public void setProperty(String property) {
      this.property = property;
   }

   /**
    * Formats an address string
    * @exception JspException if a JSP exception has occurred
    */
   public int doStartTag() throws JspException {

      TagUtils util = TagUtils.getInstance();
      return SKIP_BODY;

   }

   /**
    * Evaluate the remainder of the current page normally.
    * 
    * @exception JspException
    *               if a JSP exception occurs
    */
   public int doEndTag() throws JspException {
      return (EVAL_PAGE);
   }

   /**
    * Release all allocated resources.
    */
   public void release() {
      super.release();
      name = null;
      property = null;
   }
}