// Package 
package gov.va.med.esr.ui.report.action;

// Java Classes
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

// Library Classes
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionForm;

// Framework Classes
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.NoRecordFoundException;

// ESR Classes
import gov.va.med.esr.common.model.CommonEntityKeyFactory;

/**
 * Action for scheduled reports.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class ScheduledReportsAction extends ReportFilterAction
{
    /**
     * Gets the value list table Id.
     *
     * @return the table id.
     */
    public String getTableId()
    {
        return SCH_REPORT_TABLE_ID;
    }

    /**
     * Gets the value list adapter.
     *
     * @return the adapter.
     */
    public String getValueListAdapter()
    {
        return SCH_REPORTS_VALUE_LIST_ADAPTER;
    }

    /**
     * Cancels a scheduled report.
     *
     * @param mapping Struts action mapping for this action
     * @param actionForm Struts form bean for this action
     * @param request The Http Request
     * @param response The Http Response
     *
     * @return A struts action forward for where we will go next.
     * @throws Exception If there are any errors during processing.
     */
    public ActionForward cancelScheduledReport(ActionMapping mapping, ActionForm actionForm,
        HttpServletRequest request, HttpServletResponse response) throws Exception
    {
        // Get the report Id and create an entity key from it
        String reportId = request.getParameter(CANCEL_REPORT_ID);
        EntityKey key = CommonEntityKeyFactory.createReportSetupEntityKey(reportId);

        try
        {
            // Cancel the scheduled report
            getStandardReportService().cancelScheduledReport(key,this.getLoggedInUser());
        }
        catch (NoRecordFoundException ex)
        {
            // The report doesn't exist.  Perhaps it got cancelled by another user.
            // Return to the scheduled reports list and display an error message.
            return mapping.findForward(DISPLAY_SCHEDULED_REPORTS_CANCELLED_INVALID_ID);
        }

        // Return to the scheduled reports list and display a success message.
        return mapping.findForward(DISPLAY_SCHEDULED_REPORTS_CANCELLED_MSG);
    }
}
