/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.report.action;

import gov.va.med.esr.common.model.lookup.DayOfMonth;
import gov.va.med.esr.common.model.lookup.DayOfQuarter;
import gov.va.med.esr.common.model.lookup.DayOfWeek;
import gov.va.med.esr.common.model.lookup.Month;
import gov.va.med.esr.common.model.lookup.ReportRunFrequency;
import gov.va.med.esr.common.model.lookup.WeekOfMonth;
import gov.va.med.fw.util.StringUtils;

/**
 * Action form for report schedule actions.
 * 
 * @author Muddaiah Ranga
 * @version 1.0
 */
public class ReportScheduleInfoForm extends ReportParamInfoForm {

    private static final long serialVersionUID = -8697242238257617133L;
    
    private String generateReport;
    private String scheduleType;
    
    //Fields for Daily/Weekly
    private String[] dailyWeeklyDay = {};
    
    //Fields for Monthly (option 1)
    private String monthlyDayOfEveryMonth;
    
    //Fields for Monthly (option 2)
    private String monthlyWeekOfEveryMonth;
    private String monthlyDayOfEveryWeek;
    
    //Fields for Quarterly
    private String quarterlyDayOfQuarter;
    
    //Fields for Yearly (option 1)
    private String yearlyMonthOfYear;
    private String yearlyDayOfMonth;
    
    //Fields for Yearly (option 2)
    private String yearlyWeekOfMonth;
    private String yearlyDayOfWeek;
    private String yearlyMonth;
    
    //Fields for Other
    private String otherDateToGenerateReport;
    
    // Time to Generate Report
    private String timeToGenerateReportHour;
    private String timeToGenerateReportMinute;
    
    //Email Report To
    private String emailReportTo;


    public String getGenerateReport() {
        return StringUtils.isNotEmpty(this.generateReport) ? this.generateReport : ReportRunFrequency.MONTHLY.getCode();
    }
    
    public String getGenerateReportNoDefault() {
        return this.generateReport;
    }
    
    public void setGenerateReport(String generateReport) {
        this.generateReport = generateReport;
    }
    
    public String getScheduleType() {
        return scheduleType;
    }

    public void setScheduleType(String scheduleType) {
        this.scheduleType = scheduleType;
    }
    
    //********************  DailyWeekly Fields setter/getters  **********************************************//

    public String[] getDailyWeeklyDay() {
        return dailyWeeklyDay;
    }
    
    public void setDailyWeeklyDay(String[] dailyWeeklyDay) {
        this.dailyWeeklyDay = dailyWeeklyDay;
    }
    
    //********************  Monthly Fields setter/getters  **********************************************//
    
    public String getMonthlyDayOfEveryMonth() {
        return StringUtils.isNotEmpty(monthlyDayOfEveryMonth) ? monthlyDayOfEveryMonth : DayOfMonth.CODE_LAST.getCode();
    }
    
    public String getMonthlyDayOfEveryMonthNoDefault() {
        return monthlyDayOfEveryMonth;
    }

    public void setMonthlyDayOfEveryMonth(String monthlyDayOfEveryMonth) {
        this.monthlyDayOfEveryMonth = monthlyDayOfEveryMonth;
    }

    public String getMonthlyDayOfEveryWeek() {
        return StringUtils.isNotEmpty(monthlyDayOfEveryWeek) ? monthlyDayOfEveryWeek : DayOfWeek.FRIDAY.getCode();
    }
    
    public String getMonthlyDayOfEveryWeekNoDefault() {
        return monthlyDayOfEveryWeek;
    }

    public void setMonthlyDayOfEveryWeek(String monthlyDayOfEveryWeek) {
        this.monthlyDayOfEveryWeek = monthlyDayOfEveryWeek;
    }
    
    public String getMonthlyWeekOfEveryMonth() {
        return StringUtils.isNotEmpty(monthlyWeekOfEveryMonth) ? monthlyWeekOfEveryMonth : WeekOfMonth.LAST.getCode();
    }

    public String getMonthlyWeekOfEveryMonthNoDefault() {
        return monthlyWeekOfEveryMonth;
    }
    
    public void setMonthlyWeekOfEveryMonth(String monthlyWeekOfEveryMonth) {
        this.monthlyWeekOfEveryMonth = monthlyWeekOfEveryMonth;
    }
    
    //********************  Quarterly Fields setter/getters  **********************************************//
    
    public String getQuarterlyDayOfQuarter() {
        return StringUtils.isNotEmpty(quarterlyDayOfQuarter) ? quarterlyDayOfQuarter : DayOfQuarter.CODE_LAST.getCode();
    }

    public String getQuarterlyDayOfQuarterNoDefault() {
        return quarterlyDayOfQuarter;
    }
    
    public void setQuarterlyDayOfQuarter(String quarterlyDayOfQuarter) {
        this.quarterlyDayOfQuarter = quarterlyDayOfQuarter;
    }
    
    //********************  Yearly Fields setter/getters  **********************************************//
    
    public String getYearlyDayOfMonth() {
        return StringUtils.equals(getYearlyMonthOfYear(),Month.SEPTEMBER.getCode()) ? "30" : yearlyDayOfMonth;
    }

    public String getYearlyDayOfMonthNoDefault() {
        return yearlyDayOfMonth;
    }
    
    public void setYearlyDayOfMonth(String yearlyDayOfMonth) {
        this.yearlyDayOfMonth = yearlyDayOfMonth;
    }
    
    public String getYearlyMonthOfYear() {
        return StringUtils.isNotEmpty(yearlyMonthOfYear) ? yearlyMonthOfYear : Month.SEPTEMBER.getCode();
    }

    public String getYearlyMonthOfYearNoDefault() {
        return yearlyMonthOfYear;
    }
    
    public void setYearlyMonthOfYear(String yearlyMonthOfYear) {
        this.yearlyMonthOfYear = yearlyMonthOfYear;
    }

    public String getYearlyDayOfWeek() {
        return StringUtils.isNotEmpty(yearlyDayOfWeek) ? yearlyDayOfWeek : DayOfWeek.FRIDAY.getCode();
    }

    public String getYearlyDayOfWeekNoDefault() {
        return yearlyDayOfWeek;
    }
    
    public void setYearlyDayOfWeek(String yearlyDayOfWeek) {
        this.yearlyDayOfWeek = yearlyDayOfWeek;
    }

    public String getYearlyMonth() {
        return StringUtils.isNotEmpty(yearlyMonth) ? yearlyMonth : Month.DECEMBER.getCode();
    }

    public String getYearlyMonthNoDefault() {
        return yearlyMonth;
    }
    
    public void setYearlyMonth(String yearlyMonth) {
        this.yearlyMonth = yearlyMonth;
    }

    public String getYearlyWeekOfMonth() {
        return StringUtils.isNotEmpty(yearlyWeekOfMonth) ? yearlyWeekOfMonth : WeekOfMonth.LAST.getCode();
    }
    
    public String getYearlyWeekOfMonthNoDefault() {
        return yearlyWeekOfMonth;
    }

    public void setYearlyWeekOfMonth(String yearlyWeekOfMonth) {
        this.yearlyWeekOfMonth = yearlyWeekOfMonth;
    } 

    //********************  Other Fields setter/getters  **********************************************//
    
    public String getOtherDateToGenerateReport() {
        return otherDateToGenerateReport;
    }

    public void setOtherDateToGenerateReport(String otherDateToGenerateReport) {
        this.otherDateToGenerateReport = otherDateToGenerateReport;
    }
    
    //********************  Time setter/getters  **********************************************//
    
    public String getTimeToGenerateReportHour() {
        return StringUtils.isNotEmpty(timeToGenerateReportHour) ? timeToGenerateReportHour : "23";
    }

    public String getTimeToGenerateReportHourNoDefault() {
        return timeToGenerateReportHour;
    }
    
    public void setTimeToGenerateReportHour(String timeToGenerateReportHour) {
        this.timeToGenerateReportHour = timeToGenerateReportHour;
    }

    public String getTimeToGenerateReportMinute() {
        return StringUtils.isNotEmpty(timeToGenerateReportMinute) ? timeToGenerateReportMinute : "59";
    }

    public String getTimeToGenerateReportMinuteNoDefault() {
        return timeToGenerateReportMinute;
    }
    
    public void setTimeToGenerateReportMinute(String timeToGenerateReportMinute) {
        this.timeToGenerateReportMinute = timeToGenerateReportMinute;
    }
    
    public String getEmailReportTo() {
        return emailReportTo;
    }

    public void setEmailReportTo(String emailReportTo) {
        this.emailReportTo = emailReportTo;
    }
    
    public void initialize() {
        this.generateReport = null;
        this.scheduleType = null;
        
        this.dailyWeeklyDay = new String[0];
        
        this.monthlyDayOfEveryMonth = null;
        
        this.monthlyWeekOfEveryMonth = null;
        this.monthlyDayOfEveryWeek = null;
        
        this.quarterlyDayOfQuarter = null;
        
        this.yearlyMonthOfYear = null;
        this.yearlyDayOfMonth = null;
        
        this.yearlyWeekOfMonth = null;
        this.yearlyDayOfWeek = null;
        this.yearlyMonth = null;
        
        this.otherDateToGenerateReport = null;
        
        this.timeToGenerateReportHour = null;
        this.timeToGenerateReportMinute = null;
        
        this.emailReportTo = null;
    }   
}
