/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.report.action;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import gov.va.med.esr.common.model.lookup.ReportFacilityDisplayBy;
import gov.va.med.fw.util.StringUtils;

/**
 * Action form for on demand report action.
 *
 * @author Muddaiah Ranga
 * @version 1.0
 */
public class ReportParamInfoForm extends ReportInfoForm {

    private static final long serialVersionUID = 5539199088424610683L;

    private String fromDate;
    private String toDate;

    private String fromYear;

    private String toYear;

    private String facilityDisplayBy;

    private String[] visn = {};
    private String[] visnFacility = {};
    private String[] facility = {};
    private String   stationNumbers;
    private String[] vamcs = {};
    private String[] visnVamcFacility = {};
    private String[] visnVamc = {};
    private String[] vamcFacility = {};

    private String vamc;


    private String asOfDate;
    private String beginIncomeYear;
    private String endIncomeYear;
    private String division;
    private String functionalGroup;
    private String[] workItemStatus;
    private String[] workItemType;
    private String runReportByUser;

    private String errorType;
    private String batchNumber;
    private String exceptionType;

    private String[] reportUser = {};
    private String[] badAddressReason = {};
    private String[] cancelDeclineReason = {};
    private String[] phRejectReason = {};

    private String includeUsers;
    private String messageError;
    private String messageType;
    private String[] priorityGroup = {};
    private String[] enrollmentStatus = {};
    private String[] pendingEnrollmentStatus = {};
    private String[] letterRejectErrorReason = {};
    private String[] letterRejectReason = {};
    private String[] letterErrorType = {};
    private String[] enrollmentCategory = {};
    private String enrollmentEffectiveDateChange;
    private String daysBetweenUpdates;
    private String recordsPerEnrollmentStatus;
    private String[] queryTo = {};
    private String[] vbaQueryStatus = {};
    private String reportDetailBy;
    private String updateStatus;
    private String[] eedWeeklyReport = {};

    private String reportPeriodType;
    private String reportPeriodYear;
    private String reportPeriodSummaryYear;
    private String reportPeriodQuarterYear;
    private String reportPeriodQuarter;
    private String reportPeriodStartDate;
    private String reportPeriodEndDate;

    private String[] registryType = {};
    private String[] enrollmentOverrideReason = {};

    private String addressUpdatedMultipleTimesWithin;
    private String phUnconfirmedForMoreThan;
    private String[] letterFile;
    private String letterFileReceivedDate;
    private String subtotalDetailLevel;
    private String runReportFor;
    private String reportFormat;
    private String fileType;
    private String outlierDays;
    private String randomNumberOfRecords;
    private String[] enrollmentStatusComponent;
    private String[] personMergeStatus;
    private String[] eligibilityFactors;
    private String enrollmentProcessStatus;
    
    private String[] voaFormTypes;


    public String getFromDate() {
        return fromDate;
    }

    public void setFromDate(String fromDate) {
        this.fromDate = fromDate;
    }

    public String getToDate() {
        return toDate;
    }

    public void setToDate(String toDate) {
        this.toDate = toDate;
    }

    public String getFromYear() {
		return this.fromYear;
	}

	public String getToYear() {
		return this.toYear;
	}

	public void setFromYear(String fromYear) {
		this.fromYear = fromYear;
	}

	public void setToYear(String toYear) {
		this.toYear = toYear;
	}

	public String getFacilityDisplayBy() {
        return StringUtils.isNotEmpty(facilityDisplayBy) ? facilityDisplayBy : "";
    }

    public String getFacilityDisplayByNoDefault() {
        return this.facilityDisplayBy;
    }

    public void setFacilityDisplayBy(String facilityDisplayBy) {
        this.facilityDisplayBy = facilityDisplayBy;
    }

    public String getVamc() {
        return vamc;
    }

    public void setVamc(String vamc) {
        this.vamc = vamc;
    }

    public String[] getFacilities() {
        String[] facilityCodeArray = null;
        if(StringUtils.equals(facilityDisplayBy,ReportFacilityDisplayBy.CODE_VISN.getName())) {
            facilityCodeArray = this.visn;
        } else if(StringUtils.equals(facilityDisplayBy,ReportFacilityDisplayBy.CODE_VISN_SITE.getName())) {
            facilityCodeArray = this.visnFacility;
        } else if(StringUtils.equals(facilityDisplayBy,ReportFacilityDisplayBy.CODE_SITE.getName())) {
            facilityCodeArray = this.facility;
        } else if(StringUtils.equals(facilityDisplayBy,ReportFacilityDisplayBy.CODE_VAMC.getName())) {
            facilityCodeArray = this.vamcs;
        }else if(StringUtils.equals(facilityDisplayBy,ReportFacilityDisplayBy.CODE_VAMC_SITE.getName())) {
            facilityCodeArray = this.vamcFacility;
        }else if(StringUtils.equals(facilityDisplayBy,ReportFacilityDisplayBy.CODE_VISN_VAMC.getName())) {
            facilityCodeArray = this.visnVamc;
        }else if(StringUtils.equals(facilityDisplayBy,ReportFacilityDisplayBy.CODE_VISN_VAMC_SITE.getName())) {
            facilityCodeArray = this.visnVamcFacility;
        }

        //append the station numbers from text field if enetred (eliminate duplicates)
        String[] codes = getStationNumbersAsArray();
        if (codes != null && codes.length > 0){

            Set newSelection = new HashSet();
            if (facilityCodeArray != null && facilityCodeArray.length > 0){
                for (int i=0; i<facilityCodeArray.length; i++){
                    newSelection.add(facilityCodeArray[i]);
                }
            }

            for (int i=0; i<codes.length; i++){
                newSelection.add(codes[i]);
            }

            int newSize = newSelection.size();
            facilityCodeArray = new String[newSize];
            int index = 0;
            for (Iterator iter = newSelection.iterator(); iter.hasNext();){
                facilityCodeArray[index++] = (String) iter.next();
            }
        }
        return facilityCodeArray;
    }

    public boolean getAllVisnSelected() {
        return StringUtils.contains(this.visn,ReportConstants.ALL) ? true : false;
    }
    public boolean getNoVisnSelected() {
        return StringUtils.contains(this.visn,ReportConstants.NO_VISN_ID) ? true : false;
    }
    public boolean getAllVisnFacilitySelected() {
        return StringUtils.contains(this.visnFacility,ReportConstants.ALL) ? true : false;
    }
    public boolean getAllFacilitySelected() {
        return StringUtils.contains(this.facility,ReportConstants.ALL) ? true : false;
    }
    public boolean getAllVamcSelected() {
        return StringUtils.contains(this.vamcs,ReportConstants.ALL_VAMCS) ? true : false;
    }
    public boolean getAllVisnVamcFacilitySelected() {
        return StringUtils.contains(this.visnVamcFacility,ReportConstants.ALL_VAMCS) ? true : false;
    }
    public boolean getAllVamcFacilitySelected() {
        return StringUtils.contains(this.vamcFacility,ReportConstants.ALL_VAMCS) ? true : false;
    }

    public boolean getAllVisnVamcSelected() {
        return StringUtils.contains(this.visnVamc,ReportConstants.ALL_VAMCS) ? true : false;
    }
    public String[] getVisn() {
        return visn;
    }

    public void setVisn(String[] visn) {
        this.visn = visn;
    }

    public String[] getVisnFacility() {
        return visnFacility;
    }

    public void setVisnFacility(String[] visnFacility) {
        this.visnFacility = visnFacility;
    }

    public String[] getFacility() {
        return facility;
    }

    public void setFacility(String[] facility) {
        this.facility = facility;
    }
    public String[] getVamcFacility() {
		return vamcFacility;
	}

	public void setVamcFacility(String[] vamcFacility) {
		this.vamcFacility = vamcFacility;
	}

	public String[] getVamcs() {
		return vamcs;
	}

	public void setVamcs(String[] vamcs) {
		this.vamcs = vamcs;
	}

	public String[] getVisnVamc() {
		return visnVamc;
	}

	public void setVisnVamc(String[] visnVamc) {
		this.visnVamc = visnVamc;
	}

	public String[] getVisnVamcFacility() {
		return visnVamcFacility;
	}

	public void setVisnVamcFacility(String[] visnVamcFacility) {
		this.visnVamcFacility = visnVamcFacility;
	}
    public String getAddressUpdatedMultipleTimesWithin() {
    	return StringUtils.isNotEmpty(addressUpdatedMultipleTimesWithin) ? addressUpdatedMultipleTimesWithin : "10";
    }

    public void setAddressUpdatedMultipleTimesWithin(
            String addressUpdatedMultipleTimesWithin) {
        this.addressUpdatedMultipleTimesWithin = addressUpdatedMultipleTimesWithin;
    }

    public String getAsOfDate() {
        return asOfDate;
    }

    public void setAsOfDate(String asOfDate) {
        this.asOfDate = asOfDate;
    }


    public String[] getBadAddressReason() {
        return badAddressReason;
    }

    public void setBadAddressReason(String[] badAddressReason) {
        this.badAddressReason = badAddressReason;
    }

    public String getBatchNumber() {
        return batchNumber;
    }

    public void setBatchNumber(String batchNumber) {
        this.batchNumber = batchNumber;
    }

    public String[] getRegistryType() {
        return registryType;
    }

    public String[] getRegistryTypeNoDefault() {
        return registryType;
    }

    public void setRegistryType(String[] registryType) {
        this.registryType = registryType;
    }

    public String[] getCancelDeclineReason() {
        return cancelDeclineReason;
    }

    public void setCancelDeclineReason(String[] cancelDeclineReason) {
        this.cancelDeclineReason = cancelDeclineReason;
    }

    public String getDivision() {
        return division;
    }

    public void setDivision(String division) {
        this.division = division;
    }

    public String[] getEedWeeklyReport() {
        return eedWeeklyReport;
    }

    public void setEedWeeklyReport(String[] eedWeeklyReport) {
        this.eedWeeklyReport = eedWeeklyReport;
    }

    public String getEnrollmentEffectiveDateChange() {
        return enrollmentEffectiveDateChange;
    }

    public void setEnrollmentEffectiveDateChange(
            String enrollmentEffectiveDateChange) {
        this.enrollmentEffectiveDateChange = enrollmentEffectiveDateChange;
    }

    public String getDaysBetweenUpdates() {
        return daysBetweenUpdates;
    }

    public void setDaysBetweenUpdates(String daysBetweenUpdates) {
        this.daysBetweenUpdates = daysBetweenUpdates;
    }

    public String[] getEnrollmentStatus() {
        return enrollmentStatus;
    }

    public boolean getAllEnrollmentStatusSelected() {
        return StringUtils.contains(this.enrollmentStatus,ReportConstants.ALL) ? true : false;
    }

    public void setEnrollmentStatus(String[] enrollmentStatus) {
        this.enrollmentStatus = enrollmentStatus;
    }

    public String[] getPendingEnrollmentStatus() {
        return pendingEnrollmentStatus;
    }

    public boolean getAllPendingEnrollmentStatusSelected() {
        return StringUtils.contains(this.pendingEnrollmentStatus,ReportConstants.ALL) ? true : false;
    }

    public void setPendingEnrollmentStatus(String[] pendingEnrollmentStatus) {
        this.pendingEnrollmentStatus = pendingEnrollmentStatus;
    }

    public String[] getEnrollmentCategory() {
        return enrollmentCategory;
    }

    public void setEnrollmentCategory(String[] enrollmentCategory) {
        this.enrollmentCategory = enrollmentCategory;
    }

    public String[] getEnrollmentOverrideReason() {
        return enrollmentOverrideReason;
    }

    public void setEnrollmentOverrideReason(String[] enrollmentOverrideReason) {
        this.enrollmentOverrideReason = enrollmentOverrideReason;
    }

    public String[] getLetterRejectErrorReason() {
        return letterRejectErrorReason;
    }

    public boolean getAllLetterRejectErrorReasonSelected() {
        return StringUtils.contains(this.letterRejectErrorReason,ReportConstants.ALL) ? true : false;
    }

    public void setLetterRejectErrorReason(String[] letterRejectErrorReason) {
        this.letterRejectErrorReason = letterRejectErrorReason;
    }

    public String[] getLetterRejectReason() {
        return letterRejectReason;
    }

    public boolean getAllLetterRejectReasonSelected() {
        return StringUtils.contains(this.letterRejectReason,ReportConstants.ALL) ? true : false;
    }

    public void setLetterRejectReason(String[] letterRejectReason) {
        this.letterRejectReason = letterRejectReason;
    }


    public String[] getLetterErrorType() {
        return letterErrorType;
    }

    public boolean getAllLetterErrorTypeSelected() {
        return StringUtils.contains(this.letterErrorType,ReportConstants.ALL) ? true : false;
    }

    public void setLetterErrorType(String[] letterErrorType) {
        this.letterErrorType = letterErrorType;
    }

    public String getErrorType() {
        return errorType;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public String getExceptionType() {
        return exceptionType;
    }

    public void setExceptionType(String exceptionType) {
        this.exceptionType = exceptionType;
    }

    public String getReportFormat() {
        return reportFormat;
    }

    public void setReportFormat(String reportFormat) {
        this.reportFormat = reportFormat;
    }

    public String getFileType() {
        return fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getFunctionalGroup() {
        return functionalGroup;
    }

    public void setFunctionalGroup(String functionalGroup) {
        this.functionalGroup = functionalGroup;
    }

    public String getIncludeUsers() {
        return includeUsers;
    }

    public void setIncludeUsers(String includeUsers) {
        this.includeUsers = includeUsers;
    }

    public String getBeginIncomeYear() {
        return beginIncomeYear;
    }

    public void setBeginIncomeYear(String incomeYear) {
        this.beginIncomeYear = incomeYear;
    }
    public String getEndIncomeYear() {
		return endIncomeYear;
	}

	public void setEndIncomeYear(String endIncomeYear) {
		this.endIncomeYear = endIncomeYear;
	}
    public String[] getLetterFile() {
        return letterFile;
    }

    public void setLetterFile(String[] letterFile) {
        this.letterFile = letterFile;
    }

    public String getLetterFileReceivedDate() {
        return letterFileReceivedDate;
    }

    public void setLetterFileReceivedDate(String letterFileReceivedDate) {
        this.letterFileReceivedDate = letterFileReceivedDate;
    }

    public String getMessageError() {
        return messageError;
    }

    public void setMessageError(String messageError) {
        this.messageError = messageError;
    }

    public String getMessageType() {
        return messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public String getRecordsPerEnrollmentStatus() {
        return recordsPerEnrollmentStatus;
    }

    public void setRecordsPerEnrollmentStatus(String recordsPerEnrollmentStatus) {
        this.recordsPerEnrollmentStatus = recordsPerEnrollmentStatus;
    }

    public String[] getPhRejectReason() {
        return phRejectReason;
    }

    public void setPhRejectReason(String[] phRejectReason) {
        this.phRejectReason = phRejectReason;
    }

    public String getPhUnconfirmedForMoreThan() {
        return phUnconfirmedForMoreThan;
    }

    public void setPhUnconfirmedForMoreThan(String phUnconfirmedForMoreThan) {
        this.phUnconfirmedForMoreThan = phUnconfirmedForMoreThan;
    }

    public String[] getPriorityGroup() {
        return priorityGroup;
    }

    public void setPriorityGroup(String[] priorityGroup) {
        this.priorityGroup = priorityGroup;
    }

    public String[] getQueryTo() {
        return queryTo;
    }

    public boolean getAllSitesSelected() {
        return StringUtils.contains(this.queryTo,ReportConstants.ALL_SITES) ? true : false;
    }

    public boolean getAllSitesAndVBASelected() {
        return StringUtils.contains(this.queryTo,ReportConstants.ALL_SITES_AND_VBA) ? true : false;
    }

    public boolean getVbaSelected() {
        return StringUtils.contains(this.queryTo,ReportConstants.VBA) ? true : false;
    }

    public void setQueryTo(String[] queryTo) {
        this.queryTo = queryTo;
    }

    public String getReportDetailBy() {
        return reportDetailBy;
    }

    public void setReportDetailBy(String reportDetailBy) {
        this.reportDetailBy = reportDetailBy;
    }

    public String getUpdateStatus() {
        return updateStatus;
    }

    public void setUpdateStatus(String updateStatus) {
        this.updateStatus = updateStatus;
    }

    public String getReportPeriodType() {
        return reportPeriodType;
    }

    public void setReportPeriodType(String reportPeriodType) {
        this.reportPeriodType = reportPeriodType;
    }

    public String getReportPeriodYear() {
        return reportPeriodYear;
    }

    public void setReportPeriodYear(String reportPeriodYear) {
        this.reportPeriodYear = reportPeriodYear;
    }
    public String getReportPeriodQuarterYear() {
		return reportPeriodQuarterYear;
	}

	public void setReportPeriodQuarterYear(String reportPeriodQuarterYear) {
		this.reportPeriodQuarterYear = reportPeriodQuarterYear;
	}

	public String getReportPeriodSummaryYear() {
		return reportPeriodSummaryYear;
	}

	public void setReportPeriodSummaryYear(String reportPeriodSummaryYear) {
		this.reportPeriodSummaryYear = reportPeriodSummaryYear;
	}
    public String getReportPeriodQuarter() {
        return reportPeriodQuarter;
    }

    public void setReportPeriodQuarter(String reportPeriodQuarter) {
        this.reportPeriodQuarter = reportPeriodQuarter;
    }

    public String getReportPeriodStartDate() {
        return reportPeriodStartDate;
    }

    public void setReportPeriodStartDate(String reportPeriodStartDate) {
        this.reportPeriodStartDate = reportPeriodStartDate;
    }

    public String getReportPeriodEndDate() {
        return reportPeriodEndDate;
    }

    public void setReportPeriodEndDate(String reportPeriodEndDate) {
        this.reportPeriodEndDate = reportPeriodEndDate;
    }

    public String getRunReportByUser() {
        return runReportByUser;
    }

    public void setRunReportByUser(String runReportByUser) {
        this.runReportByUser = runReportByUser;
    }

    public String getRunReportFor() {
        return runReportFor;
    }

    public void setRunReportFor(String runReportFor) {
        this.runReportFor = runReportFor;
    }

    public String getSubtotalDetailLevel() {
        return subtotalDetailLevel;
    }

    public void setSubtotalDetailLevel(String subtotalDetailLevel) {
        this.subtotalDetailLevel = subtotalDetailLevel;
    }

    public String[] getReportUser() {
        return reportUser;
    }

    public boolean getAllReportUserSelected() {
        return StringUtils.contains(this.reportUser,ReportConstants.ALL) ? true : false;
    }

    public void setReportUser(String[] reportUser) {
        this.reportUser = reportUser;
    }

    public String[] getVbaQueryStatus() {
        return vbaQueryStatus;
    }

    public void setVbaQueryStatus(String[] vbaQueryStatus) {
        this.vbaQueryStatus = vbaQueryStatus;
    }

    public String[] getWorkItemStatus() {
        return workItemStatus;
    }

    public void setWorkItemStatus(String[] workItemStatus) {
        this.workItemStatus = workItemStatus;
    }

    public String[] getWorkItemType() {
		return this.workItemType;
	}

	public void setWorkItemType(String[] workItemType) {
		this.workItemType = workItemType;
	}

	public String getOutlierDays() {
        return outlierDays;
    }

    public void setOutlierDays(String outlierDays) {
        this.outlierDays = outlierDays;
    }

    public String[] getEnrollmentStatusComponent() {
        return enrollmentStatusComponent;
    }

    public void setEnrollmentStatusComponent(String[] enrollmentStatusComponent) {
        this.enrollmentStatusComponent = enrollmentStatusComponent;
    }

	public String[] getEligibilityFactors() {
		return eligibilityFactors;
	}
	
    public boolean getAllEligibilityFactors() {
        return StringUtils.contains(this.eligibilityFactors,ReportConstants.ALL) ? true : false;
    }

	public void setEligibilityFactors(String[] eligibilityFactors) {
		this.eligibilityFactors = eligibilityFactors;
	}
	
	public String[] getPersonMergeStatus() {
		return personMergeStatus;
	}

	public void setPersonMergeStatus(String[] personMergeStatus) {
		this.personMergeStatus = personMergeStatus;
	}

    public String getEnrollmentProcessStatus() {
        return enrollmentProcessStatus;
    }

    public void setEnrollmentProcessStatus(String enrollmentProcessStatus) {
        this.enrollmentProcessStatus = enrollmentProcessStatus;
    }

	public String getRandomNumberOfRecords() {
        return this.randomNumberOfRecords;
    }

    public void setRandomNumberOfRecords(String randomNumberOfRecords) {
        this.randomNumberOfRecords = randomNumberOfRecords;
    }

    public String getStationNumbers() {
        return this.stationNumbers;
    }

    public String[] getVoaFormTypes() {
        return voaFormTypes;
    }

    public void setVoaFormTypes(String[] voaFormTypes) {
        this.voaFormTypes = voaFormTypes;
    }

    public String[] getStationNumbersAsArray() {
        if (StringUtils.isNotEmpty(this.stationNumbers)) {
            String[] codes = this.stationNumbers.split(",");
            //trim the spaces from the codes
            int index = 0;
            if (codes != null && codes.length > 0){
                for (int i=0; i<codes.length; i++){
                    String newCode = codes[i].trim();
                    if (StringUtils.isNotEmpty(newCode)){
                        codes[index++] = newCode;
                    }
                }
                //create a new array and return
                if (index > 0){
                    String[] newArray = new String[index];
                    for (int i=0; i<index; i++) {
                        newArray[i] = codes[i];
                    }
                    return newArray;
                }
                else return new String[0];
            }
        }
        return new String[0];
    }

    public void setStationNumbers(String stattionNumbers) {
        this.stationNumbers = stattionNumbers;
    }

    public void initialize() {
        this.fromDate = null;
        this.toDate = null;
        this.fromYear = null;
        this.toYear = null;

        this.facilityDisplayBy = null;
        this.visn = new String[0];
        this.visnFacility = new String[0];
        this.facility = new String[0];
        this.vamcs=new String[0];
        this.vamcFacility=new String[0];
        this.visnVamc=new String[0];
        this.visnVamcFacility=new String[0];
        this.vamc = null;


        this.asOfDate = null;
        this.beginIncomeYear = null;
        this.endIncomeYear = null;
        this.division = null;
        this.functionalGroup = null;
        this.workItemStatus = null;
        this.runReportByUser = null;

        this.errorType = null;
        this.batchNumber = null;
        this.exceptionType = null;

        this.reportUser = new String[0];
        this.badAddressReason = new String[0];
        this.cancelDeclineReason = new String[0];
        this.phRejectReason = new String[0];

        this.includeUsers = null;
        this.messageError = null;
        this.messageType = null;
        this.priorityGroup = new String[0];
        this.enrollmentStatus = new String[0];
        this.pendingEnrollmentStatus = new String[0];
        this.letterRejectErrorReason = new String[0];
        this.enrollmentCategory = new String[0];
        this.enrollmentEffectiveDateChange = null;
        this.recordsPerEnrollmentStatus = null;
        this.queryTo = new String[0];
        this.vbaQueryStatus = null;
        this.reportDetailBy = null;
        this.updateStatus = null;
        this.eedWeeklyReport = new String[0];

        this.reportPeriodType = null;
        this.reportPeriodYear = null;
        this.reportPeriodSummaryYear = null;
        this.reportPeriodQuarterYear = null;
        this.reportPeriodQuarter = null;
        this.reportPeriodStartDate = null;
        this.reportPeriodEndDate = null;

        this.registryType = new String[0];
        this.addressUpdatedMultipleTimesWithin = null;
        this.phUnconfirmedForMoreThan = null;
        this.letterFile = new String[0];
        this.letterFileReceivedDate = null;
        this.subtotalDetailLevel = null;
        this.runReportFor = null;
        this.reportFormat = null;
        this.fileType = null;

        this.enrollmentOverrideReason = new String[0];

        this.enrollmentStatusComponent = new String[0];
        this.personMergeStatus = new String[0];
        this.enrollmentProcessStatus = null;
        this.voaFormTypes = new String[0];
        this.outlierDays = null;
        this.randomNumberOfRecords = null;
        this.stationNumbers = null;
    }


}
