/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.report.action;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;

import gov.va.med.fw.ui.struts.AbstractForm;

/**
 * Common fields for report actions.
 * 
 * @author Muddaiah Ranga
 * @version 1.0
 */
public class ReportInfoForm extends AbstractForm {

    private static final long serialVersionUID = 5539199088424610683L;
   
    private String tabName;
    
    private String reportId;
    private String reportName;
   
 
    private String dummySelect;
    
    public String getTabName() {
        return tabName;
    }

    public void setTabName(String tabName) {
        this.tabName = tabName;
    }

    public String getReportId() {
        return reportId;
    }
    
    public String getReportIdNoSpace() {
        return ReportActionHelper.getRemoveSpaceAndDash(this.reportId);
    }

    public void setReportId(String reportId) {
        this.reportId = reportId;
    }

    public String getReportName() {
        return reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public String getDummySelect() {
        return dummySelect;
    }

    public void setDummySelect(String dummySelect) {
    }

    public List getQm10FiscalYears() {
        return ReportActionHelper.getQm10FiscalYears();
    }

    public List getYears() {
        return ReportActionHelper.getYears();
    }
    
    public List getHours() {
        return ReportActionHelper.getHours();
    }
    
    public List getMinutes() {
        return ReportActionHelper.getMinutes();
    }
    
    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors =  super.validate(mapping,request);
        errors = ReportValidator.validate(this,request,errors);
        return errors;
    }
    
    public void initialize() {
        this.reportId = null;
        this.reportName = null;
        this.dummySelect = null;
    }
}
