// Package 
package gov.va.med.esr.ui.report.action;

// Library Classes
import org.apache.struts.action.ActionForm;

// Framework Classes
import gov.va.med.fw.ui.valuelist.SearchValueListAdapter;
import gov.va.med.fw.ui.valuelist.ValueListException;
import gov.va.med.fw.service.pagination.SearchQueryInfo;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.security.SecurityContext;
import gov.va.med.fw.security.SecurityContextHelper;

// ESR Classes
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.ReportFilterSearchQueryInfo;
import gov.va.med.esr.ui.common.service.LookupCacheService;
import gov.va.med.esr.ui.common.util.DateUtils;

/**
 * A custom value list adapter for the report filter.
 */
public class ReportFilterValueListAdapter extends SearchValueListAdapter
{
    private static final long serialVersionUID = 2221251983336361625L;
    private LookupCacheService lookupCacheService = null;

    /**
     * Performs a custom form to searchQueryInfo conversion to handle lookup data, etc.
     *
     * @param form The form that contains search parameters
     * @param queryInfo The search query info object to populate with the search parameters.
     *
     * @throws gov.va.med.fw.ui.valuelist.ValueListException if there are any problems copying properties.
     */
    protected void populateFormAttributes(ActionForm form, SearchQueryInfo queryInfo)
        throws ValueListException
    {
        // Typecast the arguments
        ReportFilterForm filterForm = (ReportFilterForm)form;
        ReportFilterSearchQueryInfo searchQueryInfo = (ReportFilterSearchQueryInfo)queryInfo;

        // Convert the standard parameters
        searchQueryInfo.setDateFrom(DateUtils.getDate(filterForm.getDateFrom()));
        searchQueryInfo.setDateTo(DateUtils.getDate(filterForm.getDateTo()));

        // Store the logging in user
        SecurityContext securityContext = SecurityContextHelper.getSecurityContext();
        searchQueryInfo.setUser((securityContext != null) ? securityContext.getUserPrincipal() : null);

        // Convert the report exported type
        if (StringUtils.isNotEmpty(filterForm.getFileType()))
        {
            try
            {
                searchQueryInfo.setReportExportedType(getLookupService().getReportExportedTypeByCode(
                    filterForm.getFileType()));
            }
            catch (Exception ex)
            {
                throw new ValueListException("Invalid Report Exported Type Code: " + filterForm.getFileType(), ex);
            }
        }

        // Convert the report Id/Title
        if ((StringUtils.isNotEmpty(filterForm.getReportId())) || (StringUtils.isNotEmpty(filterForm.getReportTitle())))
        {
            String standardReportCode = filterForm.getReportTitle();
            if (StringUtils.isNotEmpty(filterForm.getReportId()))
            {
                standardReportCode = filterForm.getReportId();
            }
            try
            {
                searchQueryInfo.setStandardReport(getLookupService().getStandardReportByCode(standardReportCode));
            }
            catch (Exception ex)
            {
                throw new ValueListException("Invalid Standard Report Code: " + standardReportCode, ex);
            }
        }
        else
        {
            // Only consider adding a report type filter if a report Id isn't added since it would only be
            // redundant.
            if (StringUtils.isNotEmpty(filterForm.getReportType()))
            {
                try
                {
                    searchQueryInfo.setReportType(getLookupService().getReportTypeByCode(
                        filterForm.getReportType()));
                }
                catch (Exception ex)
                {
                    throw new ValueListException("Invalid Report Type Code: " + filterForm.getReportType(), ex);
                }
            }
        }
    }

    public LookupService getLookupService()
    {
        return this.lookupCacheService!=null ? this.lookupCacheService.getLookupService():null;
    }   

    public LookupCacheService getLookupCacheService() {
        return lookupCacheService;
    }

    public void setLookupCacheService(LookupCacheService lookupCacheService) {
        this.lookupCacheService = lookupCacheService;
    }
}
