// Package 
package gov.va.med.esr.ui.report.action;

// Library Classes
import org.apache.struts.action.ActionMapping;
import javax.servlet.http.HttpServletRequest;

// Framework Classes
import gov.va.med.fw.ui.struts.AbstractForm;
import gov.va.med.fw.util.StringUtils;

/**
 * Form to store the user's report filters.
 *
 * @author Andrew Pach
 */
public class ReportFilterForm extends AbstractForm
{
    // Filters
    private static final long serialVersionUID = -8088873663605188176L;
    private String reportType = null;
    private String reportId = null;
    private String reportTitle = null;
    private String fileType = null;
    private String dateFrom = null;
    private String dateTo = null;   
    private boolean displayFilter = false;
    private boolean filterApplied = false;

    public ReportFilterForm()
    {
        super();
    }

    /**
     * Returns whether any filter criteria is specified.
     * @return True if filter criteria is specified or false if not.
     */
    public boolean getContainsFilterCriteria()
    {
        return StringUtils.isNotEmpty(reportType) || StringUtils.isNotEmpty(reportId) ||
            StringUtils.isNotEmpty(reportTitle) || StringUtils.isNotEmpty(fileType) ||
            StringUtils.isNotEmpty(dateFrom) || StringUtils.isNotEmpty(dateTo);
    }

    public String getReportType()
    {
        return reportType;
    }

    public void setReportType(String reportType)
    {
        this.reportType = reportType;
    }

    public String getReportId()
    {
        return reportId;
    }

    public void setReportId(String reportId)
    {
        this.reportId = reportId;
    }

    public String getReportTitle()
    {
        return reportTitle;
    }

    public void setReportTitle(String reportTitle)
    {
        this.reportTitle = reportTitle;
    }

    public String getFileType()
    {
        return fileType;
    }

    public void setFileType(String fileType)
    {
        this.fileType = fileType;
    }

    public String getDateFrom()
    {
        return dateFrom;
    }

    public void setDateFrom(String dateFrom)
    {
        this.dateFrom = dateFrom;
    }

    public String getDateTo()
    {
        return dateTo;
    }

    public void setDateTo(String dateTo)
    {
        this.dateTo = dateTo;
    }

    public void reset(ActionMapping arg0, HttpServletRequest arg1)
    {
        super.reset(arg0, arg1);
    }

    public boolean getDisplayFilter()
    {
        return displayFilter;
    }

    public void setDisplayFilter(boolean displayFilter)
    {
        this.displayFilter = displayFilter;
    }

    public boolean getFilterApplied()
    {
        return filterApplied;
    }

    public void setFilterApplied(boolean filterApplied)
    {
        this.filterApplied = filterApplied;
    }

    public void resetFilter()
    {
        reportType = null;
        reportId = null;
        reportTitle = null;
        fileType = null;
        dateFrom = null;
        dateTo = null;        
        displayFilter = false;
        filterApplied = false;
    }

   
}
