/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.report.action;

import gov.va.med.esr.common.model.lookup.VAFacility;

/**
 * Constants for report actions.
 *
 * @author Muddaiah Ranga
 * @version 1.0
 */
public interface ReportConstants extends gov.va.med.esr.common.report.data.ReportConstants {

    public static final String TAB_NAME_SCHEDULED_REPORTS = "scheduledReports";

    public static final String EMPTY = "";
    public static final String COMMA = ",";
    public static final String EMAIL_DELIMS = " ,;";
    public static final String ALL = "all";
    public static final String NO_VISN_ID = String.valueOf(gov.va.med.esr.common.model.lookup.VISN.CODE_NO_VISN_IDENTIFIER.intValue());    
    public static final String ALL_SITES = "allSites";
    public static final String ALL_VAMCS = "allVAMCs";
    public static final String ALL_SITES_AND_VBA = "allSitesAndVBA";
    public static final String VBA = VAFacility.CODE_MVR.getCode();
    public static final String VISN = "VISN";
    public static final String REQUIRED = "required";
    public static final String NEW_LINE="\n";
    public static final String COLON=": ";
    public static final String HTML_BR="<br>";

    public static final String REPORT_ID = "reportId";
    public static final String CANCEL_REPORT_ID = "cancelReportId";
    public static final String DELETE_REPORT_ID = "deleteReportId";
    public static final String INACTIVE_REPORT_ID = "inactivateReportId";
    public static final String IS_INACTIVE_REPORT = "isInactiveReport";
    public static final String STANDARD_REPORT_LIST = "standardReportList";
    public static final String STANDARD_REPORT_MAP = "standardReportMap";
    public static final String REPORT_TITLE_LIST = "reportTitleList";
    public static final String REPORT_ID_LIST = "reportIdList";
    public static final String REPORT_TYPE_LIST = "reportTypeList";
    public static final String REPORT_STATUS_LIST = "reportStatusList";
    public static final String FILE_TYPE_LIST = "fileTypeList";
    public static final String REPORT_PARAMETER_CONFIG = "reportParamConfigMap";

    public static final String DISPLAY_AVAILABLE_REPORTS = "displayAvailableReports";
    public static final String DISPLAY_AVAILABLE_REPORTS_WITH_MSG = "displayAvailableReportsWithMessage";

    public static final String DISPLAY_SCHEDULED_REPORTS_WITH_MSG = "displayScheduledReportsWithMessage";
    public static final String DISPLAY_SCHEDULED_REPORTS_CANCELLED_MSG = "displayScheduledReportsCancelledMsg";
    public static final String DISPLAY_SCHEDULED_REPORTS_CANCELLED_INVALID_ID = "displayScheduledReportsCancelledInvalidId";
    
    public static final String DISPLAY_COMPLETED_REPORTS_DELETE_MSG = "displayCompletedReportsDeleteMsg";
    public static final String DISPLAY_COMPLETED_INACTIVE_REPORTS_DELETE_MSG = "displayCompletedInactiveReportsDeleteMsg";
    public static final String DISPLAY_COMPLETED_REPORTS_DELETE_INVALID_ID = "displayCompletedReportsDeleteInvalidId";
    public static final String DISPLAY_COMPLETED_REPORTS_INACTIVATE_INVALID_ID = "displayCompletedReportsInactivateInvalidId";
    public static final String DISPLAY_COMPLETED_REPORTS_INACTIVATION_INVALID = "displayCompletedReportsInactivationInvalid";
    public static final String DISPLAY_COMPLETED_REPORTS_INACTIVATED_MSG="displayCompletedReportsInactivatedMsg";
    public static final String DISPLAY_DATA = "displayData";
    public static final String DISPLAY_UPDATED_DATA = "displayUpdatedData";
    public static final String DISPLAY_REPORT = "displayReport";

    public static final String DISPLAY_REPORT_PARAMETERS = "displayReportParameters";

    public static final String DISPLAY_REPORT_SELECTION = "displayReportSelection";
    public static final String DISPLAY_ADD_REPORT_SCHEDULE = "displayAddReportSchedule";
    public static final String DISPLAY_UPDATE_REPORT_SCHEDULE = "displayUpdateReportSchedule";
    public static final String CANCEL = "cancel";

    public static final String COMPLETED_RECPORT_LIST = "completedReportList";
    public static final String AVAILABLE_RECPORT_LIST = "availableReportList";

    public static final String CONTENT_TYPE_APPLICATION_PDF = "application/pdf";
    public static final String CONTENT_TYPE_APPLICATION_CSV = "application/csv";

    public static final String STD_REPORT_TABLE_ID = "stdReportTableId";
    public static final String SCH_REPORT_TABLE_ID = "schReportTableId";
    public static final String CMP_REPORT_TABLE_ID = "cmpReportTableId";
    public static final String ARH_REPORT_TABLE_ID = "arhReportTableId";
    public static final String STD_REPORTS_VALUE_LIST_ADAPTER = "stdReportsValueListAdapter";
    public static final String SCH_REPORTS_VALUE_LIST_ADAPTER = "schReportsValueListAdapter";
    public static final String CMP_REPORTS_VALUE_LIST_ADAPTER = "cmpReportsValueListAdapter";

	public final static String REJECT_CODE_PREFIX = "R.";
	public final static String ERROR_CODE_PREFIX = "E.";
	
    public static final String LABEL_FROM_DATE = "label.report.fromDate";
    public static final String LABEL_TO_DATE = "label.report.toDate";
    public static final String LABEL_REPORT_FORMAT = "label.report.reportFormat";
    public static final String LABEL_REPORT_DETAIL_BY = "label.report.reportDetailsBy";
    public static final String LABEL_UPDATE_STATUS = "label.report.updateStatus";
    public static final String LABEL_REPORT_MESSAGE_TYPE = "label.report.messageType";

    
    public static final String LABEL_GENERATE_REPORT = "label.report.generateReport";
    public static final String LABEL_DAY_TO_GENERATE_REPORT = "label.report.dayToGenerateReport";
    public static final String LABEL_DATE_TO_GENERATE_REPORT = "label.report.dateToGenerateReport";
    public static final String LABEL_DAY_TO_MONTH = "label.report.dayOfMonth";
    public static final String LABEL_EMAIL_REPORT_TO= "label.report.emailReportTo";
    public static final String LABEL_DATE_FILTER = "dateFilter";
    public static final String LABEL_REPORT_ID = "reportId";
    public static final String LABEL_REPORT_TITLE = "reportTitle";
    public static final String LABEL_REPORT_TYPE = "reportType";
    public static final String LABEL_REPORT_ARCHIVED_DATE = "reportArchivedDate";

    public static final String LABEL_REPORT_PERIOD_FROM = "label.report.from";
    public static final String LABEL_REPORT_PERIOD_TO = "label.report.to";
    public static final String LABEL_REPORT_AS_OF_DATE = "label.report.asOfDate";

    public static final String EMAIL_REG_EXPR = "[a-zA-Z][\\w\\.-]*[a-zA-Z0-9]@[a-zA-Z0-9][\\w\\.-]*[a-zA-Z0-9]\\.[a-zA-Z][a-zA-Z\\.]*[a-zA-Z]";

    public static final String ERROR_INVALID_EMAIL = "errors.email";
    public static final String ERROR_INVALID_START_END_DATES = "errors.invalidStartEndDates";
    public static final String ERROR_DATE_NO_FUTURE = "errors.validateDateFuture";
    public static final String ERROR_INVALID_DATE_RANGE = "errors.invalidDateRange";
    public static final String ERROR_INVALID_FROM_DATE = "errors.invalidFromDate";
    public static final String ERROR_DATE_NO_PAST = "errors.validateDatePast";
    public static final String ERROR_REPORT_ID_AND_TITLE_MUST_MATCH="errors.report.reportIdAndTitleMustMatch";
    public static final String ERROR_REPORT_ID_AND_TYPE_MUST_MATCH="errors.report.reportIdAndTypeMustMatch";
    
    public static final String ERROR_EITHER_FROM_AND_TO_DATE_OR_AS_OF_DATE_REQUIRED = "errors.fromDateToDatesOrAsOfDateRequired";
    public static final String ERROR_BOTH_FROM_AND_TO_DATE_AND_AS_OF_DATE_NOT_ALLOWED = "errors.bothFromDateToDatesAndAsOfDateNotAllowed";

    public static final String ERROR_INVALID_IMPRECISE_DATE_WITH_MONTH = "errors.imprecisedateWithMonth";
    
    public static final String QM7_TITLE="Inbound Messages From Sites";
    public static final String QM9_TITLE="Inbound Messages From MVR (VBA)";
    public static final String QM12_TITLE="Outbound Messages To Sites";

    // Session Keys
    public static final String ERROR_MESSAGE_SESSION_KEY =
        "reportingErrorMessageSessionKey";
    public static final String INFO_MESSAGE_SESSION_KEY = "reportingInfoMessageSessionKey";

}
