/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.report.action;

import gov.va.med.esr.common.model.lookup.StandardReport;
import gov.va.med.esr.common.model.report.CompletedReport;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.fw.report.ReportExportedType;

import java.io.Serializable;

import org.apache.commons.lang.Validate;

/**
 * Wrapper bean for the ReportSetup.
 * 
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class ReportBean implements Serializable {

    /**
	 * 
	 */
	private static final long serialVersionUID = -1370346746640850300L;
	private ReportSetup reportSetup;
    private ReportParameterSet paramSet;
    private StandardReport stdReport;
    private CompletedReport completedReport;
    
    public ReportBean(ReportSetup reportSetup) {
        Validate.notNull(reportSetup,"ReportSetup report cannot be null");
        this.reportSetup = reportSetup;
        this.stdReport = this.reportSetup.getReport();
        this.paramSet = this.reportSetup.getParameterSet();
    }
    
    public ReportBean(CompletedReport completedReport) {
        Validate.notNull(completedReport,"CompletedReport report cannot be null");
        this.stdReport = completedReport.getStandardReport();
    }
    
    public String getId() {
        return null;
    }
    
    public String getReportId() {
        return (this.stdReport != null) ? this.stdReport.getCode(): "";
    }
    
    public String getReportIdNoSpace() {
        return ReportActionHelper.getRemoveSpaceAndDash(this.getReportId());
    }

    public String getType() {
        return (this.stdReport != null && this.stdReport.getType() != null) ? this.stdReport.getType().getDescription(): "";
    }
    
    public String getName() {
        return (this.stdReport != null) ? this.stdReport.getDescription(): "";
    }

    public String getScheduledRunDate() {
        return DateUtils.format(DateUtils.getCurrentDate(),DateUtils.MMDDYYYY);
    }
    
    public String getCompletedDate() {
        
        return DateUtils.format(((this.completedReport != null) ? completedReport.getCompletedDate() : null),DateUtils.MMDDYYYY);
    }

    public ReportExportedType getFileType() {
        ReportExportedType  fileType = (this.paramSet != null) ? this.paramSet.getFileType() : null;
        if(fileType == null) {
            fileType = (this.completedReport != null) ? completedReport.getFileType() : null;
        }
        return fileType;
    }  
}
