// Package 
package gov.va.med.esr.ui.report.action;

// Library Classes
import org.apache.struts.action.ActionForm;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.collections.comparators.NullComparator;
import org.apache.commons.beanutils.BeanComparator;

// Framework Classes
import gov.va.med.fw.ui.valuelist.ValueListException;
import gov.va.med.fw.service.pagination.SearchQueryInfo;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.util.SortElement;

// ESR Classes
import gov.va.med.esr.service.CompletedReportsSearchQueryInfo;
import gov.va.med.esr.service.ReportStatus;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.common.model.lookup.StandardReport;

import java.util.List;
import java.util.Iterator;
import java.util.Comparator;
import java.util.Collections;

/**
 * A custom value list adapter for the completed reports.
 */
public class CompletedReportsValueListAdapter extends ReportFilterValueListAdapter
{
    private static final long serialVersionUID = 6578674859550242811L;

    /**
     * Performs a custom form to searchQueryInfo conversion for completed reports.
     *
     * @param form The form that contains search parameters
     * @param queryInfo The search query info object to populate with the search parameters.
     *
     * @throws gov.va.med.fw.ui.valuelist.ValueListException if there are any problems copying properties.
     */
    protected void populateFormAttributes(ActionForm form, SearchQueryInfo queryInfo)
        throws ValueListException
    {
        super.populateFormAttributes(form, queryInfo);

        // Typecast the arguments
        CompletedReportsForm searchForm = (CompletedReportsForm)form;
        CompletedReportsSearchQueryInfo searchQueryInfo = (CompletedReportsSearchQueryInfo)queryInfo;

        // Convert completed report specific parameters
        searchQueryInfo.setReportParameters(StringUtils.isEmpty(searchForm.getReportParameters()) ?
            null : searchForm.getReportParameters());
        
        searchQueryInfo.setInactivatedDate(DateUtils.getDate(searchForm.getInactivatedDate()));
        try{
            searchQueryInfo.setReportStatus((ReportStatus)getLookupCacheService().getByCodeFromCache(ReportStatus.class, searchForm.getReportStatus()));
        }catch (Exception e)
        {
            throw new ValueListException("Unable to find ReportStatus for the code: "+ searchForm.getReportStatus(),e);
        }
    }

    /**
     * Sorts the results list using the sort elements.
     *
     * @param results The results to sort
     * @param sortElements The sort elements
     */
    protected void performSort(List results, List sortElements)
    {
        if ((sortElements != null) && (sortElements.size() > 0) && (results != null) &&
            (results.size() > 0))
        {
            ComparatorChain chain = new ComparatorChain();
            for (Iterator iterator = sortElements.iterator(); iterator.hasNext();)
            {
                // Get the sort element and defined a default NullComparator
                SortElement sortElement = (SortElement)iterator.next();
                Comparator sortComparator = new NullComparator();

                // If sorting on the standardReport.code, add a custom comparator to handle
                // proper sorting on the alphabetic and numeric portions of the code.
                if ("standardReport.code".equals(sortElement.getSortColumn()))
                {
                    sortComparator = StandardReport.getCodeComparator();
                }
                chain.addComparator(
                    new BeanComparator(sortElement.getSortColumn(), sortComparator),
                    sortElement.getSortDirection().equals(SortElement.DESCENDING));
            }
            Collections.sort(results, chain);
        }
    }
}
