// Package 
package gov.va.med.esr.ui.report.action;

// Framework Classes
import gov.va.med.fw.util.StringUtils;

/**
 * Form to store the user's completed reports filters.
 *
 * @author Andrew Pach
 */
public class CompletedReportsForm extends ReportFilterForm
{
    // Filters
    private static final long serialVersionUID = -7996580143839683154L;
    private String reportParameters = null;
    /**
     * Report Status default value is Active
     */
    private String reportStatus="1";
    
    /**
     * Inactivated Date
     */
    private String inactivatedDate=null;
    
    /**
     * Filter cached flag.
     */
    private boolean filterCached;

    public boolean isFilterCached() {
        return filterCached;
    }

    public void setFilterCached(boolean filterCached) {
        this.filterCached = filterCached;
    }

    public CompletedReportsForm()
    {
        super();
    }

    public String getReportParameters()
    {
        return reportParameters;
    }

    public void setReportParameters(String reportParameters)
    {
        this.reportParameters = reportParameters;
    }

    /**
     * Returns whether any filter criteria is specified.
     * @return True if filter criteria is specified or false if not.
     */
    public boolean getContainsFilterCriteria()
    {
        return super.getContainsFilterCriteria() || StringUtils.isNotEmpty(reportParameters) ||
        StringUtils.isNotEmpty(inactivatedDate) || StringUtils.isNotEmpty(reportStatus);
    }

    public void resetFilter()
    {
        super.resetFilter();
        reportStatus="1";
        inactivatedDate=null;
        reportParameters = null;
    }   
   
    
    public String getInactivatedDate() {
        return inactivatedDate;
    }

    public void setInactivatedDate(String archivedDate) {
        this.inactivatedDate = archivedDate;
    }

    public String getReportStatus() {
        return reportStatus;
    }

    public void setReportStatus(String reportStatus) {
        this.reportStatus = reportStatus;
    }
}
