/*********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.registry.action;

// Java Classes
import java.util.Iterator;
import java.util.List;

import net.mlw.vlh.ValueListInfo;

import org.apache.struts.action.ActionForm;

import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.service.RegistrySearchCriteria;
import gov.va.med.esr.service.RegistrySearchResultBean;
import gov.va.med.esr.ui.common.service.LookupCacheService;
import gov.va.med.esr.ui.common.util.JspUtils;
import gov.va.med.fw.service.pagination.SearchQueryInfo;
import gov.va.med.fw.ui.valuelist.SearchValueListAdapter;
import gov.va.med.fw.ui.valuelist.ValueListException;
import gov.va.med.fw.util.StringUtils;

/**
 * Value list adapter for Registry Search.
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class RegistrySearchValueListAdapter extends SearchValueListAdapter
{
    private static final long serialVersionUID = 5706057699566470164L;
    
    private LookupCacheService lookupCacheService;
    
    /**
     * Populates the search query info from the action form.
     * 
     * @param actionForm the action form
     * @param searchQueryInfo the search query info bean
     */
    protected void populateFormAttributes(ActionForm actionForm, SearchQueryInfo searchQueryInfo) throws ValueListException
    {
        try
        {
            RegistrySearchForm form = (RegistrySearchForm)actionForm;
            RegistrySearchCriteria criteria = (RegistrySearchCriteria)searchQueryInfo;
            
            criteria.setSsn(SSN.formatSSN(form.getSsn()));

            if(StringUtils.isNotEmpty(form.getLastName())) {
                criteria.setLastName(form.getLastName().trim());
            }
            if(StringUtils.isNotEmpty(form.getFirstName())) {
                criteria.setFirstName(form.getFirstName().trim());
            }
            if(StringUtils.isNotEmpty(form.getMilitaryServiceNumber())) {
                criteria.setMilitaryServiceNumber(form.getMilitaryServiceNumber().trim());
            }
            if(StringUtils.isNotEmpty(form.getRegistryType())) {
                criteria.setRegistryType((RegistryType)lookupCacheService.getByCodeFromCache(RegistryType.class,form.getRegistryType().trim()));
            }
        }
        catch (Exception ex)
        {
            throw new ValueListException("Unable to copy properties from FormBean to SearchQueryInfo.", ex);
        }
    }

    /**
     * Formates the query results for displaying on the screen.
     */
    protected List performPostQueryProcessing(List results, SearchQueryInfo searchQueryInfo, ValueListInfo info) throws ValueListException
    {
        if(results != null && !results.isEmpty()) {
            for(Iterator iter=results.iterator(); iter.hasNext();) {
                RegistrySearchResultBean bean = (RegistrySearchResultBean)iter.next();
                String ssn = StringUtils.isNotEmpty(StringUtils.trim(bean.getSsn())) ?
                    JspUtils.displaySSN(bean.getSsn()) : UNKNOWN;
                bean.setSsn(ssn);
            }
        }
        return results;
    }
    
    public LookupCacheService getLookupCacheService() {
        return lookupCacheService;
    }

    public void setLookupCacheService(LookupCacheService lookupCacheService) {
        this.lookupCacheService = lookupCacheService;
    }
}