/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.registry.action;

// ESR classes



import gov.va.med.fw.ui.struts.AbstractForm;
import gov.va.med.fw.util.StringUtils;



import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;


import gov.va.med.esr.ui.ApplicationConstants.MessageKeys;


/**
 * Action form for registry search.
 * 
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class RegistrySearchForm extends AbstractForm {
    
    private static final long serialVersionUID = -7510797658197035154L;
    
    public final static String Y    = "y";
    public final static String N    = "n";
    
    private String registryType;
    private String ssn;
    private String firstName;
    private String lastName;
    private String militaryServiceNumber;
    
    private String searchedFlag;
    
    public static final String PATTERN_REGEX = "[\\s\\w-?]*"; // #########	

    
    
    public String getRegistryType() {
        return this.registryType;
    }

    public void setRegistryType(String registryType) {
        this.registryType = registryType;
    }

    public String getSsn() {
        return ssn;
    }

    public void setSsn(String ssn) {
        this.ssn = ssn;
    }

    public String getFirstName() {
        return firstName;
    }
    
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getMilitaryServiceNumber() {
        return militaryServiceNumber;
    }

    public void setMilitaryServiceNumber(String militaryServiceNumber) {
        this.militaryServiceNumber = militaryServiceNumber;
    } 
    
    public String getSearchedFlag() {
        return searchedFlag;
    }

    public void setSearchedFlag(String searchedFlag) {
        this.searchedFlag = searchedFlag;
    }

    protected boolean isRequiredFieldsFilled() {
        if(StringUtils.isNotEmpty(this.ssn) || 
           StringUtils.isNotEmpty(this.lastName) || 
           StringUtils.isNotEmpty(this.militaryServiceNumber)) {
            return true;
        }
        return false;
    }
    
    public void clear() {
        this.initialize();
        this.searchedFlag = null;
    }
    
    protected void initialize() {
        this.registryType = null;
        this.ssn = null;
        this.firstName = null;
        this.lastName = null;
        this.militaryServiceNumber = null;
    }
    
    public boolean validateForm(HttpServletRequest request) {		
		boolean valid = true;		
		Map<String, String[]> parameterMap = request.getParameterMap();
		for(Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
			if(valid){
				String key = entry.getKey();			
				String[] values = entry.getValue();
				if (!key.equals("OWASP_CSRFTOKEN") && !key.equals("org.apache.struts.taglib.html.TOKEN")) {
					if(key != null ) {					
						if(StringUtils.validateEntry(key, PATTERN_REGEX)){							
							if(StringUtils.contains(key, "--")){							
								valid = false;													
							}
							else{
								valid = true;
							}
						}
						else{						
							valid = false;								
						}
					}
					
					if(valid = true && values != null) {
						for(int i = 0; i < values.length; i++) {
							String value = values[i];							
							if(StringUtils.validateEntry(value, PATTERN_REGEX)){							
								if(StringUtils.contains(value, "--")){									
									valid = false;											
								}
								else{
									valid = true;
								}
							}
							else{							
								valid = false;								
							}					
						}
					}		
				}
			}
			else{				
				break;
			}			
		}		
		return valid;
	}
    
    @Override
	public ActionMessages validateForm(ActionMapping mapping,
			HttpServletRequest request) {
		ActionMessages messages = new ActionMessages();		
		Map<String, String[]> parameterMap = request.getParameterMap();
		for(Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
			String key = entry.getKey();			
			String[] values = entry.getValue();
			if (!key.equals("OWASP_CSRFTOKEN") && !key.equals("org.apache.struts.taglib.html.TOKEN")) {
				if(key != null ) {				
					if(StringUtils.validateEntry(key, PATTERN_REGEX)){						
						if(StringUtils.contains(key, "--")){						
							messages.add(ActionMessages.GLOBAL_MESSAGE, new ActionMessage(MessageKeys.ERRORS_DETAIL, key + " is invalid"));						
						}
					}
					else{					
						messages.add(ActionMessages.GLOBAL_MESSAGE, new ActionMessage(MessageKeys.ERRORS_DETAIL, key + " is invalid"));				
					}
				}
				
				
				if(values != null) {
					for(int i = 0; i < values.length; i++) {
						String value = values[i];	
						boolean validateValue = true;
						if(key.equals("encry")){
							validateValue = false;					
						}
						if(validateValue){
							if(StringUtils.validateEntry(value, PATTERN_REGEX)){							
								if(StringUtils.contains(value, "--")){							
									messages.add(ActionMessages.GLOBAL_MESSAGE, new ActionMessage(MessageKeys.ERRORS_DETAIL, value + " is invalid"));				
								}
							}
							else{							
								messages.add(ActionMessages.GLOBAL_MESSAGE, new ActionMessage(MessageKeys.ERRORS_DETAIL, value + " is invalid"));				
							}						
						}					
					}
				}
			}
		}		
		return messages;
	}
}
