/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.registry.action;

// Java classes
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

// Library classes
import net.mlw.vlh.ValueList;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

// ESR classes
import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.esr.ui.ApplicationConstants;
import gov.va.med.esr.ui.common.action.AbstractAction;
import gov.va.med.esr.ui.common.service.LookupCacheService;
import gov.va.med.fw.ui.struts.ValueListActionUtils;
import gov.va.med.fw.ui.valuelist.MaxRecordsExceededValueListException;

/**
 * Action class for registry search.
 * 
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class RegistrySearchAction extends AbstractAction implements RegistryConstants {
    
    /**
     * Displays the registry search screen.
     * 
     * @param mapping
     *           Struts action mapping for this action
     * @param actionForm
     *           Struts form bean for this action
     * @param request
     *           The Http Request
     * @param response
     *           The Http Response
     *           
     * @return A struts action forward for where we will go next.
     * @throws Exception
     *            If there are any errors during processing.
     */
    public ActionForward display(ActionMapping mapping, 
                                 ActionForm actionForm,
                                 HttpServletRequest request, 
                                 HttpServletResponse response) throws Exception {
        RegistrySearchForm form  = (RegistrySearchForm)actionForm;
        this.initialise(request);
        if(form.isRequiredFieldsFilled()&& form.validateForm(request))  {
            return search(mapping,form,request,response);
        }
        clear(actionForm);
        return mapping.findForward(DISPLAY);
    }
    
    public void clear(ActionForm actionForm) throws Exception {
        ((RegistrySearchForm)actionForm).clear();        
    }   

    
    /**
     * Clears the registry search screen.
     * 
     * @param mapping
     *           Struts action mapping for this action
     * @param actionForm
     *           Struts form bean for this action
     * @param request
     *           The Http Request
     * @param response
     *           The Http Response
     *           
     * @return A struts action forward for where we will go next.
     * @throws Exception
     *            If there are any errors during processing.
     */
    public ActionForward clear(ActionMapping mapping, 
                               ActionForm actionForm,
                               HttpServletRequest request, 
                               HttpServletResponse response) throws Exception {
        ((RegistrySearchForm)actionForm).clear();
        return mapping.findForward(DISPLAY);
    }
    
    /**
     * Searches the registry.
     * 
     * @param mapping
     *           Struts action mapping for this action
     * @param actionForm
     *           Struts form bean for this action
     * @param request
     *           The Http Request
     * @param response
     *           The Http Response
     *           
     * @return A struts action forward for where we will go next.
     * @throws Exception
     *            If there are any errors during processing.
     */
    public ActionForward search(ActionMapping mapping, 
                                ActionForm actionForm,
                                HttpServletRequest request, 
                                HttpServletResponse response) throws Exception {
        RegistrySearchForm form  = (RegistrySearchForm)actionForm;
        form.setSearchedFlag(RegistryInfoForm.Y);
        try {
            // Get the value list information
            ValueList valueList = ValueListActionUtils.getValueList(form,request,REGISTRY_SEARCH_TABLE_ID,REGISTRY_SEARCH_ADAPTER);
            ValueListActionUtils.setValueList(request, valueList,VALUE_LIST);
            if(valueList == null || !valueList.hasNext()) {
                addInformationMessage(request,ApplicationConstants.MessageKeys.ERRORS_SEARCH_NORESULT);
            }
        } catch (MaxRecordsExceededValueListException ex) {
            // The search exceeded the maximum number of records allowed.
            addActionMessage(request, new ActionMessage(ApplicationConstants.MessageKeys.ERRORS_MAX_RECORDS_EXCEEDED,
                    new Integer(ex.getTotalRecords()), new Integer(ex.getRecordLimit())));
        }
        return mapping.findForward(DISPLAY);
    }
    
    protected Map getKeyMethodMap() {
        if(keyMethodMap == null) {
            keyMethodMap = new HashMap();
            keyMethodMap.put("button.display","display");
            keyMethodMap.put("button.search","search");
            keyMethodMap.put("button.clear","clear");
            keyMethodMap.put("button.cancel", "cancel");
        }
        return keyMethodMap;
    }
    
    public void afterPropertiesSet() {}
    
    /**
     * This method creates a new RegistryType list in some specific order. Because the default order is not good for the ui.
     */
    protected void initialise(HttpServletRequest request) throws Exception {
        List list = (List)request.getSession().getAttribute(REGISTRY_TYPE_LIST);
        if(list == null) {
            list = new ArrayList();
            LookupCacheService lookupCacheService = this.getLookupCacheService();
            list.add(lookupCacheService.getByCodeFromCache(RegistryType.class,RegistryType.CODE_PH_REGISTRY.getName()));
            list.add(lookupCacheService.getByCodeFromCache(RegistryType.class,RegistryType.CODE_POW_REGISTRY.getName()));
            list.add(lookupCacheService.getByCodeFromCache(RegistryType.class,RegistryType.CODE_SHAD_REGISTRY.getName()));
            request.getSession().setAttribute(REGISTRY_TYPE_LIST,list);
        }
    }
}
