/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.registry.action;

import gov.va.med.fw.util.StringUtils;

/**
 * Action form for SHAD registry edit action.
 * 
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class RegistrySHADInfoForm extends RegistryPHSHADInfoForm {

    private static final long serialVersionUID = -6312815752536814828L;
    
    private String shadIndicator;
    private String claimNumber;

    public RegistrySHADInfoForm() {
        this.initialize();
    }
    
    public String getShadIndicator() {
        return shadIndicator;
    }

    public void setShadIndicator(String shadIndicator) {
        this.shadIndicator = shadIndicator;
    }

    public String getClaimNumber() {
        return claimNumber;
    }

    public void setClaimNumber(String claimNumber) {
        this.claimNumber = claimNumber;
    }

    public void addSHADDocument() {
        this.getDocumentIdList().add("");
        this.getDocumentTypeList().add("");
        this.getDocumentReceivedDateList().add("");
        this.getDocumentHashCodeList().add("");
    }
    
    public void addSHADDocument(String id, 
                                String documentType,
                                String documentReceivedDate,
                                String hashCode) {
        this.getDocumentIdList().add(id);
        this.getDocumentTypeList().add(documentType);
        this.getDocumentReceivedDateList().add(documentReceivedDate);
        this.getDocumentHashCodeList().add(hashCode);
    }
    
    public boolean isSHADDocumentEmpty(int documentIndex) {
        if(documentIndex < this.getDocumentIdList().size()) {
            if(StringUtils.isEmpty((String)getDocumentType(documentIndex)) && 
               StringUtils.isEmpty((String)getDocumentReceivedDate(documentIndex))) {
                return true;
            } 
        }
        return false;
    }
    
    protected void initialize() {
        super.initialize();
        this.shadIndicator = null;
        this.claimNumber = null;
    }
}
