/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.registry.action;

// Java classes
import java.util.ArrayList;
import java.util.List;

// ESR classes
import gov.va.med.fw.util.StringUtils;

/**
 * Action form for POW registry edit action.
 * 
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class RegistryPOWInfoForm extends RegistryInfoForm {

    private static final long serialVersionUID = 511356272148747841L;
    
    private List episodeId;
    private String powIndicator;
    private String dateDeath;
    private List powCaptureDate;
    private List powReleaseDate;
    private List powCaptivityDays;
    private List confinementLocation;
    private List campLocation;
    private List episodeHashCode;
    private List powEpisodeEnteredDate;
    private List powEpisodeEnteredBy;
    
    private String icn;
    private String dateEntered;
    
    public RegistryPOWInfoForm() {
        this.initialize();
    }
    
    public String getEpisodeId(int index) {
        return (String)episodeId.get(index);
    }
    
    public List getEpisodeIdList() {
        return episodeId;
    }
   
    public void setEpisodeId(int index, String episodeId) {
        setElement(this.episodeId,index,episodeId);
    }
    
    public int getEpisodeCount() {
        return (episodeId != null) ? episodeId.size() : 0;
    }
    
    public String getPowIndicator() {
        return powIndicator;
    }

    public void setPowIndicator(String powIndicator) {
        this.powIndicator = powIndicator;
    }

    public String getDateDeath() {
        return dateDeath;
    }
    
    public void setDateDeath(String dateDeath) {
        this.dateDeath = dateDeath;
    }
    
    public String getPowCaptureDate(int index) {
        return (String)powCaptureDate.get(index);
    }
    
    public List getPowCaptureDateList() {
        return powCaptureDate;
    }
   
    public void setPowCaptureDate(int index, String powCaptureDate) {
        setElement(this.powCaptureDate,index,powCaptureDate);
    }
    
    public String getPowReleaseDate(int index) {
        return (String)powReleaseDate.get(index);
    }
    
    public List getPowReleaseDateList() {
        return powReleaseDate;
    }
   
    public void setPowReleaseDate(int index, String powReleaseDate) {
        setElement(this.powReleaseDate,index,powReleaseDate);
    }
    
    public String getPowCaptivityDays(int index) {
        return (String)powCaptivityDays.get(index);
    }
    
    public List getPowCaptivityDaysList() {
        return powCaptivityDays;
    }
   
    public void setPowCaptivityDays(int index, String powCaptivityDays) {
        setElement(this.powCaptivityDays,index,powCaptivityDays);
    }
    
    public String getConfinementLocation(int index) {
        return (String)confinementLocation.get(index);
    }
    
    public List getConfinementLocationList() {
        return confinementLocation;
    }
   
    public void setConfinementLocation(int index, String confinementLocation) {
        setElement(this.confinementLocation,index,confinementLocation);
    }

    public String getCampLocation(int index) {
        return (String)campLocation.get(index);
    }
    
    public List getCampLocationList() {
        return campLocation;
    }
   
    public void setCampLocation(int index, String campLocation) {
        setElement(this.campLocation,index,campLocation);
    }
    
    public String getPowEpisodeEnteredDate(int index) {
        return (String)powEpisodeEnteredDate.get(index);
    }
    
    public List getPowEpisodeEnteredDateList() {
        return powEpisodeEnteredDate;
    }
   
    public void setPowEpisodeEnteredDate(int index, String powEpisodeEnteredDate) {
        setElement(this.powEpisodeEnteredDate,index,powEpisodeEnteredDate);
    }
    
    public String getPowEpisodeEnteredBy(int index) {
        return (String)powEpisodeEnteredBy.get(index);
    }
    
    public List getPowEpisodeEnteredByList() {
        return powEpisodeEnteredBy;
    }
   
    public void setPowEpisodeEnteredBy(int index, String powEpisodeEnteredBy) {
        setElement(this.powEpisodeEnteredBy,index,powEpisodeEnteredBy);
    }

    public String getEpisodeHashCode(int index) 
    {
        return (String)episodeHashCode.get(index);
    }
    
    public List getEpisodeHashCodeList() 
    {
        return episodeHashCode;
    }

    public void setEpisodeHashCode(int index, String hashCode) 
    {
        setElement(this.episodeHashCode,index,hashCode);
    }
    
    public String getIcn() {
        return icn;
    }

    public void setIcn(String icn) {
        this.icn = icn;
    }

    public String getDateEntered() {
        return dateEntered;
    }

    public void setDateEntered(String dateEntered) {
        this.dateEntered = dateEntered;
    }

    public void addPOWEpisode() {
        this.getEpisodeIdList().add("");
        this.getDataSourceList().add("");
        this.getDocumentTypeList().add("");
        this.getPowCaptureDateList().add("");
        this.getPowReleaseDateList().add("");
        this.getPowCaptivityDaysList().add("");
        this.getConfinementLocationList().add("");
        this.getCampLocationList().add("");
        this.getPowEpisodeEnteredDateList().add("");
        this.getPowEpisodeEnteredByList().add("");
        this.getEpisodeHashCodeList().add("");
    }
    
    public void addPOWEpisode(String id, 
                              String documentType,
                              String dataSource,
                              String captureDate,
                              String releaseDate,
                              String daysInCaptivity,
                              String confinementLocation,
                              String campLocation,
                              String enteredDate,
                              String enteredBy,
                              String hashCode) {
        this.getEpisodeIdList().add(id);
        this.getDataSourceList().add(dataSource);
        this.getDocumentTypeList().add(documentType);
        this.getPowCaptureDateList().add(captureDate);
        this.getPowReleaseDateList().add(releaseDate);
        this.getPowCaptivityDaysList().add(daysInCaptivity);
        this.getConfinementLocationList().add(confinementLocation);
        this.getCampLocationList().add(campLocation);
        this.getPowEpisodeEnteredDateList().add(enteredDate);
        this.getPowEpisodeEnteredByList().add(enteredBy);
        this.getEpisodeHashCodeList().add(hashCode);
    }
    
    public boolean isPOWEpisodeEmpty(int episodeIndex) {
        if(episodeIndex < this.getEpisodeIdList().size()) {
            if(StringUtils.isEmpty((String)getDataSource(episodeIndex)) &&
               StringUtils.isEmpty((String)getDocumentType(episodeIndex)) &&
               StringUtils.isEmpty((String)getPowCaptureDate(episodeIndex)) &&
               StringUtils.isEmpty((String)getPowReleaseDate(episodeIndex)) &&
               StringUtils.isEmpty((String)getConfinementLocation(episodeIndex)) &&
               StringUtils.isEmpty((String)getCampLocation(episodeIndex))) {
                return true;
            } 
        }
        return false;
    }
    
    protected void initialize() {
        super.initialize();
        this.powIndicator = null;
        this.dateDeath = null;
        this.episodeId = new ArrayList();
        this.powCaptureDate = new ArrayList();
        this.powReleaseDate = new ArrayList();
        this.powCaptivityDays = new ArrayList();
        this.confinementLocation = new ArrayList();
        this.campLocation = new ArrayList();
        this.episodeHashCode = new ArrayList();
        this.powEpisodeEnteredDate = new ArrayList();
        this.powEpisodeEnteredBy = new ArrayList();
        
        this.icn = null;
        this.dateEntered = null;
    }
}
