/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.registry.action;

import java.util.ArrayList;
import java.util.List;

/**
 * Base form for PH and SHAD action form.
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class RegistryPHSHADInfoForm extends RegistryInfoForm {
    
    private static final long serialVersionUID = 8752100591863047815L;
    
    private List documentId;
    private List documentReceivedDate;
    private List documentLogInDate;
    private List documentLoggedInBy;
    private List documentAcceptable;
    private List unacceptableRemark;
    private List documentHashCode;
    
    public String getDocumentId(int index) {
        return (String)documentId.get(index);
    }
    
    public List getDocumentIdList() {
        return documentId;
    }
   
    public void setDocumentId(int index, String documentId) {
        setElement(this.documentId,index,documentId);
    }
    
    public int getDocumentCount() {
        return (documentId != null) ? documentId.size() : 0;
    }
    
    public String getDocumentReceivedDate(int index) {
        return (String)documentReceivedDate.get(index);
    }
    
    public List getDocumentReceivedDateList() {
        return documentReceivedDate;
    }
   
    public void setDocumentReceivedDate(int index, String documentReceivedDate) {
        setElement(this.documentReceivedDate,index,documentReceivedDate);
    }
    
    public String getDocumentLogInDate(int index) {
        return (String)documentLogInDate.get(index);
    }
    
    public List getDocumentLogInDateList() {
        return documentLogInDate;
    }
   
    public void setDocumentLogInDate(int index, String documentLogInDate) {
        setElement(this.documentLogInDate,index,documentLogInDate);
    }
    
    public String getDocumentLoggedInBy(int index) {
        return (String)documentLoggedInBy.get(index);
    }
    
    public List getDocumentLoggedInByList() {
        return documentLoggedInBy;
    }
   
    public void setDocumentLoggedInBy(int index, String documentLoggedInBy) {
        setElement(this.documentLoggedInBy,index,documentLoggedInBy);
    }
    
    public String getDocumentAcceptable(int index) {
        return (String)documentAcceptable.get(index);
    }
    
    public List getDocumentAcceptableList() {
        return documentAcceptable;
    }
   
    public void setDocumentAcceptable(int index, String docAcceptable) {
        setElement(this.documentAcceptable,index,(docAcceptable != null) ? docAcceptable.trim() : null);
    }
    
    public String getUnacceptableRemark(int index) {
        return (String)unacceptableRemark.get(index);
    }
    
    public List getUnacceptableRemarkList() {
        return unacceptableRemark;
    }
   
    public void setUnacceptableRemark(int index, String unacceptableRemark) {
        setElement(this.unacceptableRemark,index,unacceptableRemark);
    }
    
    public String getDocumentHashCode(int index) 
    {
        return (String)documentHashCode.get(index);
    }
    
    public List getDocumentHashCodeList() 
    {
        return documentHashCode;
    }

    public void setDocumentHashCode(int index, String hashCode) 
    {
        setElement(this.documentHashCode,index,hashCode);
    }
    
    protected void initialize() {
        super.initialize();
        this.documentId = new ArrayList();
        this.documentReceivedDate = new ArrayList();
        this.documentLogInDate = new ArrayList();
        this.documentLoggedInBy = new ArrayList();
        this.documentAcceptable = new ArrayList();
        this.unacceptableRemark = new ArrayList();
        this.documentHashCode = new ArrayList();
    }
}
