/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.registry.action;

import gov.va.med.fw.util.StringUtils;

/**
 * Action form PH registry edit actions.
 * 
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class RegistryPHInfoForm extends RegistryPHSHADInfoForm {

    private static final long serialVersionUID = 6913871651992744843L;
    
    private String purpleHeartIndicator;
    private String purpleHeartStatus;
    private String statusUpdateDate;
    private String rejectedRemarks;
    private String purpleHeartSiteNumber;
    private String assignedLAS;
    
    public RegistryPHInfoForm() {
        this.initialize();
    }
    
    public String getPurpleHeartIndicator() {
        return purpleHeartIndicator;
    }

    public void setPurpleHeartIndicator(String purpleHeartIndicator) {
        this.purpleHeartIndicator = purpleHeartIndicator;
    }

    public String getPurpleHeartStatus() {
        return purpleHeartStatus;
    }

    public void setPurpleHeartStatus(String purpleHeartStatus) {
        this.purpleHeartStatus = purpleHeartStatus;
    }
    
    public String getStatusUpdateDate() {
        return statusUpdateDate;
    }

    public void setStatusUpdateDate(String statusUpdateDate) {
        this.statusUpdateDate = statusUpdateDate;
    }
    
    public String getRejectedRemarks() {
        return rejectedRemarks;
    }
    
    public void setRejectedRemarks(String rejectedRemarks) {
        this.rejectedRemarks = rejectedRemarks;
    }

    public String getPurpleHeartSiteNumber() {
        return purpleHeartSiteNumber;
    }

    public void setPurpleHeartSiteNumber(String purpleHeartSiteNumber) {
        this.purpleHeartSiteNumber = purpleHeartSiteNumber;
    }
    
    public String getAssignedLAS() {
        return assignedLAS;
    }

    public void setAssignedLAS(String assignedLAS) {
        this.assignedLAS = assignedLAS;
    }

    public void addPHDocument() {
        this.getDocumentIdList().add("");
        this.getDocumentTypeList().add("");
        this.getDataSourceList().add("");
        this.getDocumentReceivedDateList().add("");
        this.getDocumentLogInDateList().add("");
        this.getDocumentLoggedInByList().add("");
        this.getDocumentAcceptableList().add("");
        this.getUnacceptableRemarkList().add("");
        this.getDocumentHashCodeList().add("");
    }
    
    public void addPHDocument(String id, 
                              String documentType,
                              String dataSource,
                              String documentReceivedDate,
                              String documentLogInDate,
                              String documentLoggedInBy,
                              String documentAcceptable,
                              String unacceptableRemark,
                              String hashCode) {
        this.getDocumentIdList().add(id);
        this.getDocumentTypeList().add(documentType);
        this.getDataSourceList().add(dataSource);
        this.getDocumentReceivedDateList().add(documentReceivedDate);
        this.getDocumentLogInDateList().add(documentLogInDate);
        this.getDocumentLoggedInByList().add(documentLoggedInBy);
        this.getDocumentAcceptableList().add(documentAcceptable);
        this.getUnacceptableRemarkList().add(unacceptableRemark);
        this.getDocumentHashCodeList().add(hashCode);
    }
    
    public boolean isPHDocumentEmpty(int documentIndex) {
        if(documentIndex < this.getDocumentIdList().size()) {
            if(StringUtils.isEmpty((String)getDocumentType(documentIndex)) && 
               StringUtils.isEmpty((String)getDataSource(documentIndex)) &&
               StringUtils.isEmpty((String)getDocumentReceivedDate(documentIndex)) &&
               StringUtils.isEmpty((String)getDocumentAcceptable(documentIndex)) && 
               StringUtils.isEmpty((String)getUnacceptableRemark(documentIndex))) {
                return true;
            } 
        }
        return false;
    }

    protected void initialize() {
        super.initialize();
        this.purpleHeartIndicator = null;
        this.purpleHeartStatus = null;
        this.statusUpdateDate = null;
        this.rejectedRemarks = null;
        this.purpleHeartSiteNumber = null;
        this.assignedLAS = null;
    }
}
