/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.registry.action;

// Java classes
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

// Library classes
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

// ESR classes
import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.esr.common.model.registry.RegistryLoadStatistics;
import gov.va.med.esr.ui.ApplicationConstants;
import gov.va.med.esr.ui.common.action.AbstractAction;
import gov.va.med.fw.batchprocess.BatchProcessDetail;
import gov.va.med.fw.batchprocess.BatchProcessInvoker;
import gov.va.med.fw.util.StringUtils;

/**
 * Action class for load registry.
 * 
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class RegistryLoadAction extends AbstractAction implements RegistryConstants {
    
    private static final Map registryLoadJob = new HashMap();
    static {
        registryLoadJob.put(RegistryType.CODE_POW_REGISTRY.getCode(),"scheduledJob.processPrisonerOfWarRegistryFile");
        registryLoadJob.put(RegistryType.CODE_PH_REGISTRY.getCode(),"scheduledJob.processPurpleHeartRegistryFile");
        registryLoadJob.put(RegistryType.CODE_SHAD_REGISTRY.getCode(),"scheduledJob.processSHADRegistryFile");
    }
    
    /**
     * Displays the load registry screen.
     * 
     * @param mapping
     *           Struts action mapping for this action
     * @param actionForm
     *           Struts form bean for this action
     * @param request
     *           The Http Request
     * @param response
     *           The Http Response
     *           
     * @return A struts action forward for where we will go next.
     * @throws Exception
     *            If there are any errors during processing.
     */
    public ActionForward display(ActionMapping mapping, 
                                 ActionForm actionForm,
                                 HttpServletRequest request, 
                                 HttpServletResponse response) throws Exception {
        return mapping.findForward(DISPLAY);
    }
    
    /**
     * Triggers the load registry.
     * 
     * @param mapping
     *           Struts action mapping for this action
     * @param actionForm
     *           Struts form bean for this action
     * @param request
     *           The Http Request
     * @param response
     *           The Http Response
     *           
     * @return A struts action forward for where we will go next.
     * @throws Exception
     *            If there are any errors during processing.
     */
    public ActionForward load(ActionMapping mapping, 
                              ActionForm actionForm,
                              HttpServletRequest request, 
                              HttpServletResponse response) throws Exception {
        
        ActionForward forward = mapping.findForward(DISPLAY);
        RegistrySearchForm form = (RegistrySearchForm)actionForm;
        BatchProcessDetail batchProcessDetail = getBatchProcessDetail(form.getRegistryType());
        if(batchProcessDetail != null) {
            invoker.invokeBatchProcessWithEvent(batchProcessDetail);
            this.addInformationMessage(request,MESSAGE_KEY_REGISTRY_FILE_LOAD_INVOKE_SUCCESS);
            forward = this.displayStatistics(mapping,actionForm,request,response);
        } else {
            this.addActionMessage(request,MESSAGE_KEY_REGISTRY_FILE_LOAD_INVOKE_FAILURE);
        }
        return forward;
    }
    
    /**
     * Display the load registry statistics.
     * 
     * @param mapping
     *           Struts action mapping for this action
     * @param actionForm
     *           Struts form bean for this action
     * @param request
     *           The Http Request
     * @param response
     *           The Http Response
     *           
     * @return A struts action forward for where we will go next.
     * @throws Exception
     *            If there are any errors during processing.
     */
    public ActionForward displayStatisticsScreen(ActionMapping mapping, 
                                                 ActionForm actionForm,
                                                 HttpServletRequest request, 
                                                 HttpServletResponse response) throws Exception {    
        return mapping.findForward(DISPLAY_STATISTICS);
    }
    
    
    /**
     * Display the load registry statistics.
     * 
     * @param mapping
     *           Struts action mapping for this action
     * @param actionForm
     *           Struts form bean for this action
     * @param request
     *           The Http Request
     * @param response
     *           The Http Response
     *           
     * @return A struts action forward for where we will go next.
     * @throws Exception
     *            If there are any errors during processing.
     */
    public ActionForward displayStatistics(ActionMapping mapping, 
                                           ActionForm actionForm,
                                           HttpServletRequest request, 
                                           HttpServletResponse response) throws Exception {    
 
        RegistrySearchForm form = (RegistrySearchForm)actionForm;
        String regType = form.getRegistryType();
        if(StringUtils.isNotEmpty(regType)) {
            RegistryType registryType = (RegistryType)this.getLookupCacheService().getByCodeFromCache(RegistryType.class.getName(),regType);
            RegistryLoadStatistics loadSummary = this.getRegistryService().getMostRecentRegistrySummaryByType(registryType);
            request.setAttribute(LOAD_REGISTRY_SUMMARY,loadSummary);
        } else {
            this.addActionMessage(request,ApplicationConstants.MessageKeys.ERRORS_REQUIRED,REGISTRY_TYPE);
        }
        return mapping.findForward(DISPLAY_STATISTICS);
    }
    
    private BatchProcessDetail getBatchProcessDetail(String registryType) throws Exception {
        String jobName = (String)registryLoadJob.get(registryType);
        return (StringUtils.isNotEmpty(jobName)) ? (BatchProcessDetail)this.getLookupCacheService().getByCodeFromCache(BatchProcessDetail.class.getName(),jobName) : null;   
    }
    
    protected Map getKeyMethodMap() {
        if(keyMethodMap == null) {
            keyMethodMap = new HashMap();
            keyMethodMap.put("button.display","display");
            keyMethodMap.put("button.registry.start","load");
            keyMethodMap.put("button.registry.displayStatisticsScreen","displayStatisticsScreen");
            keyMethodMap.put("button.refresh","displayStatistics");
            keyMethodMap.put("button.cancel","display");
        }
        return keyMethodMap;
    }
    
    public void afterPropertiesSet() {}
    
    BatchProcessInvoker invoker = null;
    
    /**
     * @return Returns the invoker.
     */
    public BatchProcessInvoker getInvoker() {
        return invoker;
    }

    /**
     * @param invoker The invoker to set.
     */
    public void setInvoker(BatchProcessInvoker invoker) {
        this.invoker = invoker;
    }
}
