/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.registry.action;

// Java classes
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

// Library classes
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;

/**
 * Base action form for registry edit.
 * 
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class RegistryInfoForm extends RegistrySearchForm {
    
    private static final long serialVersionUID = 7439499040500727682L;
    
    private String pageName;
    private String registryType;
    private String registryId;
    private String personId;
    
    private List militaryServiceNumbers;
    private String prefix;
    private String middleName;
    private String suffix;
    private String degree;
    
    private List documentType;
    private List dataSource;
    
    private String updatedBy;
    private String updatedDate;

    
    public String getPageName() {
        return pageName;
    }

    public void setPageName(String pageName) {
        this.pageName = pageName;
    }

    public String getRegistryType() {
        return registryType;
    }

    public void setRegistryType(String registryType) {
        this.registryType = registryType;
    }

    public String getRegistryId() {
        return registryId;
    }

    public void setRegistryId(String registryId) {
        this.registryId = registryId;
    }
    
    public String getPersonId() {
        return personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public String getMilitaryServiceNumbers(int index) {
        return (String)militaryServiceNumbers.get(index);
    }
    
    public List getMilitaryServiceNumbersList() {
        return militaryServiceNumbers;
    }
   
    public void setMilitaryServiceNumbers(int index, String militaryServiceNumbers) {
        setElement(this.militaryServiceNumbers,index,militaryServiceNumbers);
    }
    
    public int getMilitaryServiceNumbersCount() {
        return (militaryServiceNumbers != null) ? militaryServiceNumbers.size() : 0;
    }
    
    public void addNewMilitaryServiceNumber() {
        militaryServiceNumbers.add("");
    }
    
    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getDegree() {
        return this.degree;
    }

    public void setDegree(String degree) {
        this.degree = degree;
    }
    
    public String getDocumentType(int index) {
        return (String)documentType.get(index);
    }

    public List getDocumentTypeList() {
        return documentType;
    }
    
    public void setDocumentType(int index, String documentType) {
        setElement(this.documentType,index,documentType);
    }

    public String getDataSource(int index) {
        return (String)dataSource.get(index);
    }

    public List getDataSourceList() {
        return dataSource;
    }
    
    public void setDataSource(int index, String dataSource) {
        setElement(this.dataSource,index,dataSource);
    }
    
    public String getUpdatedBy() {
        return updatedBy;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public String getUpdatedDate() {
        return updatedDate;
    }

    public void setUpdatedDate(String updatedDate) {
        this.updatedDate = updatedDate;
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = super.validate(mapping,request);
        return RegistryValidator.validate(this,request,errors);
    }
    
    protected void initialize() {
        super.initialize();
        this.registryId = null;
        this.personId = null;
        this.militaryServiceNumbers = new ArrayList();
        this.prefix = null;
        this.middleName = null;
        this.suffix = null;
        this.degree = null;
        
        this.documentType = new ArrayList();
        this.dataSource = new ArrayList();
        
        this.updatedBy = null;
        this.updatedDate = null;
    }
}
