/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.registry.action;

// Java classes
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

// Library classes
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

// ESR classes
import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.esr.common.model.registry.Registry;
import gov.va.med.esr.common.model.ee.SHAD;
import gov.va.med.fw.util.StringUtils;

/**
 * Action class for SHAD registry.
 * 
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class RegistryEditSHADAction extends RegistryEditAction {

    /**
     * Displays the SHAD add screen.
     * 
     * @param mapping
     *           Struts action mapping for this action
     * @param actionForm
     *           Struts form bean for this action
     * @param request
     *           The Http Request
     * @param response
     *           The Http Response
     *           
     * @return A struts action forward for where we will go next.
     * @throws Exception
     *            If there are any errors during processing.
     */
    public ActionForward displayAdd(ActionMapping mapping, 
                                    ActionForm actionForm,
                                    HttpServletRequest request, 
                                    HttpServletResponse response) throws Exception {
        RegistrySHADInfoForm form = (RegistrySHADInfoForm)actionForm;
        form.initialize();
        form.setRegistryType(RegistryType.CODE_SHAD_REGISTRY.getName());
        if(form.getMilitaryServiceNumbersCount() == 0) form.addNewMilitaryServiceNumber();
        if(form.getDocumentCount() == 0) form.addSHADDocument();
        return mapping.findForward(DISPLAY_ADD);
    }
    
    /**
     * Adds SHAD registry.
     * 
     * @param mapping
     *           Struts action mapping for this action
     * @param actionForm
     *           Struts form bean for this action
     * @param request
     *           The Http Request
     * @param response
     *           The Http Response
     *           
     * @return A struts action forward for where we will go next.
     * @throws Exception
     *            If there are any errors during processing.
     */
    public ActionForward add(ActionMapping mapping, 
                             ActionForm actionForm,
                             HttpServletRequest request, 
                             HttpServletResponse response) throws Exception {
        
        RegistrySHADInfoForm form  = (RegistrySHADInfoForm)actionForm;
        SHAD shad = new SHAD();
        this.getConversionService().convert(form,shad);
        this.getRegistryService().updateRegistry(shad);
        return mapping.findForward(DISPLAY_SEARCH_WITH_ADDED_MESSAGE);
    }
    
    /**
     * Displays the SHAD update screen.
     * 
     * @param mapping
     *           Struts action mapping for this action
     * @param actionForm
     *           Struts form bean for this action
     * @param request
     *           The Http Request
     * @param response
     *           The Http Response
     *           
     * @return A struts action forward for where we will go next.
     * @throws Exception
     *            If there are any errors during processing.
     */
    public ActionForward displayUpdate(ActionMapping mapping, 
                                       ActionForm actionForm,
                                       HttpServletRequest request, 
                                       HttpServletResponse response) throws Exception {
        RegistrySHADInfoForm form = (RegistrySHADInfoForm)actionForm;
        form.initialize();
        String registryId = request.getParameter(REGISTRY_ID);
        Registry registry = (StringUtils.isNotEmpty(registryId)) ? this.getRegistry(request,registryId,RegistryType.CODE_SHAD_REGISTRY.getName()) : null;
        return prepareDisplayUpdate(mapping,actionForm,request,response,registry);
    }

    /**
     * Updates SHAD registry.
     * 
     * @param mapping
     *           Struts action mapping for this action
     * @param actionForm
     *           Struts form bean for this action
     * @param request
     *           The Http Request
     * @param response
     *           The Http Response
     *           
     * @return A struts action forward for where we will go next.
     * @throws Exception
     *            If there are any errors during processing.
     */
    public ActionForward update(ActionMapping mapping, 
                                ActionForm actionForm,
                                HttpServletRequest request, 
                                HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward(DISPLAY_SEARCH_WITH_UPDATED_MESSAGE);
        RegistrySHADInfoForm form  = (RegistrySHADInfoForm)actionForm;
        String registryId = request.getParameter(REGISTRY_ID);
        Registry registry = (StringUtils.isNotEmpty(registryId)) ? this.getRegistryFromCache(request,registryId,RegistryType.CODE_SHAD_REGISTRY.getName()) : null; 
        if(registry == null) registry = getRegistry(request,registryId,RegistryType.CODE_SHAD_REGISTRY.getName());
        if(registry != null) {
            Registry registryUpdated = (Registry)registry.clone();
            this.getConversionService().convert(form,registryUpdated);
            this.getRegistryService().updateRegistry(registryUpdated);
        }
        this.removeRegistryFromCache(request);
        return forward;
    }
    
    /**
     * Adds an empty(new) Document.
     * 
     * @param mapping
     *           Struts action mapping for this action
     * @param actionForm
     *           Struts form bean for this action
     * @param request
     *           The Http Request
     * @param response
     *           The Http Response
     *           
     * @return A struts action forward for where we will go next.
     * @throws Exception
     *            If there are any errors during processing.
     */
    public ActionForward addDocument(ActionMapping mapping, 
                                     ActionForm actionForm,
                                     HttpServletRequest request, 
                                     HttpServletResponse response) throws Exception {
        RegistrySHADInfoForm form  = (RegistrySHADInfoForm)actionForm;
        form.addSHADDocument();
        return mapping.findForward(DISPLAY_UPDATE); 
    }
}
