/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.registry.action;

/**
 * Registry constants interface.
 * 
 * @author Muddaiah Ranga
 * @version 3.0
 */
public interface RegistryConstants {

    public static final String REGISTRY = "rgistry";
    public static final String REGISTRY_TYPE = "registryType";
    public static final String REGISTRY_TYPE_LIST = "rgistryTypeList";
    public static final String LOAD_REGISTRY_SUMMARY = "loadRegistrySummary";

    public static final String PAGE_NAME = "pageName";

    public static final String PAGE_NAME_ADD_PH_REGISTRY = "addPHRegistry";
    public static final String PAGE_NAME_UPDATE_PH_REGISTRY = "updatePHRegistry";
    
    public static final String PAGE_NAME_ADD_POW_REGISTRY = "addPOWRegistry";
    public static final String PAGE_NAME_UPDATE_POW_REGISTRY = "updatePOWRegistry";
    
    public static final String PAGE_NAME_ADD_SHAD_REGISTRY = "addSHADRegistry";
    public static final String PAGE_NAME_UPDATE_SHAD_REGISTRY = "updateSHADRegistry";
    
    public static final String DISPLAY = "display";
    public static final String DISPLAY_STATISTICS = "displayStatistics";
    public static final String DISPLAY_ADD = "displayAdd";
    public static final String DISPLAY_UPDATE = "displayUpdate";
    public static final String DISPLAY_SEARCH = "displaySearch";
    public static final String DISPLAY_SEARCH_WITH_ADDED_MESSAGE = "displaySearchWithAddedMessage";
    public static final String DISPLAY_SEARCH_WITH_UPDATED_MESSAGE = "displaySearchWithUpdatedMessage";
    public static final String DISPLAY_SEARCH_WITH_REGISTRY_NOT_FOUND_MESSAGE = "displaySearchWithRegistryNotFoundMessage";
    
    public static final String MESSAGE_KEY_REGISTRY_FILE_LOAD_INVOKE_SUCCESS = "message.registry.batchProcess.invoked.success";
    public static final String MESSAGE_KEY_REGISTRY_FILE_LOAD_INVOKE_FAILURE = "message.registry.batchProcess.invoked.failure";
    
    public static final String REGISTRY_SEARCH_RESULT = "REGISTRY_SEARCH_RESULT";
    
    public static final String PERSON_ID= "personId";
    public static final String REGISTRY_ID= "registryId";
    
    public static final String LABEL_PH_INDICATOR = "label.ph.indicator"; 
    public static final String LABEL_POW_INDICATOR = "label.pow.indicator";
    public static final String LABEL_SHAD_INDICATOR = "label.shad.indicator";
    
    public static final String LABEL_REGISTRY_DOCUMENT_TYPE = "label.registry.documentType";
    public static final String LABEL_REGISTRY_DATA_SOURCE = "label.registry.dataSource";
    public static final String LABEL_REGISTRY_DOCUMENT_RECEIVED_DATE = "label.registry.documentReceivedDate";
    public static final String LABEL_REGISTRY_DOCUMENT_LOGIN_DATE = "label.registry.documentLogInDate";
    public static final String LABEL_REGISTRY_DOCUMENT_LOGGEDIN_BY = "label.registry.documentLoggedInBy";
    public static final String LABEL_REGISTRY_DOCUMENT_ACCEPTABLE = "label.registry.documentAcceptable";
    public static final String LABEL_REGISTRY_DOCUMENT_UNACCEPTABLE_REMARK = "label.registry.unacceptableRemark"; 
    
    public static final String LABEL_POW_DATA_SOURCE = "label.pow.Source";
    public static final String LABEL_POW_CAPTURE_DATE = "label.pow.captureDate";
    public static final String LABEL_POW_RELEASE_DATE = "label.pow.releaseDate";
    public static final String LABEL_POW_CONFINEMENT_LOCATION = "label.pow.confinementLocation";
    public static final String LABEL_DATES_INVALID = "errors.dates.invalid";
    public static final String LABEL_DATE_ENTERED = "label.pow.dateEntered";
   
    public static final String VALUE_LIST = "vlhlist";
    public static final String REGISTRY_SEARCH_TABLE_ID = "registrySearchTableId";
    public static final String REGISTRY_SEARCH_ADAPTER = "registrySearchAdapter";
    
    public static final String ERROR_REGISTRY_NOT_FOUND = "errors.registryNotFound";
    public static final String ERROR_DATE_NO_FUTURE = "errors.validateDateFuture";
    
    public static final String ERROR_UNACCEPTABLE_REMARK_INVALID_LENGTH = "errors.invalidUnacceptableRemarkLength";
 
}
