// Package 
package gov.va.med.esr.ui.person.beans;

import gov.va.med.esr.ui.person.action.MergeConstants;
import gov.va.med.fw.util.StringUtils;

/**
 * Meta data UI Row Information for the Person Merge screens.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class PersonMergeRowInfoMeta implements PersonMergeRowInfoMetaData
{
    // The name for the item being selected.
    // This value will be persisted as the in-progress selection name.
    // Value of this selection will be "D" or "P" for deprecated and/or primary selection.
    // (e.g. demographics_personal_dateOfDeath)
    private String fieldName = null;

    // The bean property to get this field
    private String fieldProperty = null;

    // A Class.Method that can optionally be used to get the necessary data if the fieldProperty
    // isn't flexible enough to get the property that is needed.  The method that is invoked will
    // get passed the source object (or the object that is retrieved using the fieldProperty
    // attribute if it is specified) as well as this PersonMergeRowInfoMetaData object for
    // reference.
    private String fieldPropertyHelperMethod = null;

    // CSS style for the field (e.g. indent20)
    private String fieldStyle = null;

    // CSS style for the data (e.g. indent20)
    private String dataStyle = null;

    // Resource bundle message key for left column label (e.g. label.person.dateOfDeath)
    private String fieldMessageKey = null;

    // Resource bundle message key for left column label of child groups (e.g. label.person.dateOfDeath)
    private String groupFieldMessageKey = null;

    // If true, a radio button or check box will be generated.  If false, item is not selectable.
    private boolean selectable = false;

    // If true, item will be a radio button.  If false, item will be a check box.
    private boolean singleSelect = true;

    // If true, this row item is the parent of a list of children row items.
    private boolean parentRow = false;

    // A flag that determines whether differences in values should be highlighted.
    private boolean highlightDifferences = true;

    // A flag that determines whether the field data will be obtained and displayed.
    private boolean displayField = true;

    //Customr merge method to be called when this element is selected
    private String mergeMethodName = null;

    //Property to be copied/merged when this is selected
    private String mergeProperty = null;

    /**
     * Default constructor.
     */
    public PersonMergeRowInfoMeta()
    {
    }

    public String getFieldStyle()
    {
        return fieldStyle;
    }

    public void setFieldStyle(String fieldStyle)
    {
        this.fieldStyle = fieldStyle;
    }

    public String getDataStyle()
    {
        return dataStyle;
    }

    public void setDataStyle(String dataStyle)
    {
        this.dataStyle = dataStyle;
    }

    public String getFieldMessageKey()
    {
        return fieldMessageKey;
    }

    public void setFieldMessageKey(String fieldMessageKey)
    {
        this.fieldMessageKey = fieldMessageKey;
    }

    public String getGroupFieldMessageKey()
    {
        return groupFieldMessageKey;
    }

    public void setGroupFieldMessageKey(String groupFieldMessageKey)
    {
        this.groupFieldMessageKey = groupFieldMessageKey;
    }

    public boolean isSelectable()
    {
        return selectable;
    }

    public void setSelectable(boolean selectable)
    {
        this.selectable = selectable;
    }

    public boolean isSingleSelect()
    {
        return singleSelect;
    }

    public void setSingleSelect(boolean singleSelect)
    {
        this.singleSelect = singleSelect;
    }

    public String getFieldName()
    {
        return fieldName;
    }

    public void setFieldName(String fieldName)
    {
        this.fieldName = fieldName;
    }

    public String getFieldProperty()
    {
        return fieldProperty;
    }

    public void setFieldProperty(String fieldProperty)
    {
        this.fieldProperty = fieldProperty;
    }

    public boolean isParentRow()
    {
        return parentRow;
    }

    public void setParentRow(boolean parentRow)
    {
        this.parentRow = parentRow;
    }

    public boolean getHighlightDifferences()
    {
        return highlightDifferences;
    }

    public void setHighlightDifferences(boolean highlightDifferences)
    {
        this.highlightDifferences = highlightDifferences;
    }

    public boolean getDisplayField()
    {
        return displayField;
    }

    public void setDisplayField(boolean displayField)
    {
        this.displayField = displayField;
    }

    public String getMergeMethodName() {
        return mergeMethodName;
    }

    public void setMergeMethodName(String mergeMethodName) {
        this.mergeMethodName = mergeMethodName;
    }

    public String getMergeProperty() {
        return mergeProperty;
    }

    public void setMergeProperty(String mergeProperty) {
        this.mergeProperty = mergeProperty;
    }

    public String getFieldPropertyHelperMethod()
    {
        return fieldPropertyHelperMethod;
    }

    public void setFieldPropertyHelperMethod(String fieldPropertyHelperMethod)
    {
        this.fieldPropertyHelperMethod = fieldPropertyHelperMethod;
    }

    /**
     * Returns the field name prefix.  The field name prefix is the first part of the field
     * name before the first underscore character.  For example, demographics_lastUpdated would
     * return demograhpics.  If the field name is empty, null is returned.
     *
     * @return The field name prefix.
     */
    public String getFieldNamePrefix()
    {
        if (StringUtils.isEmpty(fieldName))
        {
            return null;
        }

        String[] tokens = fieldName.split(MergeConstants.UNDERSCORE);
        return tokens[0];
    }
}
