// Package 
package gov.va.med.esr.ui.person.action;

// Java Classes
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

// Library Classes
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMessage;
import net.mlw.vlh.ValueList;

// Framework Classes
import gov.va.med.fw.ui.struts.ValueListActionUtils;
import gov.va.med.fw.ui.valuelist.SelectableResult;

// ESR Classes
import gov.va.med.esr.ui.common.action.AbstractAction;
import gov.va.med.esr.common.model.person.PersonUnmergeInfo;

/**
 * This struts action is used to support the Person Unmerge Worklist page.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class PersonUnmergeWorklistAction extends AbstractAction
{
    // Struts forwards
    public static final String FORWARD_DISPLAY = "display";

    // Valuelist Constants
    public static final String PERSON_UNMERGE_WORKLIST_TABLE_ID = "personUnmergeWorklistSearchTableId";
    public static final String PERSON_UNMERGE_WORKLIST_SEARCH_ADAPTER = "personUnmergeWorklistSearchAdapter";
    public static final String PERSON_UNMERGE_WORKLIST_VALUELIST_REQUEST_KEY = "vlhlist";

    // Message Keys
    public static final String MESSAGE_NO_ITEMS_SELECTED = "message.person.noItemsSelected";
    public static final String MESSAGE_PERSON_SUCCESSFUL_REMOVAL = "message.person.successfulRemoval";

    /**
     * Default constructor.
     */
    public PersonUnmergeWorklistAction()
    {
        super();
    }

    /**
     * @see org.springframework.beans.factory.InitializingBean#afterPropertiesSet()
     */
    public void afterPropertiesSet()
    {
    }

    /**
     * Displays the main page.
     *
     * @param mapping Struts action mapping for this action
     * @param form Struts form bean for this action
     * @param request The Http Request
     * @param response The Http Response
     *
     * @return A struts action forward for where we will go next.
     * @throws Exception If there are any errors during processing.
     */
    public ActionForward display(ActionMapping mapping, ActionForm form,
        HttpServletRequest request, HttpServletResponse response) throws Exception
    {
        // Get the value list information
        ValueList valueList = ValueListActionUtils.getValueList(form,
            request, PERSON_UNMERGE_WORKLIST_TABLE_ID, PERSON_UNMERGE_WORKLIST_SEARCH_ADAPTER);

        // Backup the ValueListInfo into session and store the resultant ValueList on the request
        ValueListActionUtils
            .setValueList(request, valueList, PERSON_UNMERGE_WORKLIST_VALUELIST_REQUEST_KEY);

        // Return to the display
        return mapping.findForward(FORWARD_DISPLAY);
    }

    /**
     * Removes the selected items from the unmerge worklist.
     *
     * @param mapping Struts action mapping for this action
     * @param form Struts form bean for this action
     * @param request The Http Request
     * @param response The Http Response
     *
     * @return A struts action forward for where we will go next.
     * @throws Exception If there are any errors during processing.
     */
    public ActionForward removeFromWorklist(ActionMapping mapping, ActionForm form,
        HttpServletRequest request, HttpServletResponse response) throws Exception
    {
        // Get the value list information
        ValueList valueList = ValueListActionUtils.getSelectableResultValuleList(form,
            request, PERSON_UNMERGE_WORKLIST_TABLE_ID, PERSON_UNMERGE_WORKLIST_SEARCH_ADAPTER, null);

        // Backup the ValueListInfo into session and store the resultant ValueList on the request
        ValueListActionUtils
            .setValueList(request, valueList, PERSON_UNMERGE_WORKLIST_VALUELIST_REQUEST_KEY);

        // Get selectedResults from Session instead of from ValueList  which only contains a subset
        // of items.
        List selectedResults = ValueListActionUtils.getSelectableResultsFromSession(
                    request, PERSON_UNMERGE_WORKLIST_TABLE_ID, new Boolean(true));

        // Check if the user selected any items
        if ((selectedResults == null) || (selectedResults.size() == 0))
        {
            // No items were selected so display an error message and forward back to the screen.
            addActionMessage(request, new ActionMessage(MESSAGE_NO_ITEMS_SELECTED));
            return mapping.findForward(FORWARD_DISPLAY);
        }

        // Process each selected item
        for (Iterator iterator = selectedResults.iterator(); iterator.hasNext();)
        {
            SelectableResult selectableResult = (SelectableResult)iterator.next();
            PersonUnmergeInfo personUnmergeInfo =
                (PersonUnmergeInfo)selectableResult.getResult();
            getPersonUnmergeService().deletePersonUnmergeInfo(personUnmergeInfo);
        }

        // All items were successfully processed so display an appropriate message
        addInformationMessage(request, new ActionMessage(MESSAGE_PERSON_SUCCESSFUL_REMOVAL));

        // Redisplay the screen
        return display(mapping, form, request, response);
    }

    /**
     * Initialize and get the Struts lookup dispatch method map hashmap.
     *
     * @return the method map
     * @see org.apache.struts.actions.LookupDispatchAction#getKeyMethodMap()
     */
    protected Map getKeyMethodMap()
    {
        Map map = new HashMap();
        map.put("button.display", "display");
        map.put("button.refresh", "display");
        map.put("button.person.removeFromWorklist", "removeFromWorklist");
        return map;
    }
}
