/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.person.action;

import gov.va.med.esr.common.model.ee.FeeBasis;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;

import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.EntityKeyFactory;

import java.util.List;

import org.apache.commons.lang.Validate;

/**
 * @author Muddaiah Ranga
 * @version 1.0
 */
public class FacilityFeeBasis extends AbstractKeyedEntity {

    private static final long serialVersionUID = 4753240143251819922L;

    private VAFacility facility;
    private List patientVisitSummary;
    private List feeBasis;
    EntityKey personKey;

    public FacilityFeeBasis(VAFacility facility, EntityKey personKey) {
        Validate.notNull(facility,"VAFacility cannot be null");
        this.facility = facility;
        this.personKey = personKey;
    }
    /**
     * Define the key as concatenated string of facility id and person id
     */
    public EntityKey getEntityKey() {
        return EntityKeyFactory.createEntityKey("" + facility.getIdentifier() + personKey.getKeyValueAsString(),
                VAFacility.class);
    }

    public VAFacility getFacility() {
        return facility;
    }

    public List getPatientVisitSummary() {
        return patientVisitSummary;
    }

    public void setPatientVisitSummary(List patientVisitSummary) {
        this.patientVisitSummary = patientVisitSummary;
    }

    public List getFeeBasis() {
        return feeBasis;
    }

    public void setFeeBasis(List feeBasis) {
        this.feeBasis = feeBasis;
    }
}
