/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.militaryservice.action;

import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.lookup.FilipinoVeteranProof;
import gov.va.med.esr.common.model.lookup.ServicePeriod;
import gov.va.med.esr.common.model.lookup.VAFacility;

import java.util.List;

/**
 * Wrapper for MilitaryServiceSiteRecord. It provides sorteced list of MilitaryServiceEpisode and
 * ConflictExperiences.
 * 
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class MilitaryServiceSiteRecordWraper 
{
    private MilitaryServiceSiteRecord militaryServiceSiteRecord;
    //private List serviceEpisodeList;
    //private List conflictExperienceList;
    
    public MilitaryServiceSiteRecordWraper(MilitaryServiceSiteRecord siteRecord)
    {
        militaryServiceSiteRecord = siteRecord;
    }
    
    public VAFacility getSite() 
    {
        return militaryServiceSiteRecord.getSite();
    }
    
    public ServicePeriod getServicePeriod()
    {
        return militaryServiceSiteRecord.getServicePeriod();
    }
    
    public FilipinoVeteranProof getFilipinoVeteranProof()
    {
        return militaryServiceSiteRecord.getFilipinoVeteranProof();
    }
    
    public List getMilitaryServiceEpisodes()
    {
        //if(serviceEpisodeList != null) return serviceEpisodeList;
        return MilitaryServiceActionHelper.sortMilitaryServiceEpisodes(militaryServiceSiteRecord.getMilitaryServiceEpisodes());
    }
    
    public List getConflictExperiences()
    {
        //if(conflictExperienceList != null) return conflictExperienceList;
        return MilitaryServiceActionHelper.sortConflictExperiences(militaryServiceSiteRecord.getConflictExperiences());
    }
}
