/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.militaryservice.action;

//Java classes
import gov.va.med.esr.common.model.ee.CombatEpisode;
import gov.va.med.esr.common.model.lookup.OEFOIFSource;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.fw.ui.struts.AbstractForm;
import gov.va.med.fw.util.StringUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionMapping;

import gov.va.med.esr.common.model.lookup.MHDataSource;

/**
 * Action form for military service.
 *
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class MilitaryServiceInfoForm extends AbstractForm
{
    private static final long serialVersionUID = 2399633755462124933L;

    private String ssn;
    private String birthDate;
    private String dischargeDueToDisability;
    private String retirementDueToMilitaryDisability;
    private String agentOrangeExposureLocation;
    private String radiationExposureMethod;
    private String exposedToContaminants;
    private String filipinoVeteranProof;
    private String periodOfService;
    private String shad;
    private String eligibilityEndDate;

    private String eligibleForClassIIDental;
    private String classIIDentalApplicationDueBefore;

    //New fields for Combat Services
    private List combatServiceId;
    private List combatServiceLocation;
    private List combatPayStartDate;
    private List combatPayEndDate;
    private List combatServiceSource;

    private List oefOifCombatEpisodeId;
    private List oefOifCombatEpisodeStartDate;
    private List oefOifCombatEpisodeEndDate;
    private List oefOifCombatEpisodeLocation;
    private List oefOifCombatSource;
    private List oefOifCombatPayType;
    private List oefOifCombatEpisodeHashCode;

    private List serviceEpisodeId;
    private List serviceEpisodeMilitaryServiceNumber;
    private List serviceEpisodeSameAsSSN;
    private List serviceEpisodeBranchOfService;
    private List serviceEpisodeEntryDate;
    private List serviceEpisodeSeparationDate;
    private List serviceEpisodeDischargeType;
    private List serviceEpisodeServiceComponent;
    private List serviceEpisodeHashCode;

    private List conflictEpisodeId;
    private List conflictEpisodeStartDate;
    private List conflictEpisodeEndDate;
    private List conflictEpisodeLocation;
    private List conflictEpisodeHashCode;


    // Upon hitting the delete button for the episodes by the user, the
    // attribute will be populated with the episode List index to be deleted.
    private String deletedEpisodeIndex;

    //MSDS
    //private String medalOfHonor;
    private String msdsBrokerService;

    // display only
    private String mhLastEditDate; // not used in ESR 3.6
    private String mhLastStatusUpdateDate;  //status update date
    private String status;  // decoration status

    // editable fields
    private String mohHiddenId;  // not used in ESR 3.6
    private String mohInd;
    private String onFileMohInd;

    private String documentType;
    private String onFileDocumentType;

    private String documentReceiptDate;
    private String onFileDocumentReceiptDate;

    private String dataSource;
    private String onFileMohDataSource;

    private Integer addedOEFOIFCombatEpisode;
    private Integer addedMilitaryServiceEpisode;
	private Integer addedConflictEpisode;
	////////////CLV///////////////////////
	private String campLejeuneInd;
	private String campLejeuneVerificationMethod;
	private String campLejeuneVerificationComments;
	private String campLejeuneChangeDate;
	private String campLejeuneChangeSite;
	private String campLejeuneChangeSource;
	private boolean campLejeuneDisabled;
	private String[] testCLV = {};
	private String[] campLejeuneVerificationMethods = {};
	///////////CLV///////////////////////

	public Integer getAddedOEFOIFCombatEpisode() {
		return addedOEFOIFCombatEpisode;
	}

	public void setAddedOEFOIFCombatEpisode(Integer addedOEFOIFCombatEpisode) {
		this.addedOEFOIFCombatEpisode = addedOEFOIFCombatEpisode;
	}

    public Integer getAddedMilitaryServiceEpisode() {
		return addedMilitaryServiceEpisode;
	}

	public void setAddedMilitaryServiceEpisode(Integer addedMilitaryServiceEpisode) {
		this.addedMilitaryServiceEpisode = addedMilitaryServiceEpisode;
	}
	public Integer getAddedConflictEpisode() {
		return addedConflictEpisode;
	}

	public void setAddedConflictEpisode(Integer addedConflictEpisode) {
		this.addedConflictEpisode = addedConflictEpisode;
	}

    public String getMhLastEditDate() {
		return mhLastEditDate;
	}

	public void setMhLastEditDate(String mhLastEditDate) {
		this.mhLastEditDate = mhLastEditDate;
	}

	public String getMhLastStatusUpdateDate() {
		return mhLastStatusUpdateDate;
	}

	public void setMhLastStatusUpdateDate(String mhLastStatusUpdateDate) {
		this.mhLastStatusUpdateDate = mhLastStatusUpdateDate;
	}

	public MilitaryServiceInfoForm()
    {
        initialize();
    }

    public void reset(ActionMapping mapping, HttpServletRequest request)
    {
        super.reset(mapping, request);
        initialize();
    }

    public String getBirthDate()
    {
        return birthDate;
    }

    public void setBirthDate(String birthDate)
    {
        this.birthDate = birthDate;
    }

    public String getSsn()
    {
        return ssn;
    }

    public void setSsn(String ssn)
    {
        this.ssn = ssn;
    }

    public String getDischargeDueToDisability()
    {
        return dischargeDueToDisability;
    }

    public void setDischargeDueToDisability(String dischargeDueToDisability)
    {
        this.dischargeDueToDisability = dischargeDueToDisability;
    }

    public String getRetirementDueToMilitaryDisability()
    {
        return retirementDueToMilitaryDisability;
    }

    public void setRetirementDueToMilitaryDisability(String retirementDueToMilitaryDisability)
    {
        this.retirementDueToMilitaryDisability = retirementDueToMilitaryDisability;
    }

    public String getAgentOrangeExposureLocation()
    {
        return agentOrangeExposureLocation;
    }

    public void setAgentOrangeExposureLocation(String agentOrangeExposureLocation)
    {
        this.agentOrangeExposureLocation = agentOrangeExposureLocation;
    }

    public String getRadiationExposureMethod()
    {
        return radiationExposureMethod;
    }

    public void setRadiationExposureMethod(String radiationExposureMethod)
    {
        this.radiationExposureMethod = radiationExposureMethod;
    }

    public String getExposedToContaminants()
    {
        return exposedToContaminants;
    }

    public void setExposedToContaminants(String exposedToContaminants)
    {
        this.exposedToContaminants = exposedToContaminants;
    }

    public String getFilipinoVeteranProof()
    {
        return filipinoVeteranProof;
    }

    public void setFilipinoVeteranProof(String filipinoVeteranProof)
    {
        this.filipinoVeteranProof = filipinoVeteranProof;
    }

    public String getPeriodOfService()
    {
        return periodOfService;
    }

    public void setPeriodOfService(String periodOfService)
    {
        this.periodOfService = periodOfService;
    }

    public String getEligibilityEndDate()
    {
        return eligibilityEndDate;
    }

    public void setEligibilityEndDate(String eligibilityEndDate)
    {
        this.eligibilityEndDate = eligibilityEndDate;
    }

    public String getShad()
    {
        return shad;
    }

    public void setShad(String shad)
    {
        this.shad = shad;
    }

    public String getEligibleForClassIIDental()
    {
    	return eligibleForClassIIDental;
    }

    public void setEligibleForClassIIDental(String eligibleForClassIIDental)
    {
    	this.eligibleForClassIIDental = eligibleForClassIIDental;
    }

    public String getClassIIDentalApplicationDueBefore()
    {
    	return classIIDentalApplicationDueBefore;
    }

    public void setClassIIDentalApplicationDueBefore(String classIIDentalApplicationDueBefore)
    {
    	this.classIIDentalApplicationDueBefore = classIIDentalApplicationDueBefore;
    }


    //*************************** Combat Episode Getter/Setters ***************************************//

    public void addNewCombatService()
    {
        combatServiceId.add("");
        combatPayStartDate.add("");
        combatPayEndDate.add("");
        combatServiceLocation.add("");
        combatServiceSource.add("");

    }

    public void addCombatService(String serviceId,
                                 String payStartDate,
                                 String payEndDate,
                                 String serviceLocation,
                                 String serviceSource)
    {
        combatServiceId.add(serviceId);
        combatPayStartDate.add(payStartDate);
        combatPayEndDate.add(payEndDate);
        combatServiceLocation.add(serviceLocation);
        combatServiceSource.add(serviceSource);
    }

    public String getCombatServiceId(int index)
    {
        return (String)combatServiceId.get(index);
    }

    public List getCombatServiceIdList()
    {
        //TODO: Remove this code after real implementation
        if(combatServiceId.isEmpty()) {
            this.addNewCombatService();
        }
        return combatServiceId;
    }

    public void setCombatServiceId(int index, String id)
    {
        setElement(this.combatServiceId,index,id);
    }

    public String getCombatPayStartDate(int index)
    {
        return (String)combatPayStartDate.get(index);
    }

    public List getCombatPayStartDateList()
    {
        return combatPayStartDate;
    }

    public void setCombatPayStartDate(int index,String payStartDate)
    {
        setElement(this.combatPayStartDate,index,payStartDate);
    }

    public String getCombatPayEndDate(int index)
    {
        return (String)combatPayEndDate.get(index);
    }

    public List getCombatPayEndDateList()
    {
        return combatPayEndDate;
    }

    public void setCombatPayEndDate(int index,String payEndDate)
    {
        setElement(this.combatPayEndDate,index,payEndDate);
    }

    public String getCombatServiceLocation(int index)
    {
        return (String)combatServiceLocation.get(index);
    }

    public List getCombatServiceLocationList()
    {
        return combatServiceLocation;
    }

    public void setCombatServiceLocation(int index,String serviceLocation)
    {
        setElement(this.combatServiceLocation,index,serviceLocation);
    }

    public String getCombatServiceSource(int index)
    {
        return (String)combatServiceSource.get(index);
    }

    public List getCombatServiceSourceList()
    {
        return combatServiceSource;
    }

    public void setCombatServiceSource(int index,String serviceSource)
    {
        setElement(this.combatServiceSource,index,serviceSource);
    }

    //*************************** Combat Episode Getter/Setters ***************************************//

    public void addNewOefOifCombatEpisode()
    {
        oefOifCombatEpisodeId.add("");
        oefOifCombatEpisodeStartDate.add("");
        oefOifCombatEpisodeEndDate.add("");
        oefOifCombatEpisodeLocation.add("");
        oefOifCombatPayType.add("");
        oefOifCombatSource.add(OEFOIFSource.CODE_CENTRALIZED_ELIGIBILITY_VERIFICATION.getCode());
        oefOifCombatEpisodeHashCode.add("");
    }

    public void addOefOifCombatEpisode(String id,
                                   String startDate,
                                   String endDate,
                                   String location,
                                   String source,
                                   String payType,
                                   String hashCode)
    {
        oefOifCombatEpisodeId.add(id);
        oefOifCombatEpisodeStartDate.add(startDate);
        oefOifCombatEpisodeEndDate.add(endDate);
        oefOifCombatEpisodeLocation.add(location);
        oefOifCombatPayType.add(payType);
        oefOifCombatSource.add(source);
        oefOifCombatEpisodeHashCode.add(hashCode);

    }

    public void removeOefOifCombatEpisode(int index)
    {

        oefOifCombatEpisodeId.remove(index);
        oefOifCombatEpisodeStartDate.remove(index);
        oefOifCombatEpisodeEndDate.remove(index);
        oefOifCombatEpisodeLocation.remove(index);
        oefOifCombatPayType.remove(index);
        oefOifCombatSource.remove(index);

    }

    public boolean isOefOifCombatEpisodeEmpty(int oefOifEpisodeIndex)
    {
        if(oefOifEpisodeIndex < oefOifCombatEpisodeId.size())
        {
            String startDate = (String)oefOifCombatEpisodeStartDate.get(oefOifEpisodeIndex);
            String endDate = (String)oefOifCombatEpisodeEndDate.get(oefOifEpisodeIndex);
            String location = (String)oefOifCombatEpisodeLocation.get(oefOifEpisodeIndex);

            if(StringUtils.isEmpty(startDate) && StringUtils.isEmpty(endDate) && StringUtils.isEmpty(location))
            {
                return true;
            }
        }
        return false;
    }

    public String getOefOifCombatEpisodeId(int index)
    {
        return (String)oefOifCombatEpisodeId.get(index);
    }

    public List getOefOifCombatEpisodeIdList()
    {
        return oefOifCombatEpisodeId;
    }

    public void setOefOifCombatEpisodeId(int index, String id)
    {
        setElement(this.oefOifCombatEpisodeId,index,id);
    }

    public String getOefOifCombatEpisodeStartDate(int index)
    {
        return (String)oefOifCombatEpisodeStartDate.get(index);
    }

    public List getOefOifCombatEpisodeStartDateList()
    {
        return oefOifCombatEpisodeStartDate;
    }

    public void setOefOifCombatEpisodeStartDate(int index, String startDate)
    {
        setElement(this.oefOifCombatEpisodeStartDate,index,startDate);
    }

    public String getOefOifCombatEpisodeEndDate(int index)
    {
        return (String)oefOifCombatEpisodeEndDate.get(index);
    }

    public List getOefOifCombatEpisodeEndDateList()
    {
        return oefOifCombatEpisodeEndDate;
    }

    public void setOefOifCombatEpisodeEndDate(int index, String endDate)
    {
        setElement(this.oefOifCombatEpisodeEndDate,index,endDate);
    }

    public String getOefOifCombatEpisodeLocation(int index)
    {
        return (String)oefOifCombatEpisodeLocation.get(index);
    }

    public List getOefOifCombatEpisodeLocationList()
    {
        return oefOifCombatEpisodeLocation;
    }

    public void setOefOifCombatEpisodeLocation(int index,String location)
    {
        setElement(this.oefOifCombatEpisodeLocation,index,location);
    }



    public String getOefOifCombatSource(int index)
    {
        return (String)oefOifCombatSource.get(index);
    }

    public List getOefOifCombatSourceList()
    {
        return oefOifCombatSource;
    }

    public void setOefOifCombatSource(int index,String oefoifSource)
    {
        setElement(this.oefOifCombatSource,index,oefoifSource);
    }

    public String getOefOifCombatPayType(int index)
    {
        return (String)oefOifCombatPayType.get(index);
    }

    public List getOefOifCombatPayTypeList()
    {
        return oefOifCombatPayType;
    }

    public void setOefOifCombatPayType(int index,String payType)
    {
        setElement(this.oefOifCombatPayType,index,payType);
    }

    public String getOefOifCombatEpisodeHashCode(int index)
    {
        return (String)oefOifCombatEpisodeHashCode.get(index);
    }

    public List getOefOifCombatEpisodeHashCodeList()
    {
        return oefOifCombatEpisodeHashCode;
    }

    public void setOefOifCombatEpisodeHashCode(int index, String hashCode)
    {
        setElement(this.oefOifCombatEpisodeHashCode,index,hashCode);
    }


    //*************************** Service Episode Getter/Setters ***************************************//

    public void addNewServiceEpisode()
    {
        serviceEpisodeId.add("");
        serviceEpisodeMilitaryServiceNumber.add("");
        serviceEpisodeSameAsSSN.add("");
        serviceEpisodeBranchOfService.add("");
        serviceEpisodeEntryDate.add("");
        serviceEpisodeSeparationDate.add("");
        serviceEpisodeDischargeType.add("");
        serviceEpisodeServiceComponent.add("");
        serviceEpisodeHashCode.add("");
    }

    public void addServiceEpisode(String id,
            					  String militaryServiceNumber,
            					  String sameAsSSN,
            					  String branchOfService,
            					  String entryDate,
            					  String separationDate,
            					  String dischargeType,
                                  String serviceComponent,
            					  String hashCode)
    {
        serviceEpisodeId.add(id);
        serviceEpisodeMilitaryServiceNumber.add(militaryServiceNumber);
        serviceEpisodeSameAsSSN.add(sameAsSSN);
        serviceEpisodeBranchOfService.add(branchOfService);
        serviceEpisodeEntryDate.add(entryDate);
        serviceEpisodeSeparationDate.add(separationDate);
        serviceEpisodeDischargeType.add(dischargeType);
        serviceEpisodeServiceComponent.add(serviceComponent);
        serviceEpisodeHashCode.add(hashCode);
    }

    public void removeServiceEpisode(int index)
    {
        serviceEpisodeId.remove(index);
        serviceEpisodeMilitaryServiceNumber.remove(index);
        serviceEpisodeBranchOfService.remove(index);
        serviceEpisodeEntryDate.remove(index);
        serviceEpisodeSeparationDate.remove(index);
        serviceEpisodeDischargeType.remove(index);
        serviceEpisodeServiceComponent.remove(index);
    }

    public boolean isServiceEpisodeEmpty(int serviceEpisodeIndex)
    {
        if(serviceEpisodeIndex < serviceEpisodeId.size())
        {
            String militaryServiceNumber = (String)serviceEpisodeMilitaryServiceNumber.get(serviceEpisodeIndex);

            String branchOfService = (String)serviceEpisodeBranchOfService.get(serviceEpisodeIndex);
            String entryDate = (String)serviceEpisodeEntryDate.get(serviceEpisodeIndex);
            String separationDate = (String)serviceEpisodeSeparationDate.get(serviceEpisodeIndex);
            String dischargeType = (String)serviceEpisodeDischargeType.get(serviceEpisodeIndex);
            String serviceComponent = (String)serviceEpisodeServiceComponent.get(serviceEpisodeIndex);

            if(StringUtils.isEmpty(militaryServiceNumber) && StringUtils.isEmpty(branchOfService) &&
               StringUtils.isEmpty(entryDate) && StringUtils.isEmpty(separationDate) &&
               StringUtils.isEmpty(dischargeType) && StringUtils.isEmpty(serviceComponent))
            {
                return true;
            }
        }
        return false;
    }

    public String getServiceEpisodeId(int index)
    {
        return (String)serviceEpisodeId.get(index);
    }

    public List getServiceEpisodeIdList()
    {
        return serviceEpisodeId;
    }

    public String getServiceEpisodeIdListSize() //13882
    {
        return Integer.toString(serviceEpisodeId.size());
    }

    public void setServiceEpisodeId(int index, String id)
    {
        setElement(this.serviceEpisodeId,index,id);
    }

    public String getServiceEpisodeMilitaryServiceNumber(int index)
    {
        return (String)serviceEpisodeMilitaryServiceNumber.get(index);
    }

    public List getServiceEpisodeMilitaryServiceNumberList()
    {
        return serviceEpisodeMilitaryServiceNumber;
    }

    public void setServiceEpisodeMilitaryServiceNumber(int index, String militaryServiceNumber)
    {
        setElement(this.serviceEpisodeMilitaryServiceNumber,index,militaryServiceNumber);
    }

    public String getServiceEpisodeSameAsSSN(int index)
    {
        return (String)serviceEpisodeSameAsSSN.get(index);
    }

    public List getServiceEpisodeSameAsSSNList()
    {
        return serviceEpisodeSameAsSSN;
    }

    public void setServiceEpisodeSameAsSSN(int index, String sameAsSSN)
    {
        setElement(this.serviceEpisodeSameAsSSN,index,sameAsSSN);
    }

    public String getServiceEpisodeBranchOfService(int index)
    {
        return (String)serviceEpisodeBranchOfService.get(index);
    }

    public List getServiceEpisodeBranchOfServiceList()
    {
        return serviceEpisodeBranchOfService;
    }

    public void setServiceEpisodeBranchOfService(int index, String branchOfService)
    {
        setElement(this.serviceEpisodeBranchOfService,index,branchOfService);
    }

    public String getServiceEpisodeEntryDate(int index)
    {
        return (String)serviceEpisodeEntryDate.get(index);
    }

    public List getServiceEpisodeEntryDateList()
    {
        return serviceEpisodeEntryDate;
    }

    public void setServiceEpisodeEntryDate(int index, String entryDate)
    {
        setElement(this.serviceEpisodeEntryDate,index,entryDate);
    }

    public String getServiceEpisodeSeparationDate(int index)
    {
        return (String)serviceEpisodeSeparationDate.get(index);
    }

    public List getServiceEpisodeSeparationDateList()
    {
        return serviceEpisodeSeparationDate;
    }

    public void setServiceEpisodeSeparationDate(int index, String separationDate)
    {
        setElement(this.serviceEpisodeSeparationDate,index,separationDate);
    }

    public String getServiceEpisodeDischargeType(int index)
    {
        return (String)serviceEpisodeDischargeType.get(index);
    }

    public List getServiceEpisodeDischargeTypeList()
    {
        return serviceEpisodeDischargeType;
    }

    public void setServiceEpisodeDischargeType(int index, String dischargeType)
    {
        setElement(this.serviceEpisodeDischargeType,index,dischargeType);
    }

    public String getServiceEpisodeServiceComponent(int index)
    {
        return (String)serviceEpisodeServiceComponent.get(index);
    }

    public List getServiceEpisodeServiceComponentList()
    {
        return serviceEpisodeServiceComponent;
    }

    public void setServiceEpisodeServiceComponent(int index, String serviceComponent)
    {
        setElement(this.serviceEpisodeServiceComponent,index,serviceComponent);
    }

    public String getServiceEpisodeHashCode(int index)
    {
        return (String)serviceEpisodeHashCode.get(index);
    }

    public List getServiceEpisodeHashCodeList()
    {
        return serviceEpisodeHashCode;
    }

    public void setServiceEpisodeHashCode(int index, String hashCode)
    {
        setElement(this.serviceEpisodeHashCode,index,hashCode);
    }



    //*************************** Conflict Episode Getter/Setters ***************************************//

    public void addNewConflictEpisode()
    {
        conflictEpisodeId.add("");
        conflictEpisodeStartDate.add("");
        conflictEpisodeEndDate.add("");
        conflictEpisodeLocation.add("");
        conflictEpisodeHashCode.add("");
    }

    public void addConflictEpisode(String id,
            					   String startDate,
            					   String endDate,
            					   String location,
            					   String hashCode)
    {
        conflictEpisodeId.add(id);
        conflictEpisodeStartDate.add(startDate);
        conflictEpisodeEndDate.add(endDate);
        conflictEpisodeLocation.add(location);
        conflictEpisodeHashCode.add(hashCode);
    }

    public void removeConflictEpisode(int index)
    {
        conflictEpisodeId.remove(index);
        conflictEpisodeStartDate.remove(index);
        conflictEpisodeEndDate.remove(index);
        conflictEpisodeLocation.remove(index);
    }

    public boolean isConflictEpisodeEmpty(int conflictEpisodeIndex)
    {
        if(conflictEpisodeIndex < conflictEpisodeId.size())
        {
            String startDate = (String)conflictEpisodeStartDate.get(conflictEpisodeIndex);
            String endDate = (String)conflictEpisodeEndDate.get(conflictEpisodeIndex);
            String location = (String)conflictEpisodeLocation.get(conflictEpisodeIndex);

            if(StringUtils.isEmpty(startDate) && StringUtils.isEmpty(endDate) && StringUtils.isEmpty(location))
            {
                return true;
            }
        }
        return false;
    }

    public String getConflictEpisodeId(int index)
    {
        return (String)conflictEpisodeId.get(index);
    }

    public List getConflictEpisodeIdList()
    {
        return conflictEpisodeId;
    }

    public void setConflictEpisodeId(int index, String id)
    {
        setElement(this.conflictEpisodeId,index,id);
    }

    public String getConflictEpisodeStartDate(int index)
    {
        return (String)conflictEpisodeStartDate.get(index);
    }

    public List getConflictEpisodeStartDateList()
    {
        return conflictEpisodeStartDate;
    }

    public void setConflictEpisodeStartDate(int index, String startDate)
    {
        setElement(this.conflictEpisodeStartDate,index,startDate);
    }

    public String getConflictEpisodeEndDate(int index)
    {
        return (String)conflictEpisodeEndDate.get(index);
    }

    public List getConflictEpisodeEndDateList()
    {
        return conflictEpisodeEndDate;
    }

    public void setConflictEpisodeEndDate(int index, String endDate)
    {
        setElement(this.conflictEpisodeEndDate,index,endDate);
    }

    public String getConflictEpisodeLocation(int index)
    {
        return (String)conflictEpisodeLocation.get(index);
    }

    public List getConflictEpisodeLocationList()
    {
        return conflictEpisodeLocation;
    }

    public void setConflictEpisodeLocation(int index,String location)
    {
        setElement(this.conflictEpisodeLocation,index,location);
    }

    public String getConflictEpisodeHashCode(int index)
    {
        return (String)conflictEpisodeHashCode.get(index);
    }

    public List getConflictEpisodeHashCodeList()
    {
        return conflictEpisodeHashCode;
    }

    public void setConflictEpisodeHashCode(int index, String hashCode)
    {
        setElement(this.conflictEpisodeHashCode,index,hashCode);
    }

    public String getDeletedEpisodeIndex() {
        return deletedEpisodeIndex;
    }

    public void setDeletedEpisodeIndex(String deletedEpisodeIndex) {
        // System.out.println("deletedEpisodeIndex=" + deletedEpisodeIndex);
        this.deletedEpisodeIndex = deletedEpisodeIndex;
    }

    public boolean isOefOifCombatEpisodeChanged(int index, CombatEpisode combatEpisode)
    {
        if(combatEpisode == null) return true;

        String combatLoc = StringUtils.isNotEmpty(this.getOefOifCombatEpisodeLocation(index)) ? this.getOefOifCombatEpisodeLocation(index) : "";
        String payType = StringUtils.isNotEmpty(this.getOefOifCombatPayType(index)) ? this.getOefOifCombatPayType(index) : "";

        if(!StringUtils.equals(this.getOefOifCombatEpisodeStartDate(index),DateUtils.format(combatEpisode.getStartDate(),DateUtils.MMDDYYYY)) ||
           !StringUtils.equals(this.getOefOifCombatEpisodeEndDate(index),DateUtils.format(combatEpisode.getEndDate(),DateUtils.MMDDYYYY)) ||
           !StringUtils.equals(combatLoc,((combatEpisode.getConflictLocation() != null) ? combatEpisode.getConflictLocation().getCode() : "")) ||
           !StringUtils.equals(payType,((combatEpisode.getCombatPayType() != null) ? combatEpisode.getCombatPayType().getCode() : "")) )
        {
            return true;
        }
        return false;
    }

    public static Boolean getBoolean1(String value)
    {
        if(StringUtils.equalsIgnoreCase(value,"Y"))
        {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    //MSDS

    public String getDataSource() {
		return dataSource;
	}

	public void setDataSource(String dataSource) {
		this.dataSource = dataSource;
	}

    //Private Methods.

    private void initialize()
    {
        ssn = "";
        dischargeDueToDisability = "";
        retirementDueToMilitaryDisability = "";
        agentOrangeExposureLocation = "";
        radiationExposureMethod = "";
        exposedToContaminants = "";
        periodOfService ="";
        shad = "";
        eligibleForClassIIDental = "";
        classIIDentalApplicationDueBefore = "";

        combatServiceId = new ArrayList();
        combatPayStartDate = new ArrayList();
        combatPayEndDate = new ArrayList();
        combatServiceLocation = new ArrayList();
        combatServiceSource = new ArrayList();

        oefOifCombatEpisodeId = new ArrayList();
        oefOifCombatEpisodeStartDate = new ArrayList();
        oefOifCombatEpisodeEndDate = new ArrayList();
        oefOifCombatEpisodeLocation = new ArrayList();
        oefOifCombatPayType = new ArrayList();
        oefOifCombatSource = new ArrayList();
        oefOifCombatEpisodeHashCode = new ArrayList();

        serviceEpisodeId = new ArrayList();
        serviceEpisodeMilitaryServiceNumber = new ArrayList();
        serviceEpisodeSameAsSSN = new ArrayList();
        serviceEpisodeBranchOfService = new ArrayList();
        serviceEpisodeEntryDate = new ArrayList();
        serviceEpisodeSeparationDate = new ArrayList();
        serviceEpisodeDischargeType = new ArrayList();
        serviceEpisodeServiceComponent = new ArrayList();
        serviceEpisodeHashCode = new ArrayList();

        conflictEpisodeId = new ArrayList();
        conflictEpisodeStartDate = new ArrayList();
        conflictEpisodeEndDate = new ArrayList();
        conflictEpisodeLocation = new ArrayList();
        conflictEpisodeHashCode = new ArrayList();
        ////////////////////CLV////////////////////////
    	 campLejeuneInd = "";
    	 //campLejeuneVerificationMethod = "";
    	campLejeuneVerificationComments = "";
        campLejeuneChangeDate = "";
    	campLejeuneChangeSite = "";
    	campLejeuneChangeSource = "";
    	campLejeuneDisabled = true;
    	this.testCLV=new String[0];
        /////////////////////CLV///////////////////////

    }

	public String getMsdsBrokerService() {
		return msdsBrokerService;
	}

	public void setMsdsBrokerService(String msdsBrokerService) {
		this.msdsBrokerService = msdsBrokerService;
	}

	public String getMohHiddenId() {
		return mohHiddenId;
	}

	public void setMohHiddenId(String mohHiddenId) {
		this.mohHiddenId = mohHiddenId;
	}

	public String getMohInd() {
		return mohInd;
	}

	public void setMohInd(String mohInd) {
		this.mohInd = mohInd;
	}

	public String getDocumentReceiptDate() {
		return documentReceiptDate;
	}

	public void setDocumentReceiptDate(String documentReceiptDate) {
		this.documentReceiptDate = documentReceiptDate;
	}

	public String getDocumentType() {
		return documentType;
	}

	public void setDocumentType(String documentType) {
		this.documentType = documentType;
	}

	public String getOnFileDocumentReceiptDate() {
		return onFileDocumentReceiptDate;
	}

	public void setOnFileDocumentReceiptDate(String onFileDocumentReceiptDate) {
		this.onFileDocumentReceiptDate = onFileDocumentReceiptDate;
	}

	public String getOnFileDocumentType() {
		return onFileDocumentType;
	}

	public void setOnFileDocumentType(String onFileDocumentType) {
		this.onFileDocumentType = onFileDocumentType;
	}

	public String getOnFileMohDataSource() {
		return onFileMohDataSource;
	}

	public void setOnFileMohDataSource(String onFileMohDataSource) {
		this.onFileMohDataSource = onFileMohDataSource;
	}

	public String getOnFileMohInd() {
		return onFileMohInd;
	}

	public void setOnFileMohInd(String onFileMohInd) {
		this.onFileMohInd = onFileMohInd;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getCampLejeuneInd() {
		return campLejeuneInd;
	}

	public void setCampLejeuneInd(String campLejeuneInd) {
		this.campLejeuneInd = campLejeuneInd;
	}

    public String[] getCampLejeuneVerificationMethods()
    {
        return campLejeuneVerificationMethods;
    }

    public void setCampLejeuneVerificationMethods(String[] campLejeuneVerificationMethods)
    {
        this.campLejeuneVerificationMethods = campLejeuneVerificationMethods;
    }

	public String getCampLejeuneVerificationMethod() {
		return campLejeuneVerificationMethod;
	}

	public void setCampLejeuneVerificationMethod(
			String campLejeuneVerificationMethod) {
		this.campLejeuneVerificationMethod = campLejeuneVerificationMethod;
	}

	public String getCampLejeuneVerificationComments() {
		return campLejeuneVerificationComments;
	}

	public void setCampLejeuneVerificationComments(
			String campLejeuneVerificationComments) {
		this.campLejeuneVerificationComments = campLejeuneVerificationComments;
	}

	public String getCampLejeuneChangeDate() {
		return campLejeuneChangeDate;
	}

	public void setCampLejeuneChangeDate(String campLejeuneChangeDate) {
		this.campLejeuneChangeDate = campLejeuneChangeDate;
	}

	public String getCampLejeuneChangeSite() {
		return campLejeuneChangeSite;
	}

	public void setCampLejeuneChangeSite(String campLejeuneChangeSite) {
		this.campLejeuneChangeSite = campLejeuneChangeSite;
	}

	public String getCampLejeuneChangeSource() {
		return campLejeuneChangeSource;
	}

	public void setCampLejeuneChangeSource(String campLejeuneChangeSource) {
		this.campLejeuneChangeSource = campLejeuneChangeSource;
	}

	public boolean isCampLejeuneDisabled() {
		return campLejeuneDisabled;
	}

	public void setCampLejeuneDisabled(boolean campLejeuneDisabled) {
		this.campLejeuneDisabled = campLejeuneDisabled;
	}

	public String[] getTestCLV() {
		return testCLV;
	}

	public void setTestCLV(String[] testCLV) {
		this.testCLV = testCLV;
	}

}