/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.militaryservice.action;

import gov.va.med.esr.ui.ApplicationConstants;

/**
 * Constants for military service.
 *
 * @author Muddaiah Ranga
 * @version 3.0
 */
public interface MilitaryServiceConstants extends ApplicationConstants
{
    public final static String FORWARD_DISPLAY 							= "display";
    public final static String MESSAGE_MILITARY_SERVICE_UPDATED			= "message.militaryService.updated";
    public final static String MESSAGE_REVIEW_CALCULATED_PERIOD_OF_SERVICE = "message.reviewCalulatedPeriodOfService";
    public static final String FORWARD_SEND_BROKER_QUERY_MESSAGE 		= "sendMsdsQueryMessage";
    public static final String FORWARD_SENT_SUCCESSFULLY 				= "message.sent.successfully";
    public static final String BACK_TO_ORIGINATOR 						= "return";
    public static final String MILITARY_SERVICE_SITE_RECORD_LIST 		= "militaryServiceSiteRecordList";

    public static final String ERROR_FORWARD_SENT_FAILED 				= "errors.message.sent.failed";
    public static final String ERROR_DATE_AFTER_BIRTH_DATE_PLUS_15 		= "errors.date.afterBirthDatePlus15";
    public static final String ERROR_DATE_PRIOR_DATE 					= "errors.date.priorDate";
    public static final String ERROR_DATE_NO_FUTURE	 					= "errors.noFutureDate";
    public static final String ERROR_DATE_MUST_BE_PRECISE               = "errors.mustBePrecise";

    public final static String LABEL_DISCHARGE_DUE_TO_DISABILITY 		= "label.dischargeDueToDisablility";
    public final static String LABEL_MILITARY_DISABILITY_RETIRMENT 		= "label.militaryDisabilityRetirement";
    public final static String LABEL_AGENT_ORANGE_LOCATION 				= "label.agentOrangeLocation";
    public final static String LABEL_RADIATION_EXPOSURE_METHOD			= "label.radiationExposureMethod";
    public final static String LABEL_ENVIRONMENT_CONTAMINANTS			= "label.environmentalContaminants";
    public final static String LABEL_FILIPINO_VETERAN_PROOF				= "label.filipinoVeteranProof";
    public final static String LABEL_HEC_PERIOD_OF_SERVICE				= "label.hecPeriodOfService";
    public final static String LABEL_SHAD								= "label.SHAD";
    public final static String LABEL_CAMPLEJEUNE						= "label.CampLejeune";

    public final static String LABEL_MILITARY_SERVICE_NUMBER 			= "label.militaryServiceNumber";
    public final static String LABEL_BRANCH_OF_SERVICE 					= "label.branchOfService";
    public final static String LABEL_SERVICE_ENTERY_DATE 				= "label.serviceEntryDate";
    public final static String LABEL_SERVICE_SEPARATION_DATE 			= "label.serviceSeperationDate";
    public final static String LABEL_PERIOD_OF_SERVICE 					= "label.periodOfService";
    public final static String LABEL_DISCHARGE_TYPE 					= "label.dischargeType";
    public final static String LABEL_SERVICE_COMPONENT 					= "label.serviceComponent";

    public final static String LABEL_CONFLICT_START_DATE				= "label.conflictStartDate";
    public final static String LABEL_CONFLICT_END_DATE 					= "label.conflictEndDate";
    public final static String LABEL_CONFLICT_LOCATION					= "label.conflictservicelocation";

    public final static String LABEL_MOH_DOCUMENT_RECEIPT_DATE			= "label.documentReceiptDate";
    public final static String LABEL_MOH_DOCUMENT_TYPE				    = "label.documentType";
    public final static String LABEL_MOH_DOCUMENT_SOURCE                = "label.dataSource";
    public final static String IS_CAMP_LEJEUNE_ELIGIBLE					= "clveligible"; //CLV///
    public final static String LABEL_CLV_CHANGE_DATE                    = "label.clvChangeDate";
    public final static String LABEL_CLV_COMMENTS                       = "label.clvComments";

}
