/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.militaryservice.action;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.ee.CombatEpisode;
import gov.va.med.esr.common.model.ee.CombatService;
import gov.va.med.esr.common.model.ee.ConflictExperience;
import gov.va.med.esr.common.model.ee.MilitaryServiceEpisode;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.fw.model.AbstractKeyedEntity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Helper class for military service action.
 * 
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class MilitaryServiceActionHelper 
{
 	public static List sortMilitaryServiceSiteRecords(Set siteRecords)
 	{
 	    List siteRecordList = new ArrayList();
 	    if(siteRecords != null)
 	    {
 	        for(Iterator iter=siteRecords.iterator(); iter.hasNext();)
 	        {
 	           MilitaryServiceSiteRecord msSiteRecord = (MilitaryServiceSiteRecord)iter.next();
 	           
 	           // If there are no MSEs or CEs, donot display.
 	           if(msSiteRecord != null && 
 	             (msSiteRecord.getMilitaryServiceEpisodes().size() > 0 || 
 	              msSiteRecord.getConflictExperiences().size() > 0))
 	           {
 	               siteRecordList.add(new MilitaryServiceSiteRecordWraper(msSiteRecord));
 	           }
 	        }
 	    }
 	    if(siteRecordList != null && !siteRecordList.isEmpty())
 	    {
 	        Comparator comparator = new Comparator()
           	{
 	            public int compare(Object pObject1, Object pObject2)
 	            {
 	                if((pObject1 != null && pObject1 instanceof MilitaryServiceSiteRecordWraper) && 
                       (pObject2 != null && pObject2 instanceof MilitaryServiceSiteRecordWraper) )
 	                {
 	                    VAFacility vaFacility1 = ((MilitaryServiceSiteRecordWraper)pObject1).getSite();
 	                    VAFacility vaFacility2 = ((MilitaryServiceSiteRecordWraper)pObject2).getSite();
                   
 	                    if((vaFacility1 != null && vaFacility1.getName() != null) && (vaFacility2 != null && vaFacility2.getName()!= null))
 	                    {
 	                        return (vaFacility1.getName().compareTo(vaFacility2.getName()));
 	                    }
 	                }
 	                return 0;
 	            }
           	};
           	Collections.sort(siteRecordList,comparator);
 	    }
 	    return siteRecordList;
 	}
 	
    public static List sortCombatServices(Set combatServices)
    {
        if(combatServices == null) return null;
        List combatServiceList = new ArrayList(combatServices);
        if(!combatServiceList.isEmpty())
        {
            Comparator comparator = new Comparator()
            {
                public int compare(Object pObject1, Object pObject2)
                {
                    ImpreciseDate startDate1 = (pObject1 != null && pObject1 instanceof CombatService) ? ((CombatService)pObject1).getPayStartDate() : null;
                    ImpreciseDate startDate2 = (pObject2 != null && pObject2 instanceof CombatService) ? ((CombatService)pObject2).getPayStartDate() : null;
                    if(startDate1 != null && startDate2 != null)
                    {
                        return (startDate1.compareTo(startDate2));
                    }
                    return 0;
                }
            };
            Collections.sort(combatServiceList,comparator);
        }
        return combatServiceList;
    }
    
    public static List sortCombatEpisodes(Set combatEpisodes)
    {
        if(combatEpisodes == null) return null;
        List combatEpisodeList = new ArrayList(combatEpisodes);
        if(!combatEpisodeList.isEmpty())
        {
            Comparator comparator = new Comparator()
            {
                public int compare(Object pObject1, Object pObject2)
                {
                    ImpreciseDate startDate1 = (pObject1 != null && pObject1 instanceof CombatEpisode) ? ((CombatEpisode)pObject1).getStartDate() : null;
                    ImpreciseDate startDate2 = (pObject2 != null && pObject2 instanceof CombatEpisode) ? ((CombatEpisode)pObject2).getStartDate() : null;
                    if(startDate1 != null && startDate2 != null)
                    {
                        return (startDate1.compareTo(startDate2));
                    }
                    return 0;
                }
            };
            Collections.sort(combatEpisodeList,comparator);
        }
        return combatEpisodeList;
    }
    
    public static List sortMilitaryServiceEpisodes(Set serviceEpisodes)
    {
        if(serviceEpisodes == null) return null;
        
        List serviceEpisodeList = new ArrayList(serviceEpisodes);
        if(!serviceEpisodeList.isEmpty())
        {
            Comparator comparator = new Comparator()
            {
                public int compare(Object pObject1, Object pObject2)
                {
                    ImpreciseDate startImDate1 = (pObject1 != null && pObject1 instanceof MilitaryServiceEpisode) ? ((MilitaryServiceEpisode)pObject1).getStartDate() : null;
                    ImpreciseDate startImDate2 = (pObject2 != null && pObject2 instanceof MilitaryServiceEpisode) ? ((MilitaryServiceEpisode)pObject2).getStartDate() : null;
                    if(startImDate1 != null && startImDate2 != null)
                    {
                        return (startImDate1.compareTo(startImDate2));
                    }
                    return 0;
                }
            };
            Collections.sort(serviceEpisodeList,comparator);
        }
        return serviceEpisodeList;
    }
    
    public static List sortConflictExperiences(Set conflictExperiences)
    {
        if(conflictExperiences == null) return null;
        List conflictExperienceList = new ArrayList(conflictExperiences);
        if(!conflictExperienceList.isEmpty())
        {
            Comparator comparator = new Comparator()
            {
                public int compare(Object pObject1, Object pObject2)
                {
                    ImpreciseDate startDate1 = (pObject1 != null && pObject1 instanceof ConflictExperience) ? ((ConflictExperience)pObject1).getStartDate() : null;
                    ImpreciseDate startDate2 = (pObject2 != null && pObject2 instanceof ConflictExperience) ? ((ConflictExperience)pObject2).getStartDate() : null;
                    if(startDate1 != null && startDate2 != null)
                    {
                        return (startDate1.compareTo(startDate2));
                    }
                    return 0;
                }
            };
            Collections.sort(conflictExperienceList,comparator);
        }
        return conflictExperienceList;
    }

    public static Map getMapFromCollection(Set set) 
    {
        Map map = new HashMap();
        if(set != null)
        {
           AbstractKeyedEntity keyedEntity = null;
           for(Iterator iter = set.iterator(); iter.hasNext();)
           {
              keyedEntity = (AbstractKeyedEntity)iter.next();
              if (keyedEntity!=null && keyedEntity.getEntityKey()!=null)
            	  map.put(keyedEntity.getEntityKey().getKeyValueAsString(),keyedEntity);
           }
        }
        return map;
    }
}
