/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.militaryservice.action;

import gov.va.med.esr.common.model.ee.CampLejeuneVerification;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.lookup.OEFOIFSource;
import gov.va.med.esr.common.model.lookup.ServiceBranch;
import gov.va.med.esr.common.model.lookup.ServicePeriod;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.ui.conversion.UIConversionService;
import gov.va.med.esr.ui.ee.action.EligibilityAction;
import gov.va.med.esr.ui.util.SessionManager;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.esr.service.MessagingService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Date;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;

/**
 * Action handler for military service.
 *
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class MilitaryServiceAction extends EligibilityAction implements MilitaryServiceConstants
{
    public MilitaryServiceAction()
    {
        super();
    }

    public void afterPropertiesSet() throws Exception
    {
    }

    /**
    * Displays a Military Service page.
    *
    * @param mapping An action mapping
    * @param actionForm A form bean
    * @param request A http request from an search.jsp page
    * @param response A http response to stream data to a next page
    * @return An action forward class encapsulating information about a next page
    * @throws java.lang.Exception Thrown if failed to process
    */
    public ActionForward display(ActionMapping mapping,
         						ActionForm actionForm,
         						HttpServletRequest request,
         						HttpServletResponse response)
    throws Exception
    {
        MilitaryServiceInfoForm militaryServiceForm = (MilitaryServiceInfoForm)actionForm;
        militaryServiceForm.reset(mapping,request);
        militaryServiceForm.setMsdsBrokerService(super.getSystemParameterService().getMSDSServiceIndicator().toString());

        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        militaryServiceForm.setAddAPerson(isAddAPerson);

        Person person = getSelectedPerson(request);
        SessionManager.setAttribute(request,MILITARY_SERVICE_SITE_RECORD_LIST,null);

        UIConversionService uiConversionService = (UIConversionService)conversionService;
        uiConversionService.convert(person,militaryServiceForm);
        /////////////////////////////////CLV//////////////////////////////////////////////////
        militaryServiceForm.setCampLejeuneDisabled(!getMilitaryInfoService().calculateCLVeligibilitybyMSE(person));
        ////////////////////////////OR///////////////////////////////////////////////////////////
        SessionManager.setAttribute(request,IS_CAMP_LEJEUNE_ELIGIBLE,getMilitaryInfoService().calculateCLVeligibilitybyMSE(person));
        ////////////////////////////////CLV///////////////////////////////////////////////////
        MilitaryService militaryService = person.getMilitaryService();
        if (militaryService != null) {
	        Set set = militaryService.getMilitaryServiceSiteRecords();
	        List siteRecords = MilitaryServiceActionHelper.sortMilitaryServiceSiteRecords(set);
	        SessionManager.setAttribute(request,MILITARY_SERVICE_SITE_RECORD_LIST,siteRecords);
        }
        return mapping.findForward(FORWARD_DISPLAY);
    }

    /**
     * Displays a Military Service page.
     *
     * @param mapping An action mapping
     * @param actionForm A form bean
     * @param request A http request from an search.jsp page
     * @param response A http response to stream data to a next page
     * @return An action forward class encapsulating information about a next page
     * @throws java.lang.Exception Thrown if failed to process
     */
    public ActionForward updateMilitaryService(ActionMapping mapping,
		  	   								   ActionForm actionForm,
		  	   								   HttpServletRequest request,
		  	   								   HttpServletResponse response)
    throws Exception
    {
        MilitaryServiceInfoForm militaryServiceForm = (MilitaryServiceInfoForm)actionForm;

        Person person = getSelectedPerson(request);
        Person updatedPerson = (Person)person.clone();

        conversionService.convert(militaryServiceForm,updatedPerson);

        boolean isAddAPerson = false;
        isAddAPerson = SessionManager.isAddAPerson(request);
        militaryServiceForm.setAddAPerson(isAddAPerson);
        if (! isAddAPerson)
        	updatedPerson = getMilitaryInfoService().updateMilitaryServiceInformation(updatedPerson);
        updateSelectedPerson(request,updatedPerson);
        addInformationMessage(request,MESSAGE_MILITARY_SERVICE_UPDATED);
        militaryServiceForm.setMsdsBrokerService(super.getSystemParameterService().getMSDSServiceIndicator().toString());

        return display(mapping,actionForm,request,response);
    }

	protected ActionForward handleOptimisticLockException(
			ActionMapping mapping, ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		form.reset(mapping,request);
		return display(mapping,form,request,response);
	}
    /**
     * Calculates the period of service.
     *
     * @param mapping An action mapping
     * @param actionForm A form bean
     * @param request A http request from an search.jsp page
     * @param response A http response to stream data to a next page
     * @return An action forward class encapsulating information about a next page
     * @throws java.lang.Exception Thrown if failed to process
     */
    public ActionForward calculatePeriodOfService(ActionMapping mapping,
		  	   								   	  ActionForm actionForm,
		  	   								   	  HttpServletRequest request,
		  	   								   	  HttpServletResponse response)
    throws Exception
    {
        MilitaryServiceInfoForm militaryServiceForm = (MilitaryServiceInfoForm)actionForm;

        Person person = getSelectedPerson(request);
        Person updatedPerson = (Person)person.clone();

        conversionService.convert(militaryServiceForm,updatedPerson);

        //Remove the existing Period Of Service
        MilitaryServiceSiteRecord hecUpdatedSite = updatedPerson.getMilitaryService().getHECMilitaryServiceSiteRecord();
        if(hecUpdatedSite != null) hecUpdatedSite.setServicePeriod(null);

        updatedPerson = getMilitaryInfoService().updateCalculatePeriodOfService(updatedPerson);

        MilitaryService militaryService = updatedPerson.getMilitaryService();

        //Update the military service form with the calculated Period Of Service
        MilitaryServiceSiteRecord hecSite = militaryService.getHECMilitaryServiceSiteRecord();
        ServicePeriod servicePeriod = (hecSite != null) ? hecSite.getServicePeriod() : null;
        if(servicePeriod != null) {
            militaryServiceForm.setPeriodOfService(servicePeriod.getCode());
        } else {
            militaryServiceForm.setPeriodOfService("");
        }
        addInformationMessage(request,MESSAGE_REVIEW_CALCULATED_PERIOD_OF_SERVICE);//??
        militaryServiceForm.setMsdsBrokerService(super.getSystemParameterService().getMSDSServiceIndicator().toString());
        /////////////////////////////////CLV//////////////////////////////////////////////////
        militaryServiceForm.setCampLejeuneDisabled(!getMilitaryInfoService().calculateCLVeligibilitybyMSE(person));

        /////////////13894//////////////////////////////////////

        if(person != null)
 		{
        	CampLejeuneVerification clv = (CampLejeuneVerification)person.getSpecialFactorByType(CampLejeuneVerification.class);
        	if(getMilitaryInfoService().calculateCLVeligibilitybyMSE(person)==false)
        		militaryServiceForm.setCampLejeuneInd((clv != null && clv.getSpecialFactorIndicator() != null) ? clv.getSpecialFactorIndicator().getCode() : "");
 		}
        ////////////13894//////////////////////////////////////

        return mapping.findForward(FORWARD_DISPLAY);
    }

    /**
     * Adds an empty Oef/Oif combat episode record..
     *
     * @param mapping An action mapping
     * @param actionForm A form bean
     * @param request A http request from an search.jsp page
     * @param response A http response to stream data to a next page
     * @return An action forward class encapsulating information about a next page
     * @throws java.lang.Exception Thrown if failed to process
     */
    public ActionForward addOefOifCombatEpisode(ActionMapping mapping,
                                                ActionForm actionForm,
                                                HttpServletRequest request,
                                                HttpServletResponse response)
    throws Exception
    {

    	MilitaryServiceInfoForm militaryServiceForm = (MilitaryServiceInfoForm)actionForm;
    	militaryServiceForm.addNewOefOifCombatEpisode();
        militaryServiceForm.setMsdsBrokerService(super.getSystemParameterService().getMSDSServiceIndicator().toString());
        militaryServiceForm.setAddedOEFOIFCombatEpisode(militaryServiceForm.getOefOifCombatEpisodeIdList().size() - 1 );
        /////////////////////////////////CLV//////////////////////////////////////////////////
        Person person = getSelectedPerson(request);
        militaryServiceForm.setCampLejeuneDisabled(!getMilitaryInfoService().calculateCLVeligibilitybyMSE(person));
        /////////////13894//////////////////////////////////////

        if(person != null)
 		{
        	CampLejeuneVerification clv = (CampLejeuneVerification)person.getSpecialFactorByType(CampLejeuneVerification.class);
        	if(getMilitaryInfoService().calculateCLVeligibilitybyMSE(person)==false)
        		militaryServiceForm.setCampLejeuneInd((clv != null && clv.getSpecialFactorIndicator() != null) ? clv.getSpecialFactorIndicator().getCode() : "");
 		}
        ////////////13894//////////////////////////////////////

        return mapping.findForward(FORWARD_DISPLAY);
    }

    /**
     * Adds an empty military service episode record.
     *
     * @param mapping An action mapping
     * @param actionForm A form bean
     * @param request A http request from an search.jsp page
     * @param response A http response to stream data to a next page
     * @return An action forward class encapsulating information about a next page
     * @throws java.lang.Exception Thrown if failed to process
     */
    public ActionForward addMilitaryServiceEpisode(ActionMapping mapping,
					   							   ActionForm actionForm,
					   							   HttpServletRequest request,
					   							   HttpServletResponse response)
    throws Exception
    {
        MilitaryServiceInfoForm militaryServiceForm = (MilitaryServiceInfoForm)actionForm;
        militaryServiceForm.addNewServiceEpisode();
        militaryServiceForm.setMsdsBrokerService(super.getSystemParameterService().getMSDSServiceIndicator().toString());
        militaryServiceForm.setAddedMilitaryServiceEpisode(militaryServiceForm.getServiceEpisodeIdList().size() - 1 );
        /////////////////////////////////CLV//////////////////////////////////////////////////
        Person person = getSelectedPerson(request);
        militaryServiceForm.setCampLejeuneDisabled(!getMilitaryInfoService().calculateCLVeligibilitybyMSE(person));

        /////////////13894//////////////////////////////////////

        if(person != null)
 		{
        	CampLejeuneVerification clv = (CampLejeuneVerification)person.getSpecialFactorByType(CampLejeuneVerification.class);
        	if(getMilitaryInfoService().calculateCLVeligibilitybyMSE(person)==false)
        		militaryServiceForm.setCampLejeuneInd((clv != null && clv.getSpecialFactorIndicator() != null) ? clv.getSpecialFactorIndicator().getCode() : "");
 		}
        ////////////13894//////////////////////////////////////

        return mapping.findForward(FORWARD_DISPLAY);
    }

    /**
     * Adds an empty conflict episode record..
     *
     * @param mapping An action mapping
     * @param actionForm A form bean
     * @param request A http request from an search.jsp page
     * @param response A http response to stream data to a next page
     * @return An action forward class encapsulating information about a next page
     * @throws java.lang.Exception Thrown if failed to process
     */
    public ActionForward addConflictEpisode(ActionMapping mapping,
											ActionForm actionForm,
											HttpServletRequest request,
											HttpServletResponse response)
    throws Exception
    {
        MilitaryServiceInfoForm militaryServiceForm = (MilitaryServiceInfoForm)actionForm;
        militaryServiceForm.addNewConflictEpisode();
        militaryServiceForm.setMsdsBrokerService(super.getSystemParameterService().getMSDSServiceIndicator().toString());
        militaryServiceForm.setAddedConflictEpisode(militaryServiceForm.getConflictEpisodeIdList().size() - 1 );
        /////////////////////////////////CLV//////////////////////////////////////////////////
        Person person = getSelectedPerson(request);
        militaryServiceForm.setCampLejeuneDisabled(!getMilitaryInfoService().calculateCLVeligibilitybyMSE(person));
        /////////////13894//////////////////////////////////////

        if(person != null)
 		{
        	CampLejeuneVerification clv = (CampLejeuneVerification)person.getSpecialFactorByType(CampLejeuneVerification.class);
        	if(getMilitaryInfoService().calculateCLVeligibilitybyMSE(person)==false)
        		militaryServiceForm.setCampLejeuneInd((clv != null && clv.getSpecialFactorIndicator() != null) ? clv.getSpecialFactorIndicator().getCode() : "");
 		}
        ////////////13894//////////////////////////////////////
        return mapping.findForward(FORWARD_DISPLAY);
    }

    /**
     * Delete Oef/Oif combat episode record..
     *
     * @param mapping An action mapping
     * @param actionForm A form bean
     * @param request A http request from an search.jsp page
     * @param response A http response to stream data to a next page
     * @return An action forward class encapsulating information about a next page
     * @throws java.lang.Exception Thrown if failed to process
     */
    public ActionForward deleteOefOifCombatEpisode(ActionMapping mapping,
                                                ActionForm actionForm,
                                                HttpServletRequest request,
                                                HttpServletResponse response)
    throws Exception
    {
        System.out.println("deleteoefoif");
        MilitaryServiceInfoForm militaryServiceForm = (MilitaryServiceInfoForm)actionForm;
        int index = Integer.parseInt(militaryServiceForm.getDeletedEpisodeIndex());
        militaryServiceForm.removeOefOifCombatEpisode(index);
        militaryServiceForm.setDeletedEpisodeIndex(null);
        militaryServiceForm.setMsdsBrokerService(super.getSystemParameterService().getMSDSServiceIndicator().toString());
        /////////////////////////////////CLV//////////////////////////////////////////////////
        Person person = getSelectedPerson(request);
        militaryServiceForm.setCampLejeuneDisabled(!getMilitaryInfoService().calculateCLVeligibilitybyMSE(person));
        /////////////13894//////////////////////////////////////

        if(person != null)
 		{
        	CampLejeuneVerification clv = (CampLejeuneVerification)person.getSpecialFactorByType(CampLejeuneVerification.class);
        	if(getMilitaryInfoService().calculateCLVeligibilitybyMSE(person)==false)
        		militaryServiceForm.setCampLejeuneInd((clv != null && clv.getSpecialFactorIndicator() != null) ? clv.getSpecialFactorIndicator().getCode() : "");
 		}
        ////////////13894//////////////////////////////////////

        return mapping.findForward(FORWARD_DISPLAY);
    }

    /**
     * Delete military service episode record.
     *
     * @param mapping An action mapping
     * @param actionForm A form bean
     * @param request A http request from an search.jsp page
     * @param response A http response to stream data to a next page
     * @return An action forward class encapsulating information about a next page
     * @throws java.lang.Exception Thrown if failed to process
     */
    public ActionForward deleteMilitaryServiceEpisode(ActionMapping mapping,
                                                   ActionForm actionForm,
                                                   HttpServletRequest request,
                                                   HttpServletResponse response)
    throws Exception
    {
        MilitaryServiceInfoForm militaryServiceForm = (MilitaryServiceInfoForm)actionForm;
        int index = Integer.parseInt(militaryServiceForm.getDeletedEpisodeIndex());

        // remove all OefOifEpisodes (Source CEV) that fall withing MSE.
        removeCevOefOifEpisodesForMSE(index, militaryServiceForm);

        // remove all HEC enteref Conflict Episodes that fall withing MSE.
        removeHecConflictEpisodesForMSE(index, militaryServiceForm);

        // remove military service episode
        militaryServiceForm.removeServiceEpisode(index);
        militaryServiceForm.setDeletedEpisodeIndex(null);

        // check and remove FilipinovetarnProof
        removeFilipinoVeteranProof(militaryServiceForm);
        militaryServiceForm.setMsdsBrokerService(super.getSystemParameterService().getMSDSServiceIndicator().toString());
        /////////////////////////////////CLV//////////////////////////////////////////////////
        Person person = getSelectedPerson(request);
        militaryServiceForm.setCampLejeuneDisabled(!getMilitaryInfoService().calculateCLVeligibilitybyMSE(person));
        /////////////13894//////////////////////////////////////

        if(person != null)
 		{
        	CampLejeuneVerification clv = (CampLejeuneVerification)person.getSpecialFactorByType(CampLejeuneVerification.class);
        	if(getMilitaryInfoService().calculateCLVeligibilitybyMSE(person)==false)
        		militaryServiceForm.setCampLejeuneInd((clv != null && clv.getSpecialFactorIndicator() != null) ? clv.getSpecialFactorIndicator().getCode() : "");
 		}
        ////////////13894//////////////////////////////////////

        return mapping.findForward(FORWARD_DISPLAY);
    }

    /**
     * Delete conflict episode record..
     *
     * @param mapping An action mapping
     * @param actionForm A form bean
     * @param request A http request from an search.jsp page
     * @param response A http response to stream data to a next page
     * @return An action forward class encapsulating information about a next page
     * @throws java.lang.Exception Thrown if failed to process
     */
    public ActionForward deleteConflictEpisode(ActionMapping mapping,
                                            ActionForm actionForm,
                                            HttpServletRequest request,
                                            HttpServletResponse response)
    throws Exception
    {
        MilitaryServiceInfoForm militaryServiceForm = (MilitaryServiceInfoForm)actionForm;
        int index = Integer.parseInt(militaryServiceForm.getDeletedEpisodeIndex());
        militaryServiceForm.removeConflictEpisode(index);
        militaryServiceForm.setDeletedEpisodeIndex(null);
        militaryServiceForm.setMsdsBrokerService(super.getSystemParameterService().getMSDSServiceIndicator().toString());
        /////////////////////////////////CLV//////////////////////////////////////////////////
        Person person = getSelectedPerson(request);
        militaryServiceForm.setCampLejeuneDisabled(!getMilitaryInfoService().calculateCLVeligibilitybyMSE(person));
        /////////////13894//////////////////////////////////////

        if(person != null)
 		{
        	CampLejeuneVerification clv = (CampLejeuneVerification)person.getSpecialFactorByType(CampLejeuneVerification.class);
        	if(getMilitaryInfoService().calculateCLVeligibilitybyMSE(person)==false)
        		militaryServiceForm.setCampLejeuneInd((clv != null && clv.getSpecialFactorIndicator() != null) ? clv.getSpecialFactorIndicator().getCode() : "");
 		}
        ////////////13894//////////////////////////////////////
        return mapping.findForward(FORWARD_DISPLAY);
    }

    /**
    * Resets the military service page.
    *
    * @param mapping An action mapping
    * @param actionForm A form bean
    * @param request A http request from an search.jsp page
    * @param response A http response to stream data to a next page
    * @return An action forward class encapsulating information about a next page
    * @throws java.lang.Exception Thrown if failed to process
    */
    public ActionForward reset(ActionMapping mapping,
		       				   ActionForm actionForm,
		       				   HttpServletRequest request,
		       				   HttpServletResponse response)
    throws Exception
    {
        MilitaryServiceInfoForm militaryServiceForm = (MilitaryServiceInfoForm)actionForm;
        militaryServiceForm.reset(mapping,request);
        militaryServiceForm.setMsdsBrokerService(super.getSystemParameterService().getMSDSServiceIndicator().toString());

        return display(mapping,actionForm,request,response);
    }

    public ActionForward sendConfirmQuery(ActionMapping mapping,
			ActionForm actionForm, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		MilitaryServiceInfoForm militaryServiceForm = (MilitaryServiceInfoForm) actionForm;
		//militaryServiceForm.addNewConflictEpisode();
    	 /////////////////////////////////CLV//////////////////////////////////////////////////
    	Person person = getSelectedPerson(request);
        militaryServiceForm.setCampLejeuneDisabled(!getMilitaryInfoService().calculateCLVeligibilitybyMSE(person));
       /////////////13894//////////////////////////////////////

        if(person != null)
 		{
        	CampLejeuneVerification clv = (CampLejeuneVerification)person.getSpecialFactorByType(CampLejeuneVerification.class);
        	if(getMilitaryInfoService().calculateCLVeligibilitybyMSE(person)==false)
        		militaryServiceForm.setCampLejeuneInd((clv != null && clv.getSpecialFactorIndicator() != null) ? clv.getSpecialFactorIndicator().getCode() : "");
 		}
        ////////////13894//////////////////////////////////////
		return mapping.findForward(FORWARD_SEND_BROKER_QUERY_MESSAGE);
	}

    public ActionForward sendBrokerMessage(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception
        {

            // Get the selected person
            Person person = getSelectedPerson(request);
            if(isValidQueryInfo(person)){

            	MessagingService messagingService = getMessagingService();
                messagingService.processTriggerBroker(person) ;
            	return mapping.findForward(FORWARD_SENT_SUCCESSFULLY);
            }
            else{
            	return mapping.findForward(ERROR_FORWARD_SENT_FAILED);
            }

        }

    private boolean isValidQueryInfo(Person person) {

		if (passedNullValidation(person)) {
			if (invalidQuery(person)) {
				return false;
			} else
				return true;

		} else
			return false;

	}

	private boolean invalidQuery(Person person){

		if (person.getIdentityTraits().getLegalName()
				.getGivenName()== null
				|| person.getIdentityTraits().getLegalName()
						.getGivenName().length() == 0
				|| person.getIdentityTraits().getLegalName()
						.getGivenName().trim().length() == 0

				|| person.getIdentityTraits().getSsnText()== null
				|| person.getIdentityTraits().getSsnText()
						.length() == 0
				|| person.getIdentityTraits().getSsnText()
						.trim().length() == 0

				|| person.getIdentityTraits()
						.getLegalName().getFamilyName()== null
				|| person.getIdentityTraits()
						.getLegalName().getFamilyName().length()== 0
				|| person.getIdentityTraits()
						.getLegalName().getFamilyName().trim().length()== 0
				/*CCR13500, allow null gender to be sent
				|| person.getIdentityTraits().getGender()
						.getCode() == null
				|| person.getIdentityTraits().getGender()
						.getCode().length()== 0
				|| person.getIdentityTraits().getGender()
						.getCode().trim().length()== 0*/

				|| person.getIdentityTraits()
						.getBirthRecord().getBirthDate() == null){
			return true;

		}
		else
			return false;

	}

	public boolean passedNullValidation(Person person) {
		if (person.getIdentityTraits() != null
				&& person.getIdentityTraits().getLegalName() != null
				//CCR13500, allow null gender to be sent
				//&& person.getGender() != null
				&& person.getBirthRecord() != null) {
			return true;

		} else
			return false;

	}

    public ActionForward cancel(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception
        {
            return mapping.findForward(BACK_TO_ORIGINATOR);
        }

    public ActionMessages validateAction(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MilitaryServiceInfoForm militaryServiceForm = (MilitaryServiceInfoForm)actionForm;
        Person person = getSelectedPerson(request);
        militaryServiceForm.setCampLejeuneDisabled(!getMilitaryInfoService().calculateCLVeligibilitybyMSE(person));
        return MilitaryServiceValidator.validateMilitaryService(militaryServiceForm,request,this.getSelectedPerson(request));
    }

    protected Map getKeyMethodMap()
	{
		if(keyMethodMap == null)
		{
			keyMethodMap = new HashMap();
			keyMethodMap.put("button.display","display");
			keyMethodMap.put("button.calculatePOS","calculatePeriodOfService");
			keyMethodMap.put("button.update","updateMilitaryService");
            keyMethodMap.put("button.addOefOifCombatEpisode","addOefOifCombatEpisode");
			keyMethodMap.put("button.addMilitaryServiceEpisode","addMilitaryServiceEpisode");
			keyMethodMap.put("button.addConflictEpisode","addConflictEpisode");
            keyMethodMap.put("button.deleteOefOifCombatEpisode","deleteOefOifCombatEpisode");
            keyMethodMap.put("button.deleteMilitaryServiceEpisode","deleteMilitaryServiceEpisode");
            keyMethodMap.put("button.deleteConflictEpisode","deleteConflictEpisode");
			keyMethodMap.put("button.reset", "reset");
			keyMethodMap.put("button.sendBrokerQuery","sendConfirmQuery");
			keyMethodMap.put("button.confirm", "sendBrokerMessage");
			keyMethodMap.put("button.cancel", "cancel");
		}
        return keyMethodMap;
    }

    private void removeFilipinoVeteranProof(MilitaryServiceInfoForm militaryServiceForm) {
        List mseList = militaryServiceForm.getServiceEpisodeBranchOfServiceList();
        Iterator mseIter = mseList.iterator();
        String commonWealthBranch = ServiceBranch.CODE_F_COMMONWEALTH.getCode();
        String guerillaBranch = ServiceBranch.CODE_F_GUERILLA.getCode();
        String scoutsNewBranch = ServiceBranch.CODE_F_SCOUTS_NEW.getCode();

        boolean removeFilipinoVeteranProofInd = true;
        while (mseIter.hasNext()) {
            String serviceBranch = (String)mseIter.next();
            if (commonWealthBranch.equalsIgnoreCase(serviceBranch) ||
                    guerillaBranch.equalsIgnoreCase(serviceBranch) ||
                    scoutsNewBranch.equalsIgnoreCase(serviceBranch)) {
                removeFilipinoVeteranProofInd = false;
                break;
            }
        }

        if (removeFilipinoVeteranProofInd) {
            militaryServiceForm.setFilipinoVeteranProof(null);
        }
    }

    private void removeCevOefOifEpisodesForMSE(int serviceEpisodeIndex, MilitaryServiceInfoForm militaryServiceForm) {
        String sStartDate = militaryServiceForm.getServiceEpisodeEntryDate(serviceEpisodeIndex);
        String sEndDate = militaryServiceForm.getServiceEpisodeSeparationDate(serviceEpisodeIndex);

        Date mseStartDate = DateUtils.getDate(sStartDate);
        Date mseEnddate = DateUtils.getDate(sEndDate);

        List oefStartDateList = new ArrayList(militaryServiceForm.getOefOifCombatEpisodeStartDateList());
        List oefEnddateList = new ArrayList(militaryServiceForm.getOefOifCombatEpisodeEndDateList());
        List oefSourceList = new ArrayList(militaryServiceForm.getOefOifCombatSourceList());

        Iterator oefSourceIter = oefSourceList.iterator();
        Iterator oefStartdateIter = oefStartDateList.iterator();
        Iterator oefEnddateIter = oefEnddateList.iterator();

        String cevCode = OEFOIFSource.CODE_CENTRALIZED_ELIGIBILITY_VERIFICATION.getCode();

        int oefIndex = -1;
        while (oefStartdateIter.hasNext() && oefEnddateIter.hasNext() && oefSourceIter.hasNext()) {
            oefIndex++;
            String sOefStartdate = (String)oefStartdateIter.next();
            String sOefEndDate = (String) oefEnddateIter.next();
            String oefSource = (String) oefSourceIter.next();

            if (cevCode.equalsIgnoreCase(oefSource)) {
                Date oefStartdate = DateUtils.getDate(sOefStartdate);
                Date oefEndDate = DateUtils.getDate(sOefEndDate);
                if (oefStartdate.compareTo(mseStartDate) >= 0 &&
                        oefEndDate.compareTo(mseEnddate) <= 0) {
                    militaryServiceForm.removeOefOifCombatEpisode(oefIndex);
                    oefIndex--;
                }
            }
        }

    }

    private void removeHecConflictEpisodesForMSE(int serviceEpisodeIndex, MilitaryServiceInfoForm militaryServiceForm) {
        String sStartDate = militaryServiceForm.getServiceEpisodeEntryDate(serviceEpisodeIndex);
        String sEndDate = militaryServiceForm.getServiceEpisodeSeparationDate(serviceEpisodeIndex);

        Date mseStartDate = DateUtils.getDate(sStartDate);
        Date mseEnddate = DateUtils.getDate(sEndDate);

        List ceStartDateList = new ArrayList(militaryServiceForm.getConflictEpisodeStartDateList());
        List ceEnddateList = new ArrayList(militaryServiceForm.getConflictEpisodeEndDateList());


        Iterator ceStartdateIter = ceStartDateList.iterator();
        Iterator ceEnddateIter = ceEnddateList.iterator();


        int ceIndex = -1;
        while (ceStartdateIter.hasNext() && ceEnddateIter.hasNext()) {
            ceIndex++;
            String sceStartdate = (String)ceStartdateIter.next();
            String sceEndDate = (String) ceEnddateIter.next();

                Date ceStartdate = DateUtils.getDate(sceStartdate);
                Date ceEndDate = DateUtils.getDate(sceEndDate);
                if (ceStartdate.compareTo(mseStartDate) >= 0 &&
                        ceEndDate.compareTo(mseEnddate) <= 0) {
                    militaryServiceForm.removeConflictEpisode(ceIndex);
                    ceIndex--;
                }

        }

    }

}