/*********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.message.action;

// Java Classes

import gov.va.med.esr.common.model.lookup.MessageStatus;
import gov.va.med.esr.common.model.lookup.MessageType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.messaging.MessageLogEntryLite;
import gov.va.med.esr.service.MessageLogCriteria;
import gov.va.med.esr.ui.common.service.LookupCacheService;
import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.fw.service.pagination.SearchQueryInfo;
import gov.va.med.fw.ui.valuelist.SearchValueListAdapter;
import gov.va.med.fw.ui.valuelist.ValueListException;
import gov.va.med.fw.util.StringUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import net.mlw.vlh.ValueListInfo;

import org.apache.struts.action.ActionForm;

/**
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class MessageSearchValueListAdapter extends SearchValueListAdapter
{
    private static final long serialVersionUID = 5706057699566470164L;
    
    private LookupCacheService lookupCacheService;
    
    protected List performPostQueryProcessing(List results, SearchQueryInfo searchQueryInfo, ValueListInfo info) throws ValueListException {
        if(results == null) super.performPostQueryProcessing(results, searchQueryInfo, info);
        List wrappedResults = new ArrayList();
        for(Iterator iter=results.iterator(); iter.hasNext();) {
            wrappedResults.add(new MessageLogEntryBean((MessageLogEntryLite)iter.next()));
        }
        return wrappedResults;
    }
    
    protected void populateFormAttributes(ActionForm actionForm, SearchQueryInfo searchQueryInfo) throws ValueListException
    {
        try
        {
            MessageSearchForm form = (MessageSearchForm)actionForm;
            MessageLogCriteria criteria = (MessageLogCriteria)searchQueryInfo;
            
            if(StringUtils.isNotEmpty(form.getPersonId())) {
                criteria.setPersonId(new BigDecimal(form.getPersonId()));
            }
            
            criteria.setTransmissionDate(DateUtils.getDate(form.getTransmissionDate()));
            
            criteria.setTransmissionStartDate(DateUtils.getDate(form.getTransmissionStartDate()));
            criteria.setTransmissionEndDate(DateUtils.getDate(form.getTransmissionEndDate()));
            
            LookupCacheService lookupCacheService = this.getLookupCacheService();

            if(StringUtils.isNotEmpty(form.getFacility())) {
                criteria.setFacility((VAFacility)lookupCacheService.getByCodeFromCache(VAFacility.class,form.getFacility()));
            }
            
            if(StringUtils.isNotEmpty(form.getType())) {
                criteria.setType((MessageType)lookupCacheService.getByCodeFromCache(MessageType.class,form.getType()));
            }
            
            if(StringUtils.isNotEmpty(form.getStatus())) {
                criteria.setStatus((MessageStatus)lookupCacheService.getByCodeFromCache(MessageStatus.class,form.getStatus()));
            }
        }
        catch (Exception ex)
        {
            throw new ValueListException("Unable to copy properties from FormBean to SearchQueryInfo.", ex);
        }
    }

    public LookupCacheService getLookupCacheService() {
        return lookupCacheService;
    }

    public void setLookupCacheService(LookupCacheService lookupCacheService) {
        this.lookupCacheService = lookupCacheService;
    }
}