/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.message.action;

import java.util.Date;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

import gov.va.med.esr.ui.common.util.DateUtils;
import gov.va.med.fw.ui.struts.AbstractForm;
import gov.va.med.fw.util.StringUtils;

/**
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class MessageSearchForm extends AbstractForm {
    
    private static final long serialVersionUID = -3108745173340766342L;
    
    private String personId;
    private String transmissionDate;
    private String transmissionStartDate;
    private String transmissionEndDate;
    private String facility;
    private String type;
    private String status;

    
    public String getPersonId() {
        return personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public String getTransmissionDate() {
        return this.transmissionDate;
    }

    public void setTransmissionDate(String transmissionDate) {
        this.transmissionDate = transmissionDate;
    }

    public String getTransmissionStartDate() {
        return this.transmissionStartDate;
    }

    public void setTransmissionStartDate(String transmissionStartDate) {
        this.transmissionStartDate = transmissionStartDate;
    }

    public String getTransmissionEndDate() {
        return this.transmissionEndDate;
    }

    public void setTransmissionEndDate(String transmissionEndDate) {
        this.transmissionEndDate = transmissionEndDate;
    }

    public String getFacility() {
        return this.facility;
    }

    public void setFacility(String facility) {
        this.facility = facility;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
    
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest req) {
        
        ActionErrors errors = super.validate(mapping, req);

        // Check for at least one criteria is entered.
        /*
        boolean isOneCriteriaFilled = false;
        if(errors == null || errors.isEmpty()) {
            isOneCriteriaFilled = StringUtils.isEmpty(this.transmissionDate) ? false : true;
            isOneCriteriaFilled = (!isOneCriteriaFilled && StringUtils.isEmpty(this.transmissionStartDate)) ? false : true;
            isOneCriteriaFilled = (!isOneCriteriaFilled && StringUtils.isEmpty(this.transmissionEndDate)) ? false : true;
            isOneCriteriaFilled = (!isOneCriteriaFilled && StringUtils.isEmpty(this.facility)) ? false : true;
            isOneCriteriaFilled = (!isOneCriteriaFilled && StringUtils.isEmpty(this.type)) ? false : true;
            isOneCriteriaFilled = (!isOneCriteriaFilled && StringUtils.isEmpty(this.status)) ? false : true;
            if(!isOneCriteriaFilled) {
                errors = new ActionErrors();
                errors.add(ActionMessages.GLOBAL_MESSAGE,new ActionMessage(MessageConstants.ONE_CRITERIA_REQUIRED));
                return errors;
            }
        }*/
        
        // Check if both Transmission date and the Range are entered.
        if(errors == null || errors.isEmpty()) 
            if(StringUtils.isNotEmpty(this.transmissionDate) && 
               (StringUtils.isNotEmpty(this.transmissionStartDate) || StringUtils.isNotEmpty(this.transmissionEndDate))) {
                errors = new ActionErrors();
                errors.add(ActionMessages.GLOBAL_MESSAGE,new ActionMessage(MessageConstants.EITHER_ONE_REQUIRED));
                return errors;
        }
        
        // Check if the Start date is after end date.
        if(errors == null || errors.isEmpty()) {
            Date startDate = DateUtils.getDate(this.transmissionStartDate);
            Date endDate = DateUtils.getDate(this.transmissionEndDate);
            if(startDate != null && endDate != null && startDate.after(endDate)) {
                errors = new ActionErrors();
                errors.add(ActionMessages.GLOBAL_MESSAGE,new ActionMessage(MessageConstants.TRANSMISSION_START_END_DATE_CONFLICT));
                return errors;
            }
        }

        return errors;
    }
    
    public void clear() {
        this.personId = null;
        this.transmissionDate = null;
        this.transmissionStartDate = null;
        this.transmissionEndDate = null;
        this.facility = null;
        this.type = null;
        this.status = null;
    }
}
